package odata.msgraph.client.beta.entity.collection.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.github.davidmoten.guavamini.Preconditions;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.util.Map;

import odata.msgraph.client.beta.complex.TeleconferenceDeviceQuality;
import odata.msgraph.client.beta.entity.Call;
import odata.msgraph.client.beta.entity.request.AudioRoutingGroupRequest;
import odata.msgraph.client.beta.entity.request.CallRequest;
import odata.msgraph.client.beta.entity.request.CommsOperationRequest;
import odata.msgraph.client.beta.entity.request.ParticipantRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

public class CallCollectionRequest extends CollectionPageEntityRequest<Call, CallRequest>{

    protected ContextPath contextPath;

    public CallCollectionRequest(ContextPath contextPath) {
        super(contextPath, Call.class, cp -> new CallRequest(cp), SchemaInfo.INSTANCE);
        this.contextPath = contextPath;
    }

    public ParticipantCollectionRequest participants() {
        return new ParticipantCollectionRequest(contextPath.addSegment("participants"));
    }

    public ParticipantRequest participants(String id) {
        return new ParticipantRequest(contextPath.addSegment("participants").addKeys(new NameValue(id.toString())));
    }

    public AudioRoutingGroupCollectionRequest audioRoutingGroups() {
        return new AudioRoutingGroupCollectionRequest(contextPath.addSegment("audioRoutingGroups"));
    }

    public AudioRoutingGroupRequest audioRoutingGroups(String id) {
        return new AudioRoutingGroupRequest(contextPath.addSegment("audioRoutingGroups").addKeys(new NameValue(id.toString())));
    }

    public CommsOperationCollectionRequest operations() {
        return new CommsOperationCollectionRequest(contextPath.addSegment("operations"));
    }

    public CommsOperationRequest operations(String id) {
        return new CommsOperationRequest(contextPath.addSegment("operations").addKeys(new NameValue(id.toString())));
    }

    @Action(name = "logTeleconferenceDeviceQuality")
    @JsonIgnore
    public ActionRequestNoReturn logTeleconferenceDeviceQuality(TeleconferenceDeviceQuality quality) {
        Preconditions.checkNotNull(quality, "quality cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("quality", "microsoft.graph.teleconferenceDeviceQuality", quality)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.logTeleconferenceDeviceQuality"), _parameters);
    }

}
