package odata.msgraph.client.beta.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import odata.msgraph.client.beta.entity.CalendarGroup;
import odata.msgraph.client.beta.entity.request.CalendarGroupRequest;
import odata.msgraph.client.beta.entity.request.CalendarRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

public class CalendarGroupCollectionRequest extends CollectionPageEntityRequest<CalendarGroup, CalendarGroupRequest>{

    protected ContextPath contextPath;

    public CalendarGroupCollectionRequest(ContextPath contextPath) {
        super(contextPath, CalendarGroup.class, cp -> new CalendarGroupRequest(cp), SchemaInfo.INSTANCE);
        this.contextPath = contextPath;
    }

    public CalendarCollectionRequest calendars() {
        return new CalendarCollectionRequest(contextPath.addSegment("calendars"));
    }

    public CalendarRequest calendars(String id) {
        return new CalendarRequest(contextPath.addSegment("calendars").addKeys(new NameValue(id.toString())));
    }

}
