package odata.msgraph.client.beta.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import odata.msgraph.client.beta.entity.Calendar;
import odata.msgraph.client.beta.entity.request.CalendarPermissionRequest;
import odata.msgraph.client.beta.entity.request.CalendarRequest;
import odata.msgraph.client.beta.entity.request.EventRequest;
import odata.msgraph.client.beta.entity.request.MultiValueLegacyExtendedPropertyRequest;
import odata.msgraph.client.beta.entity.request.SingleValueLegacyExtendedPropertyRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

public class CalendarCollectionRequest extends CollectionPageEntityRequest<Calendar, CalendarRequest>{

    protected ContextPath contextPath;

    public CalendarCollectionRequest(ContextPath contextPath) {
        super(contextPath, Calendar.class, cp -> new CalendarRequest(cp), SchemaInfo.INSTANCE);
        this.contextPath = contextPath;
    }

    public SingleValueLegacyExtendedPropertyCollectionRequest singleValueExtendedProperties() {
        return new SingleValueLegacyExtendedPropertyCollectionRequest(contextPath.addSegment("singleValueExtendedProperties"));
    }

    public SingleValueLegacyExtendedPropertyRequest singleValueExtendedProperties(String id) {
        return new SingleValueLegacyExtendedPropertyRequest(contextPath.addSegment("singleValueExtendedProperties").addKeys(new NameValue(id.toString())));
    }

    public MultiValueLegacyExtendedPropertyCollectionRequest multiValueExtendedProperties() {
        return new MultiValueLegacyExtendedPropertyCollectionRequest(contextPath.addSegment("multiValueExtendedProperties"));
    }

    public MultiValueLegacyExtendedPropertyRequest multiValueExtendedProperties(String id) {
        return new MultiValueLegacyExtendedPropertyRequest(contextPath.addSegment("multiValueExtendedProperties").addKeys(new NameValue(id.toString())));
    }

    public CalendarPermissionCollectionRequest calendarPermissions() {
        return new CalendarPermissionCollectionRequest(contextPath.addSegment("calendarPermissions"));
    }

    public CalendarPermissionRequest calendarPermissions(String id) {
        return new CalendarPermissionRequest(contextPath.addSegment("calendarPermissions").addKeys(new NameValue(id.toString())));
    }

    public EventCollectionRequest events() {
        return new EventCollectionRequest(contextPath.addSegment("events"));
    }

    public EventRequest events(String id) {
        return new EventRequest(contextPath.addSegment("events").addKeys(new NameValue(id.toString())));
    }

    public EventCollectionRequest calendarView() {
        return new EventCollectionRequest(contextPath.addSegment("calendarView"));
    }

    public EventRequest calendarView(String id) {
        return new EventRequest(contextPath.addSegment("calendarView").addKeys(new NameValue(id.toString())));
    }

}
