package odata.msgraph.client.beta.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import odata.msgraph.client.beta.entity.BookingBusiness;
import odata.msgraph.client.beta.entity.request.BookingAppointmentRequest;
import odata.msgraph.client.beta.entity.request.BookingBusinessRequest;
import odata.msgraph.client.beta.entity.request.BookingCustomerRequest;
import odata.msgraph.client.beta.entity.request.BookingServiceRequest;
import odata.msgraph.client.beta.entity.request.BookingStaffMemberRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

public class BookingBusinessCollectionRequest extends CollectionPageEntityRequest<BookingBusiness, BookingBusinessRequest>{

    protected ContextPath contextPath;

    public BookingBusinessCollectionRequest(ContextPath contextPath) {
        super(contextPath, BookingBusiness.class, cp -> new BookingBusinessRequest(cp), SchemaInfo.INSTANCE);
        this.contextPath = contextPath;
    }

    public BookingAppointmentCollectionRequest appointments() {
        return new BookingAppointmentCollectionRequest(contextPath.addSegment("appointments"));
    }

    public BookingAppointmentRequest appointments(String id) {
        return new BookingAppointmentRequest(contextPath.addSegment("appointments").addKeys(new NameValue(id.toString())));
    }

    public BookingAppointmentCollectionRequest calendarView() {
        return new BookingAppointmentCollectionRequest(contextPath.addSegment("calendarView"));
    }

    public BookingAppointmentRequest calendarView(String id) {
        return new BookingAppointmentRequest(contextPath.addSegment("calendarView").addKeys(new NameValue(id.toString())));
    }

    public BookingCustomerCollectionRequest customers() {
        return new BookingCustomerCollectionRequest(contextPath.addSegment("customers"));
    }

    public BookingCustomerRequest customers(String id) {
        return new BookingCustomerRequest(contextPath.addSegment("customers").addKeys(new NameValue(id.toString())));
    }

    public BookingServiceCollectionRequest services() {
        return new BookingServiceCollectionRequest(contextPath.addSegment("services"));
    }

    public BookingServiceRequest services(String id) {
        return new BookingServiceRequest(contextPath.addSegment("services").addKeys(new NameValue(id.toString())));
    }

    public BookingStaffMemberCollectionRequest staffMembers() {
        return new BookingStaffMemberCollectionRequest(contextPath.addSegment("staffMembers"));
    }

    public BookingStaffMemberRequest staffMembers(String id) {
        return new BookingStaffMemberRequest(contextPath.addSegment("staffMembers").addKeys(new NameValue(id.toString())));
    }

}
