package odata.msgraph.client.beta.entity.collection.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.github.davidmoten.guavamini.Preconditions;
import com.github.davidmoten.odata.client.ActionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.util.Map;

import odata.msgraph.client.beta.complex.AttachmentItem;
import odata.msgraph.client.beta.complex.UploadSession;
import odata.msgraph.client.beta.entity.Attachment;
import odata.msgraph.client.beta.entity.request.AttachmentRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

public class AttachmentCollectionRequest extends CollectionPageEntityRequest<Attachment, AttachmentRequest>{

    protected ContextPath contextPath;

    public AttachmentCollectionRequest(ContextPath contextPath) {
        super(contextPath, Attachment.class, cp -> new AttachmentRequest(cp), SchemaInfo.INSTANCE);
        this.contextPath = contextPath;
    }

    @Action(name = "createUploadSession")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<UploadSession> createUploadSession(AttachmentItem attachmentItem) {
        Preconditions.checkNotNull(attachmentItem, "attachmentItem cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("AttachmentItem", "microsoft.graph.attachmentItem", attachmentItem)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<UploadSession>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.createUploadSession"), UploadSession.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

}
