package odata.msgraph.client.beta.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import odata.msgraph.client.beta.entity.ApprovalWorkflowProvider;
import odata.msgraph.client.beta.entity.request.ApprovalWorkflowProviderRequest;
import odata.msgraph.client.beta.entity.request.BusinessFlowRequest;
import odata.msgraph.client.beta.entity.request.GovernancePolicyTemplateRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

public class ApprovalWorkflowProviderCollectionRequest extends CollectionPageEntityRequest<ApprovalWorkflowProvider, ApprovalWorkflowProviderRequest>{

    protected ContextPath contextPath;

    public ApprovalWorkflowProviderCollectionRequest(ContextPath contextPath) {
        super(contextPath, ApprovalWorkflowProvider.class, cp -> new ApprovalWorkflowProviderRequest(cp), SchemaInfo.INSTANCE);
        this.contextPath = contextPath;
    }

    public BusinessFlowCollectionRequest businessFlows() {
        return new BusinessFlowCollectionRequest(contextPath.addSegment("businessFlows"));
    }

    public BusinessFlowRequest businessFlows(String id) {
        return new BusinessFlowRequest(contextPath.addSegment("businessFlows").addKeys(new NameValue(id.toString())));
    }

    public GovernancePolicyTemplateCollectionRequest policyTemplates() {
        return new GovernancePolicyTemplateCollectionRequest(contextPath.addSegment("policyTemplates"));
    }

    public GovernancePolicyTemplateRequest policyTemplates(String id) {
        return new GovernancePolicyTemplateRequest(contextPath.addSegment("policyTemplates").addKeys(new NameValue(id.toString())));
    }

    public BusinessFlowCollectionRequest businessFlowsWithRequestsAwaitingMyDecision() {
        return new BusinessFlowCollectionRequest(contextPath.addSegment("businessFlowsWithRequestsAwaitingMyDecision"));
    }

    public BusinessFlowRequest businessFlowsWithRequestsAwaitingMyDecision(String id) {
        return new BusinessFlowRequest(contextPath.addSegment("businessFlowsWithRequestsAwaitingMyDecision").addKeys(new NameValue(id.toString())));
    }

}
