package odata.msgraph.client.beta.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import odata.msgraph.client.beta.entity.Approval;
import odata.msgraph.client.beta.entity.request.ApprovalRequest;
import odata.msgraph.client.beta.entity.request.ApprovalStepRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

public class ApprovalCollectionRequest extends CollectionPageEntityRequest<Approval, ApprovalRequest>{

    protected ContextPath contextPath;

    public ApprovalCollectionRequest(ContextPath contextPath) {
        super(contextPath, Approval.class, cp -> new ApprovalRequest(cp), SchemaInfo.INSTANCE);
        this.contextPath = contextPath;
    }

    public ApprovalStepCollectionRequest pendingSteps() {
        return new ApprovalStepCollectionRequest(contextPath.addSegment("pendingSteps"));
    }

    public ApprovalStepRequest pendingSteps(String id) {
        return new ApprovalStepRequest(contextPath.addSegment("pendingSteps").addKeys(new NameValue(id.toString())));
    }

    public ApprovalStepCollectionRequest completedSteps() {
        return new ApprovalStepCollectionRequest(contextPath.addSegment("completedSteps"));
    }

    public ApprovalStepRequest completedSteps(String id) {
        return new ApprovalStepRequest(contextPath.addSegment("completedSteps").addKeys(new NameValue(id.toString())));
    }


}
