package odata.msgraph.client.beta.entity.collection.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.CollectionPageNonEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.annotation.Function;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.util.Map;

import odata.msgraph.client.beta.entity.Application;
import odata.msgraph.client.beta.entity.request.ApplicationRequest;
import odata.msgraph.client.beta.entity.request.DirectoryObjectRequest;
import odata.msgraph.client.beta.entity.request.ExtensionPropertyRequest;
import odata.msgraph.client.beta.entity.request.HomeRealmDiscoveryPolicyRequest;
import odata.msgraph.client.beta.entity.request.TokenIssuancePolicyRequest;
import odata.msgraph.client.beta.entity.request.TokenLifetimePolicyRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

public class ApplicationCollectionRequest extends CollectionPageEntityRequest<Application, ApplicationRequest>{

    protected ContextPath contextPath;

    public ApplicationCollectionRequest(ContextPath contextPath) {
        super(contextPath, Application.class, cp -> new ApplicationRequest(cp), SchemaInfo.INSTANCE);
        this.contextPath = contextPath;
    }

    public ExtensionPropertyCollectionRequest extensionProperties() {
        return new ExtensionPropertyCollectionRequest(contextPath.addSegment("extensionProperties"));
    }

    public ExtensionPropertyRequest extensionProperties(String id) {
        return new ExtensionPropertyRequest(contextPath.addSegment("extensionProperties").addKeys(new NameValue(id.toString())));
    }


    public DirectoryObjectCollectionRequest owners() {
        return new DirectoryObjectCollectionRequest(contextPath.addSegment("owners"));
    }

    public DirectoryObjectRequest owners(String id) {
        return new DirectoryObjectRequest(contextPath.addSegment("owners").addKeys(new NameValue(id.toString())));
    }

    public HomeRealmDiscoveryPolicyCollectionRequest homeRealmDiscoveryPolicies() {
        return new HomeRealmDiscoveryPolicyCollectionRequest(contextPath.addSegment("homeRealmDiscoveryPolicies"));
    }

    public HomeRealmDiscoveryPolicyRequest homeRealmDiscoveryPolicies(String id) {
        return new HomeRealmDiscoveryPolicyRequest(contextPath.addSegment("homeRealmDiscoveryPolicies").addKeys(new NameValue(id.toString())));
    }

    public TokenIssuancePolicyCollectionRequest tokenIssuancePolicies() {
        return new TokenIssuancePolicyCollectionRequest(contextPath.addSegment("tokenIssuancePolicies"));
    }

    public TokenIssuancePolicyRequest tokenIssuancePolicies(String id) {
        return new TokenIssuancePolicyRequest(contextPath.addSegment("tokenIssuancePolicies").addKeys(new NameValue(id.toString())));
    }

    public TokenLifetimePolicyCollectionRequest tokenLifetimePolicies() {
        return new TokenLifetimePolicyCollectionRequest(contextPath.addSegment("tokenLifetimePolicies"));
    }

    public TokenLifetimePolicyRequest tokenLifetimePolicies(String id) {
        return new TokenLifetimePolicyRequest(contextPath.addSegment("tokenLifetimePolicies").addKeys(new NameValue(id.toString())));
    }



    @Function(name = "delta")
    @JsonIgnore
    public CollectionPageNonEntityRequest<Application> delta() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.delta"), Application.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

}
