package odata.msgraph.client.beta.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import odata.msgraph.client.beta.entity.AppleUserInitiatedEnrollmentProfile;
import odata.msgraph.client.beta.entity.request.AppleEnrollmentProfileAssignmentRequest;
import odata.msgraph.client.beta.entity.request.AppleUserInitiatedEnrollmentProfileRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

public class AppleUserInitiatedEnrollmentProfileCollectionRequest extends CollectionPageEntityRequest<AppleUserInitiatedEnrollmentProfile, AppleUserInitiatedEnrollmentProfileRequest>{

    protected ContextPath contextPath;

    public AppleUserInitiatedEnrollmentProfileCollectionRequest(ContextPath contextPath) {
        super(contextPath, AppleUserInitiatedEnrollmentProfile.class, cp -> new AppleUserInitiatedEnrollmentProfileRequest(cp), SchemaInfo.INSTANCE);
        this.contextPath = contextPath;
    }

    public AppleEnrollmentProfileAssignmentCollectionRequest assignments() {
        return new AppleEnrollmentProfileAssignmentCollectionRequest(contextPath.addSegment("assignments"));
    }

    public AppleEnrollmentProfileAssignmentRequest assignments(String id) {
        return new AppleEnrollmentProfileAssignmentRequest(contextPath.addSegment("assignments").addKeys(new NameValue(id.toString())));
    }

}
