package odata.msgraph.client.beta.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import odata.msgraph.client.beta.entity.AppConsentRequest;
import odata.msgraph.client.beta.entity.request.AppConsentRequestRequest;
import odata.msgraph.client.beta.entity.request.UserConsentRequestRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

public class AppConsentRequestCollectionRequest extends CollectionPageEntityRequest<AppConsentRequest, AppConsentRequestRequest>{

    protected ContextPath contextPath;

    public AppConsentRequestCollectionRequest(ContextPath contextPath) {
        super(contextPath, AppConsentRequest.class, cp -> new AppConsentRequestRequest(cp), SchemaInfo.INSTANCE);
        this.contextPath = contextPath;
    }

    public UserConsentRequestCollectionRequest userConsentRequests() {
        return new UserConsentRequestCollectionRequest(contextPath.addSegment("userConsentRequests"));
    }

    public UserConsentRequestRequest userConsentRequests(String id) {
        return new UserConsentRequestRequest(contextPath.addSegment("userConsentRequests").addKeys(new NameValue(id.toString())));
    }

}
