package odata.msgraph.client.beta.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import odata.msgraph.client.beta.entity.Agreement;
import odata.msgraph.client.beta.entity.request.AgreementFileRequest;
import odata.msgraph.client.beta.entity.request.AgreementRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

public class AgreementCollectionRequest extends CollectionPageEntityRequest<Agreement, AgreementRequest>{

    protected ContextPath contextPath;

    public AgreementCollectionRequest(ContextPath contextPath) {
        super(contextPath, Agreement.class, cp -> new AgreementRequest(cp), SchemaInfo.INSTANCE);
        this.contextPath = contextPath;
    }

    public AgreementFileCollectionRequest files() {
        return new AgreementFileCollectionRequest(contextPath.addSegment("files"));
    }

    public AgreementFileRequest files(String id) {
        return new AgreementFileRequest(contextPath.addSegment("files").addKeys(new NameValue(id.toString())));
    }

}
