package odata.msgraph.client.beta.entity.collection.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.CollectionPageNonEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.annotation.Function;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.util.Map;

import odata.msgraph.client.beta.entity.AdministrativeUnit;
import odata.msgraph.client.beta.entity.request.AdministrativeUnitRequest;
import odata.msgraph.client.beta.entity.request.DirectoryObjectRequest;
import odata.msgraph.client.beta.entity.request.ExtensionRequest;
import odata.msgraph.client.beta.entity.request.ScopedRoleMembershipRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

public class AdministrativeUnitCollectionRequest extends CollectionPageEntityRequest<AdministrativeUnit, AdministrativeUnitRequest>{

    protected ContextPath contextPath;

    public AdministrativeUnitCollectionRequest(ContextPath contextPath) {
        super(contextPath, AdministrativeUnit.class, cp -> new AdministrativeUnitRequest(cp), SchemaInfo.INSTANCE);
        this.contextPath = contextPath;
    }

    public DirectoryObjectCollectionRequest members() {
        return new DirectoryObjectCollectionRequest(contextPath.addSegment("members"));
    }

    public DirectoryObjectRequest members(String id) {
        return new DirectoryObjectRequest(contextPath.addSegment("members").addKeys(new NameValue(id.toString())));
    }

    public ScopedRoleMembershipCollectionRequest scopedRoleMembers() {
        return new ScopedRoleMembershipCollectionRequest(contextPath.addSegment("scopedRoleMembers"));
    }

    public ScopedRoleMembershipRequest scopedRoleMembers(String id) {
        return new ScopedRoleMembershipRequest(contextPath.addSegment("scopedRoleMembers").addKeys(new NameValue(id.toString())));
    }

    public ExtensionCollectionRequest extensions() {
        return new ExtensionCollectionRequest(contextPath.addSegment("extensions"));
    }

    public ExtensionRequest extensions(String id) {
        return new ExtensionRequest(contextPath.addSegment("extensions").addKeys(new NameValue(id.toString())));
    }

    @Function(name = "delta")
    @JsonIgnore
    public CollectionPageNonEntityRequest<AdministrativeUnit> delta() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.delta"), AdministrativeUnit.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

}
