package odata.msgraph.client.beta.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import odata.msgraph.client.beta.entity.AccessReviewScheduleDefinition;
import odata.msgraph.client.beta.entity.request.AccessReviewInstanceRequest;
import odata.msgraph.client.beta.entity.request.AccessReviewScheduleDefinitionRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

public class AccessReviewScheduleDefinitionCollectionRequest extends CollectionPageEntityRequest<AccessReviewScheduleDefinition, AccessReviewScheduleDefinitionRequest>{

    protected ContextPath contextPath;

    public AccessReviewScheduleDefinitionCollectionRequest(ContextPath contextPath) {
        super(contextPath, AccessReviewScheduleDefinition.class, cp -> new AccessReviewScheduleDefinitionRequest(cp), SchemaInfo.INSTANCE);
        this.contextPath = contextPath;
    }

    public AccessReviewInstanceCollectionRequest instances() {
        return new AccessReviewInstanceCollectionRequest(contextPath.addSegment("instances"));
    }

    public AccessReviewInstanceRequest instances(String id) {
        return new AccessReviewInstanceRequest(contextPath.addSegment("instances").addKeys(new NameValue(id.toString())));
    }

}
