package odata.msgraph.client.beta.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import odata.msgraph.client.beta.entity.AccessReviewInstance;
import odata.msgraph.client.beta.entity.request.AccessReviewInstanceDecisionItemRequest;
import odata.msgraph.client.beta.entity.request.AccessReviewInstanceRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

public class AccessReviewInstanceCollectionRequest extends CollectionPageEntityRequest<AccessReviewInstance, AccessReviewInstanceRequest>{

    protected ContextPath contextPath;

    public AccessReviewInstanceCollectionRequest(ContextPath contextPath) {
        super(contextPath, AccessReviewInstance.class, cp -> new AccessReviewInstanceRequest(cp), SchemaInfo.INSTANCE);
        this.contextPath = contextPath;
    }

    public AccessReviewInstanceDecisionItemCollectionRequest decisions() {
        return new AccessReviewInstanceDecisionItemCollectionRequest(contextPath.addSegment("decisions"));
    }

    public AccessReviewInstanceDecisionItemRequest decisions(String id) {
        return new AccessReviewInstanceDecisionItemRequest(contextPath.addSegment("decisions").addKeys(new NameValue(id.toString())));
    }


}
