package odata.msgraph.client.beta.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import odata.msgraph.client.beta.entity.AccessReview;
import odata.msgraph.client.beta.entity.request.AccessReviewDecisionRequest;
import odata.msgraph.client.beta.entity.request.AccessReviewRequest;
import odata.msgraph.client.beta.entity.request.AccessReviewReviewerRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

public class AccessReviewCollectionRequest extends CollectionPageEntityRequest<AccessReview, AccessReviewRequest>{

    protected ContextPath contextPath;

    public AccessReviewCollectionRequest(ContextPath contextPath) {
        super(contextPath, AccessReview.class, cp -> new AccessReviewRequest(cp), SchemaInfo.INSTANCE);
        this.contextPath = contextPath;
    }

    public AccessReviewReviewerCollectionRequest reviewers() {
        return new AccessReviewReviewerCollectionRequest(contextPath.addSegment("reviewers"));
    }

    public AccessReviewReviewerRequest reviewers(String id) {
        return new AccessReviewReviewerRequest(contextPath.addSegment("reviewers").addKeys(new NameValue(id.toString())));
    }

    public AccessReviewDecisionCollectionRequest decisions() {
        return new AccessReviewDecisionCollectionRequest(contextPath.addSegment("decisions"));
    }

    public AccessReviewDecisionRequest decisions(String id) {
        return new AccessReviewDecisionRequest(contextPath.addSegment("decisions").addKeys(new NameValue(id.toString())));
    }

    public AccessReviewDecisionCollectionRequest myDecisions() {
        return new AccessReviewDecisionCollectionRequest(contextPath.addSegment("myDecisions"));
    }

    public AccessReviewDecisionRequest myDecisions(String id) {
        return new AccessReviewDecisionRequest(contextPath.addSegment("myDecisions").addKeys(new NameValue(id.toString())));
    }

    public AccessReviewCollectionRequest instances() {
        return new AccessReviewCollectionRequest(contextPath.addSegment("instances"));
    }

    public AccessReviewRequest instances(String id) {
        return new AccessReviewRequest(contextPath.addSegment("instances").addKeys(new NameValue(id.toString())));
    }

}
