package odata.msgraph.client.beta.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import odata.msgraph.client.beta.entity.AccessPackageResource;
import odata.msgraph.client.beta.entity.request.AccessPackageResourceRequest;
import odata.msgraph.client.beta.entity.request.AccessPackageResourceRoleRequest;
import odata.msgraph.client.beta.entity.request.AccessPackageResourceScopeRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

public class AccessPackageResourceCollectionRequest extends CollectionPageEntityRequest<AccessPackageResource, AccessPackageResourceRequest>{

    protected ContextPath contextPath;

    public AccessPackageResourceCollectionRequest(ContextPath contextPath) {
        super(contextPath, AccessPackageResource.class, cp -> new AccessPackageResourceRequest(cp), SchemaInfo.INSTANCE);
        this.contextPath = contextPath;
    }

    public AccessPackageResourceScopeCollectionRequest accessPackageResourceScopes() {
        return new AccessPackageResourceScopeCollectionRequest(contextPath.addSegment("accessPackageResourceScopes"));
    }

    public AccessPackageResourceScopeRequest accessPackageResourceScopes(String id) {
        return new AccessPackageResourceScopeRequest(contextPath.addSegment("accessPackageResourceScopes").addKeys(new NameValue(id.toString())));
    }

    public AccessPackageResourceRoleCollectionRequest accessPackageResourceRoles() {
        return new AccessPackageResourceRoleCollectionRequest(contextPath.addSegment("accessPackageResourceRoles"));
    }

    public AccessPackageResourceRoleRequest accessPackageResourceRoles(String id) {
        return new AccessPackageResourceRoleRequest(contextPath.addSegment("accessPackageResourceRoles").addKeys(new NameValue(id.toString())));
    }

}
