package odata.msgraph.client.beta.entity.collection.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.CollectionPageNonEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.annotation.Function;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.util.Map;

import odata.msgraph.client.beta.entity.AccessPackage;
import odata.msgraph.client.beta.entity.request.AccessPackageAssignmentPolicyRequest;
import odata.msgraph.client.beta.entity.request.AccessPackageRequest;
import odata.msgraph.client.beta.entity.request.AccessPackageResourceRoleScopeRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

public class AccessPackageCollectionRequest extends CollectionPageEntityRequest<AccessPackage, AccessPackageRequest>{

    protected ContextPath contextPath;

    public AccessPackageCollectionRequest(ContextPath contextPath) {
        super(contextPath, AccessPackage.class, cp -> new AccessPackageRequest(cp), SchemaInfo.INSTANCE);
        this.contextPath = contextPath;
    }


    public AccessPackageResourceRoleScopeCollectionRequest accessPackageResourceRoleScopes() {
        return new AccessPackageResourceRoleScopeCollectionRequest(contextPath.addSegment("accessPackageResourceRoleScopes"));
    }

    public AccessPackageResourceRoleScopeRequest accessPackageResourceRoleScopes(String id) {
        return new AccessPackageResourceRoleScopeRequest(contextPath.addSegment("accessPackageResourceRoleScopes").addKeys(new NameValue(id.toString())));
    }

    public AccessPackageAssignmentPolicyCollectionRequest accessPackageAssignmentPolicies() {
        return new AccessPackageAssignmentPolicyCollectionRequest(contextPath.addSegment("accessPackageAssignmentPolicies"));
    }

    public AccessPackageAssignmentPolicyRequest accessPackageAssignmentPolicies(String id) {
        return new AccessPackageAssignmentPolicyRequest(contextPath.addSegment("accessPackageAssignmentPolicies").addKeys(new NameValue(id.toString())));
    }

    @Function(name = "Search")
    @JsonIgnore
    public CollectionPageNonEntityRequest<AccessPackage> search() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.Search"), AccessPackage.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

}
