package odata.msgraph.client.beta.entity.collection.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.CollectionPageNonEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.annotation.Function;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.util.Map;

import odata.msgraph.client.beta.entity.AccessPackageCatalog;
import odata.msgraph.client.beta.entity.request.AccessPackageCatalogRequest;
import odata.msgraph.client.beta.entity.request.AccessPackageRequest;
import odata.msgraph.client.beta.entity.request.AccessPackageResourceRequest;
import odata.msgraph.client.beta.entity.request.AccessPackageResourceRoleRequest;
import odata.msgraph.client.beta.entity.request.AccessPackageResourceScopeRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

public class AccessPackageCatalogCollectionRequest extends CollectionPageEntityRequest<AccessPackageCatalog, AccessPackageCatalogRequest>{

    protected ContextPath contextPath;

    public AccessPackageCatalogCollectionRequest(ContextPath contextPath) {
        super(contextPath, AccessPackageCatalog.class, cp -> new AccessPackageCatalogRequest(cp), SchemaInfo.INSTANCE);
        this.contextPath = contextPath;
    }

    public AccessPackageResourceCollectionRequest accessPackageResources() {
        return new AccessPackageResourceCollectionRequest(contextPath.addSegment("accessPackageResources"));
    }

    public AccessPackageResourceRequest accessPackageResources(String id) {
        return new AccessPackageResourceRequest(contextPath.addSegment("accessPackageResources").addKeys(new NameValue(id.toString())));
    }

    public AccessPackageResourceRoleCollectionRequest accessPackageResourceRoles() {
        return new AccessPackageResourceRoleCollectionRequest(contextPath.addSegment("accessPackageResourceRoles"));
    }

    public AccessPackageResourceRoleRequest accessPackageResourceRoles(String id) {
        return new AccessPackageResourceRoleRequest(contextPath.addSegment("accessPackageResourceRoles").addKeys(new NameValue(id.toString())));
    }

    public AccessPackageResourceScopeCollectionRequest accessPackageResourceScopes() {
        return new AccessPackageResourceScopeCollectionRequest(contextPath.addSegment("accessPackageResourceScopes"));
    }

    public AccessPackageResourceScopeRequest accessPackageResourceScopes(String id) {
        return new AccessPackageResourceScopeRequest(contextPath.addSegment("accessPackageResourceScopes").addKeys(new NameValue(id.toString())));
    }

    public AccessPackageCollectionRequest accessPackages() {
        return new AccessPackageCollectionRequest(contextPath.addSegment("accessPackages"));
    }

    public AccessPackageRequest accessPackages(String id) {
        return new AccessPackageRequest(contextPath.addSegment("accessPackages").addKeys(new NameValue(id.toString())));
    }

    @Function(name = "Search")
    @JsonIgnore
    public CollectionPageNonEntityRequest<AccessPackageCatalog> search() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.Search"), AccessPackageCatalog.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

}
