package odata.msgraph.client.beta.entity.collection.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.CollectionPageNonEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.annotation.Function;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.util.Map;

import odata.msgraph.client.beta.entity.AccessPackageAssignmentResourceRole;
import odata.msgraph.client.beta.entity.request.AccessPackageAssignmentRequest;
import odata.msgraph.client.beta.entity.request.AccessPackageAssignmentResourceRoleRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

public class AccessPackageAssignmentResourceRoleCollectionRequest extends CollectionPageEntityRequest<AccessPackageAssignmentResourceRole, AccessPackageAssignmentResourceRoleRequest>{

    protected ContextPath contextPath;

    public AccessPackageAssignmentResourceRoleCollectionRequest(ContextPath contextPath) {
        super(contextPath, AccessPackageAssignmentResourceRole.class, cp -> new AccessPackageAssignmentResourceRoleRequest(cp), SchemaInfo.INSTANCE);
        this.contextPath = contextPath;
    }




    public AccessPackageAssignmentCollectionRequest accessPackageAssignments() {
        return new AccessPackageAssignmentCollectionRequest(contextPath.addSegment("accessPackageAssignments"));
    }

    public AccessPackageAssignmentRequest accessPackageAssignments(String id) {
        return new AccessPackageAssignmentRequest(contextPath.addSegment("accessPackageAssignments").addKeys(new NameValue(id.toString())));
    }

    @Function(name = "My")
    @JsonIgnore
    public CollectionPageNonEntityRequest<AccessPackageAssignmentResourceRole> my() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.My"), AccessPackageAssignmentResourceRole.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

}
