package odata.msgraph.client.beta.entity.collection.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.CollectionPageNonEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.annotation.Function;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.util.Map;

import odata.msgraph.client.beta.entity.AccessPackageAssignmentRequest;
import odata.msgraph.client.beta.entity.request.AccessPackageAssignmentRequestRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

public class AccessPackageAssignmentRequestCollectionRequest extends CollectionPageEntityRequest<AccessPackageAssignmentRequest, AccessPackageAssignmentRequestRequest>{

    protected ContextPath contextPath;

    public AccessPackageAssignmentRequestCollectionRequest(ContextPath contextPath) {
        super(contextPath, AccessPackageAssignmentRequest.class, cp -> new AccessPackageAssignmentRequestRequest(cp), SchemaInfo.INSTANCE);
        this.contextPath = contextPath;
    }




    @Function(name = "My")
    @JsonIgnore
    public CollectionPageNonEntityRequest<AccessPackageAssignmentRequest> my() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.My"), AccessPackageAssignmentRequest.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

}
