package odata.msgraph.client.beta.entity.collection.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.CollectionPageNonEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.annotation.Function;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.util.Map;

import odata.msgraph.client.beta.entity.AccessPackageAssignment;
import odata.msgraph.client.beta.entity.request.AccessPackageAssignmentRequest;
import odata.msgraph.client.beta.entity.request.AccessPackageAssignmentRequestRequest;
import odata.msgraph.client.beta.entity.request.AccessPackageAssignmentResourceRoleRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

public class AccessPackageAssignmentCollectionRequest extends CollectionPageEntityRequest<AccessPackageAssignment, AccessPackageAssignmentRequest>{

    protected ContextPath contextPath;

    public AccessPackageAssignmentCollectionRequest(ContextPath contextPath) {
        super(contextPath, AccessPackageAssignment.class, cp -> new AccessPackageAssignmentRequest(cp), SchemaInfo.INSTANCE);
        this.contextPath = contextPath;
    }




    public AccessPackageAssignmentRequestCollectionRequest accessPackageAssignmentRequests() {
        return new AccessPackageAssignmentRequestCollectionRequest(contextPath.addSegment("accessPackageAssignmentRequests"));
    }

    public AccessPackageAssignmentRequestRequest accessPackageAssignmentRequests(String id) {
        return new AccessPackageAssignmentRequestRequest(contextPath.addSegment("accessPackageAssignmentRequests").addKeys(new NameValue(id.toString())));
    }

    public AccessPackageAssignmentResourceRoleCollectionRequest accessPackageAssignmentResourceRoles() {
        return new AccessPackageAssignmentResourceRoleCollectionRequest(contextPath.addSegment("accessPackageAssignmentResourceRoles"));
    }

    public AccessPackageAssignmentResourceRoleRequest accessPackageAssignmentResourceRoles(String id) {
        return new AccessPackageAssignmentResourceRoleRequest(contextPath.addSegment("accessPackageAssignmentResourceRoles").addKeys(new NameValue(id.toString())));
    }

    @Function(name = "My")
    @JsonIgnore
    public CollectionPageNonEntityRequest<AccessPackageAssignment> my() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.My"), AccessPackageAssignment.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

}
