package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.LocalDate;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "reportRefreshDate", 
    "groupDisplayName", 
    "isDeleted", 
    "ownerPrincipalName", 
    "lastActivityDate", 
    "groupType", 
    "office365Connected", 
    "memberCount", 
    "postedCount", 
    "readCount", 
    "likedCount", 
    "networkDisplayName", 
    "reportPeriod"})
@JsonInclude(Include.NON_NULL)
public class YammerGroupsActivityDetail extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.yammerGroupsActivityDetail";
    }

    @JsonProperty("reportRefreshDate")
    protected LocalDate reportRefreshDate;

    @JsonProperty("groupDisplayName")
    protected String groupDisplayName;

    @JsonProperty("isDeleted")
    protected Boolean isDeleted;

    @JsonProperty("ownerPrincipalName")
    protected String ownerPrincipalName;

    @JsonProperty("lastActivityDate")
    protected LocalDate lastActivityDate;

    @JsonProperty("groupType")
    protected String groupType;

    @JsonProperty("office365Connected")
    protected Boolean office365Connected;

    @JsonProperty("memberCount")
    protected Long memberCount;

    @JsonProperty("postedCount")
    protected Long postedCount;

    @JsonProperty("readCount")
    protected Long readCount;

    @JsonProperty("likedCount")
    protected Long likedCount;

    @JsonProperty("networkDisplayName")
    protected String networkDisplayName;

    @JsonProperty("reportPeriod")
    protected String reportPeriod;

    protected YammerGroupsActivityDetail() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderYammerGroupsActivityDetail() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private LocalDate reportRefreshDate;
        private String groupDisplayName;
        private Boolean isDeleted;
        private String ownerPrincipalName;
        private LocalDate lastActivityDate;
        private String groupType;
        private Boolean office365Connected;
        private Long memberCount;
        private Long postedCount;
        private Long readCount;
        private Long likedCount;
        private String networkDisplayName;
        private String reportPeriod;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder reportRefreshDate(LocalDate reportRefreshDate) {
            this.reportRefreshDate = reportRefreshDate;
            this.changedFields = changedFields.add("reportRefreshDate");
            return this;
        }

        public Builder groupDisplayName(String groupDisplayName) {
            this.groupDisplayName = groupDisplayName;
            this.changedFields = changedFields.add("groupDisplayName");
            return this;
        }

        public Builder isDeleted(Boolean isDeleted) {
            this.isDeleted = isDeleted;
            this.changedFields = changedFields.add("isDeleted");
            return this;
        }

        public Builder ownerPrincipalName(String ownerPrincipalName) {
            this.ownerPrincipalName = ownerPrincipalName;
            this.changedFields = changedFields.add("ownerPrincipalName");
            return this;
        }

        public Builder lastActivityDate(LocalDate lastActivityDate) {
            this.lastActivityDate = lastActivityDate;
            this.changedFields = changedFields.add("lastActivityDate");
            return this;
        }

        public Builder groupType(String groupType) {
            this.groupType = groupType;
            this.changedFields = changedFields.add("groupType");
            return this;
        }

        public Builder office365Connected(Boolean office365Connected) {
            this.office365Connected = office365Connected;
            this.changedFields = changedFields.add("office365Connected");
            return this;
        }

        public Builder memberCount(Long memberCount) {
            this.memberCount = memberCount;
            this.changedFields = changedFields.add("memberCount");
            return this;
        }

        public Builder postedCount(Long postedCount) {
            this.postedCount = postedCount;
            this.changedFields = changedFields.add("postedCount");
            return this;
        }

        public Builder readCount(Long readCount) {
            this.readCount = readCount;
            this.changedFields = changedFields.add("readCount");
            return this;
        }

        public Builder likedCount(Long likedCount) {
            this.likedCount = likedCount;
            this.changedFields = changedFields.add("likedCount");
            return this;
        }

        public Builder networkDisplayName(String networkDisplayName) {
            this.networkDisplayName = networkDisplayName;
            this.changedFields = changedFields.add("networkDisplayName");
            return this;
        }

        public Builder reportPeriod(String reportPeriod) {
            this.reportPeriod = reportPeriod;
            this.changedFields = changedFields.add("reportPeriod");
            return this;
        }

        public YammerGroupsActivityDetail build() {
            YammerGroupsActivityDetail _x = new YammerGroupsActivityDetail();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.yammerGroupsActivityDetail";
            _x.id = id;
            _x.reportRefreshDate = reportRefreshDate;
            _x.groupDisplayName = groupDisplayName;
            _x.isDeleted = isDeleted;
            _x.ownerPrincipalName = ownerPrincipalName;
            _x.lastActivityDate = lastActivityDate;
            _x.groupType = groupType;
            _x.office365Connected = office365Connected;
            _x.memberCount = memberCount;
            _x.postedCount = postedCount;
            _x.readCount = readCount;
            _x.likedCount = likedCount;
            _x.networkDisplayName = networkDisplayName;
            _x.reportPeriod = reportPeriod;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    @Property(name="reportRefreshDate")
    @JsonIgnore
    public Optional<LocalDate> getReportRefreshDate() {
        return Optional.ofNullable(reportRefreshDate);
    }

    public YammerGroupsActivityDetail withReportRefreshDate(LocalDate reportRefreshDate) {
        YammerGroupsActivityDetail _x = _copy();
        _x.changedFields = changedFields.add("reportRefreshDate");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.yammerGroupsActivityDetail");
        _x.reportRefreshDate = reportRefreshDate;
        return _x;
    }

    @Property(name="groupDisplayName")
    @JsonIgnore
    public Optional<String> getGroupDisplayName() {
        return Optional.ofNullable(groupDisplayName);
    }

    public YammerGroupsActivityDetail withGroupDisplayName(String groupDisplayName) {
        YammerGroupsActivityDetail _x = _copy();
        _x.changedFields = changedFields.add("groupDisplayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.yammerGroupsActivityDetail");
        _x.groupDisplayName = groupDisplayName;
        return _x;
    }

    @Property(name="isDeleted")
    @JsonIgnore
    public Optional<Boolean> getIsDeleted() {
        return Optional.ofNullable(isDeleted);
    }

    public YammerGroupsActivityDetail withIsDeleted(Boolean isDeleted) {
        YammerGroupsActivityDetail _x = _copy();
        _x.changedFields = changedFields.add("isDeleted");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.yammerGroupsActivityDetail");
        _x.isDeleted = isDeleted;
        return _x;
    }

    @Property(name="ownerPrincipalName")
    @JsonIgnore
    public Optional<String> getOwnerPrincipalName() {
        return Optional.ofNullable(ownerPrincipalName);
    }

    public YammerGroupsActivityDetail withOwnerPrincipalName(String ownerPrincipalName) {
        YammerGroupsActivityDetail _x = _copy();
        _x.changedFields = changedFields.add("ownerPrincipalName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.yammerGroupsActivityDetail");
        _x.ownerPrincipalName = ownerPrincipalName;
        return _x;
    }

    @Property(name="lastActivityDate")
    @JsonIgnore
    public Optional<LocalDate> getLastActivityDate() {
        return Optional.ofNullable(lastActivityDate);
    }

    public YammerGroupsActivityDetail withLastActivityDate(LocalDate lastActivityDate) {
        YammerGroupsActivityDetail _x = _copy();
        _x.changedFields = changedFields.add("lastActivityDate");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.yammerGroupsActivityDetail");
        _x.lastActivityDate = lastActivityDate;
        return _x;
    }

    @Property(name="groupType")
    @JsonIgnore
    public Optional<String> getGroupType() {
        return Optional.ofNullable(groupType);
    }

    public YammerGroupsActivityDetail withGroupType(String groupType) {
        YammerGroupsActivityDetail _x = _copy();
        _x.changedFields = changedFields.add("groupType");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.yammerGroupsActivityDetail");
        _x.groupType = groupType;
        return _x;
    }

    @Property(name="office365Connected")
    @JsonIgnore
    public Optional<Boolean> getOffice365Connected() {
        return Optional.ofNullable(office365Connected);
    }

    public YammerGroupsActivityDetail withOffice365Connected(Boolean office365Connected) {
        YammerGroupsActivityDetail _x = _copy();
        _x.changedFields = changedFields.add("office365Connected");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.yammerGroupsActivityDetail");
        _x.office365Connected = office365Connected;
        return _x;
    }

    @Property(name="memberCount")
    @JsonIgnore
    public Optional<Long> getMemberCount() {
        return Optional.ofNullable(memberCount);
    }

    public YammerGroupsActivityDetail withMemberCount(Long memberCount) {
        YammerGroupsActivityDetail _x = _copy();
        _x.changedFields = changedFields.add("memberCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.yammerGroupsActivityDetail");
        _x.memberCount = memberCount;
        return _x;
    }

    @Property(name="postedCount")
    @JsonIgnore
    public Optional<Long> getPostedCount() {
        return Optional.ofNullable(postedCount);
    }

    public YammerGroupsActivityDetail withPostedCount(Long postedCount) {
        YammerGroupsActivityDetail _x = _copy();
        _x.changedFields = changedFields.add("postedCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.yammerGroupsActivityDetail");
        _x.postedCount = postedCount;
        return _x;
    }

    @Property(name="readCount")
    @JsonIgnore
    public Optional<Long> getReadCount() {
        return Optional.ofNullable(readCount);
    }

    public YammerGroupsActivityDetail withReadCount(Long readCount) {
        YammerGroupsActivityDetail _x = _copy();
        _x.changedFields = changedFields.add("readCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.yammerGroupsActivityDetail");
        _x.readCount = readCount;
        return _x;
    }

    @Property(name="likedCount")
    @JsonIgnore
    public Optional<Long> getLikedCount() {
        return Optional.ofNullable(likedCount);
    }

    public YammerGroupsActivityDetail withLikedCount(Long likedCount) {
        YammerGroupsActivityDetail _x = _copy();
        _x.changedFields = changedFields.add("likedCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.yammerGroupsActivityDetail");
        _x.likedCount = likedCount;
        return _x;
    }

    @Property(name="networkDisplayName")
    @JsonIgnore
    public Optional<String> getNetworkDisplayName() {
        return Optional.ofNullable(networkDisplayName);
    }

    public YammerGroupsActivityDetail withNetworkDisplayName(String networkDisplayName) {
        YammerGroupsActivityDetail _x = _copy();
        _x.changedFields = changedFields.add("networkDisplayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.yammerGroupsActivityDetail");
        _x.networkDisplayName = networkDisplayName;
        return _x;
    }

    @Property(name="reportPeriod")
    @JsonIgnore
    public Optional<String> getReportPeriod() {
        return Optional.ofNullable(reportPeriod);
    }

    public YammerGroupsActivityDetail withReportPeriod(String reportPeriod) {
        YammerGroupsActivityDetail _x = _copy();
        _x.changedFields = changedFields.add("reportPeriod");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.yammerGroupsActivityDetail");
        _x.reportPeriod = reportPeriod;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public YammerGroupsActivityDetail patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        YammerGroupsActivityDetail _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public YammerGroupsActivityDetail put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        YammerGroupsActivityDetail _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private YammerGroupsActivityDetail _copy() {
        YammerGroupsActivityDetail _x = new YammerGroupsActivityDetail();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.reportRefreshDate = reportRefreshDate;
        _x.groupDisplayName = groupDisplayName;
        _x.isDeleted = isDeleted;
        _x.ownerPrincipalName = ownerPrincipalName;
        _x.lastActivityDate = lastActivityDate;
        _x.groupType = groupType;
        _x.office365Connected = office365Connected;
        _x.memberCount = memberCount;
        _x.postedCount = postedCount;
        _x.readCount = readCount;
        _x.likedCount = likedCount;
        _x.networkDisplayName = networkDisplayName;
        _x.reportPeriod = reportPeriod;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("YammerGroupsActivityDetail[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("reportRefreshDate=");
        b.append(this.reportRefreshDate);
        b.append(", ");
        b.append("groupDisplayName=");
        b.append(this.groupDisplayName);
        b.append(", ");
        b.append("isDeleted=");
        b.append(this.isDeleted);
        b.append(", ");
        b.append("ownerPrincipalName=");
        b.append(this.ownerPrincipalName);
        b.append(", ");
        b.append("lastActivityDate=");
        b.append(this.lastActivityDate);
        b.append(", ");
        b.append("groupType=");
        b.append(this.groupType);
        b.append(", ");
        b.append("office365Connected=");
        b.append(this.office365Connected);
        b.append(", ");
        b.append("memberCount=");
        b.append(this.memberCount);
        b.append(", ");
        b.append("postedCount=");
        b.append(this.postedCount);
        b.append(", ");
        b.append("readCount=");
        b.append(this.readCount);
        b.append(", ");
        b.append("likedCount=");
        b.append(this.likedCount);
        b.append(", ");
        b.append("networkDisplayName=");
        b.append(this.networkDisplayName);
        b.append(", ");
        b.append("reportPeriod=");
        b.append(this.reportPeriod);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
