package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.LocalDate;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "reportRefreshDate", 
    "userPrincipalName", 
    "displayName", 
    "userState", 
    "stateChangeDate", 
    "lastActivityDate", 
    "usedWeb", 
    "usedWindowsPhone", 
    "usedAndroidPhone", 
    "usediPhone", 
    "usediPad", 
    "usedOthers", 
    "reportPeriod"})
@JsonInclude(Include.NON_NULL)
public class YammerDeviceUsageUserDetail extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.yammerDeviceUsageUserDetail";
    }

    @JsonProperty("reportRefreshDate")
    protected LocalDate reportRefreshDate;

    @JsonProperty("userPrincipalName")
    protected String userPrincipalName;

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("userState")
    protected String userState;

    @JsonProperty("stateChangeDate")
    protected LocalDate stateChangeDate;

    @JsonProperty("lastActivityDate")
    protected LocalDate lastActivityDate;

    @JsonProperty("usedWeb")
    protected Boolean usedWeb;

    @JsonProperty("usedWindowsPhone")
    protected Boolean usedWindowsPhone;

    @JsonProperty("usedAndroidPhone")
    protected Boolean usedAndroidPhone;

    @JsonProperty("usediPhone")
    protected Boolean usediPhone;

    @JsonProperty("usediPad")
    protected Boolean usediPad;

    @JsonProperty("usedOthers")
    protected Boolean usedOthers;

    @JsonProperty("reportPeriod")
    protected String reportPeriod;

    protected YammerDeviceUsageUserDetail() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderYammerDeviceUsageUserDetail() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private LocalDate reportRefreshDate;
        private String userPrincipalName;
        private String displayName;
        private String userState;
        private LocalDate stateChangeDate;
        private LocalDate lastActivityDate;
        private Boolean usedWeb;
        private Boolean usedWindowsPhone;
        private Boolean usedAndroidPhone;
        private Boolean usediPhone;
        private Boolean usediPad;
        private Boolean usedOthers;
        private String reportPeriod;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder reportRefreshDate(LocalDate reportRefreshDate) {
            this.reportRefreshDate = reportRefreshDate;
            this.changedFields = changedFields.add("reportRefreshDate");
            return this;
        }

        public Builder userPrincipalName(String userPrincipalName) {
            this.userPrincipalName = userPrincipalName;
            this.changedFields = changedFields.add("userPrincipalName");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder userState(String userState) {
            this.userState = userState;
            this.changedFields = changedFields.add("userState");
            return this;
        }

        public Builder stateChangeDate(LocalDate stateChangeDate) {
            this.stateChangeDate = stateChangeDate;
            this.changedFields = changedFields.add("stateChangeDate");
            return this;
        }

        public Builder lastActivityDate(LocalDate lastActivityDate) {
            this.lastActivityDate = lastActivityDate;
            this.changedFields = changedFields.add("lastActivityDate");
            return this;
        }

        public Builder usedWeb(Boolean usedWeb) {
            this.usedWeb = usedWeb;
            this.changedFields = changedFields.add("usedWeb");
            return this;
        }

        public Builder usedWindowsPhone(Boolean usedWindowsPhone) {
            this.usedWindowsPhone = usedWindowsPhone;
            this.changedFields = changedFields.add("usedWindowsPhone");
            return this;
        }

        public Builder usedAndroidPhone(Boolean usedAndroidPhone) {
            this.usedAndroidPhone = usedAndroidPhone;
            this.changedFields = changedFields.add("usedAndroidPhone");
            return this;
        }

        public Builder usediPhone(Boolean usediPhone) {
            this.usediPhone = usediPhone;
            this.changedFields = changedFields.add("usediPhone");
            return this;
        }

        public Builder usediPad(Boolean usediPad) {
            this.usediPad = usediPad;
            this.changedFields = changedFields.add("usediPad");
            return this;
        }

        public Builder usedOthers(Boolean usedOthers) {
            this.usedOthers = usedOthers;
            this.changedFields = changedFields.add("usedOthers");
            return this;
        }

        public Builder reportPeriod(String reportPeriod) {
            this.reportPeriod = reportPeriod;
            this.changedFields = changedFields.add("reportPeriod");
            return this;
        }

        public YammerDeviceUsageUserDetail build() {
            YammerDeviceUsageUserDetail _x = new YammerDeviceUsageUserDetail();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.yammerDeviceUsageUserDetail";
            _x.id = id;
            _x.reportRefreshDate = reportRefreshDate;
            _x.userPrincipalName = userPrincipalName;
            _x.displayName = displayName;
            _x.userState = userState;
            _x.stateChangeDate = stateChangeDate;
            _x.lastActivityDate = lastActivityDate;
            _x.usedWeb = usedWeb;
            _x.usedWindowsPhone = usedWindowsPhone;
            _x.usedAndroidPhone = usedAndroidPhone;
            _x.usediPhone = usediPhone;
            _x.usediPad = usediPad;
            _x.usedOthers = usedOthers;
            _x.reportPeriod = reportPeriod;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    @Property(name="reportRefreshDate")
    @JsonIgnore
    public Optional<LocalDate> getReportRefreshDate() {
        return Optional.ofNullable(reportRefreshDate);
    }

    public YammerDeviceUsageUserDetail withReportRefreshDate(LocalDate reportRefreshDate) {
        YammerDeviceUsageUserDetail _x = _copy();
        _x.changedFields = changedFields.add("reportRefreshDate");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.yammerDeviceUsageUserDetail");
        _x.reportRefreshDate = reportRefreshDate;
        return _x;
    }

    @Property(name="userPrincipalName")
    @JsonIgnore
    public Optional<String> getUserPrincipalName() {
        return Optional.ofNullable(userPrincipalName);
    }

    public YammerDeviceUsageUserDetail withUserPrincipalName(String userPrincipalName) {
        YammerDeviceUsageUserDetail _x = _copy();
        _x.changedFields = changedFields.add("userPrincipalName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.yammerDeviceUsageUserDetail");
        _x.userPrincipalName = userPrincipalName;
        return _x;
    }

    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    public YammerDeviceUsageUserDetail withDisplayName(String displayName) {
        YammerDeviceUsageUserDetail _x = _copy();
        _x.changedFields = changedFields.add("displayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.yammerDeviceUsageUserDetail");
        _x.displayName = displayName;
        return _x;
    }

    @Property(name="userState")
    @JsonIgnore
    public Optional<String> getUserState() {
        return Optional.ofNullable(userState);
    }

    public YammerDeviceUsageUserDetail withUserState(String userState) {
        YammerDeviceUsageUserDetail _x = _copy();
        _x.changedFields = changedFields.add("userState");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.yammerDeviceUsageUserDetail");
        _x.userState = userState;
        return _x;
    }

    @Property(name="stateChangeDate")
    @JsonIgnore
    public Optional<LocalDate> getStateChangeDate() {
        return Optional.ofNullable(stateChangeDate);
    }

    public YammerDeviceUsageUserDetail withStateChangeDate(LocalDate stateChangeDate) {
        YammerDeviceUsageUserDetail _x = _copy();
        _x.changedFields = changedFields.add("stateChangeDate");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.yammerDeviceUsageUserDetail");
        _x.stateChangeDate = stateChangeDate;
        return _x;
    }

    @Property(name="lastActivityDate")
    @JsonIgnore
    public Optional<LocalDate> getLastActivityDate() {
        return Optional.ofNullable(lastActivityDate);
    }

    public YammerDeviceUsageUserDetail withLastActivityDate(LocalDate lastActivityDate) {
        YammerDeviceUsageUserDetail _x = _copy();
        _x.changedFields = changedFields.add("lastActivityDate");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.yammerDeviceUsageUserDetail");
        _x.lastActivityDate = lastActivityDate;
        return _x;
    }

    @Property(name="usedWeb")
    @JsonIgnore
    public Optional<Boolean> getUsedWeb() {
        return Optional.ofNullable(usedWeb);
    }

    public YammerDeviceUsageUserDetail withUsedWeb(Boolean usedWeb) {
        YammerDeviceUsageUserDetail _x = _copy();
        _x.changedFields = changedFields.add("usedWeb");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.yammerDeviceUsageUserDetail");
        _x.usedWeb = usedWeb;
        return _x;
    }

    @Property(name="usedWindowsPhone")
    @JsonIgnore
    public Optional<Boolean> getUsedWindowsPhone() {
        return Optional.ofNullable(usedWindowsPhone);
    }

    public YammerDeviceUsageUserDetail withUsedWindowsPhone(Boolean usedWindowsPhone) {
        YammerDeviceUsageUserDetail _x = _copy();
        _x.changedFields = changedFields.add("usedWindowsPhone");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.yammerDeviceUsageUserDetail");
        _x.usedWindowsPhone = usedWindowsPhone;
        return _x;
    }

    @Property(name="usedAndroidPhone")
    @JsonIgnore
    public Optional<Boolean> getUsedAndroidPhone() {
        return Optional.ofNullable(usedAndroidPhone);
    }

    public YammerDeviceUsageUserDetail withUsedAndroidPhone(Boolean usedAndroidPhone) {
        YammerDeviceUsageUserDetail _x = _copy();
        _x.changedFields = changedFields.add("usedAndroidPhone");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.yammerDeviceUsageUserDetail");
        _x.usedAndroidPhone = usedAndroidPhone;
        return _x;
    }

    @Property(name="usediPhone")
    @JsonIgnore
    public Optional<Boolean> getUsediPhone() {
        return Optional.ofNullable(usediPhone);
    }

    public YammerDeviceUsageUserDetail withUsediPhone(Boolean usediPhone) {
        YammerDeviceUsageUserDetail _x = _copy();
        _x.changedFields = changedFields.add("usediPhone");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.yammerDeviceUsageUserDetail");
        _x.usediPhone = usediPhone;
        return _x;
    }

    @Property(name="usediPad")
    @JsonIgnore
    public Optional<Boolean> getUsediPad() {
        return Optional.ofNullable(usediPad);
    }

    public YammerDeviceUsageUserDetail withUsediPad(Boolean usediPad) {
        YammerDeviceUsageUserDetail _x = _copy();
        _x.changedFields = changedFields.add("usediPad");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.yammerDeviceUsageUserDetail");
        _x.usediPad = usediPad;
        return _x;
    }

    @Property(name="usedOthers")
    @JsonIgnore
    public Optional<Boolean> getUsedOthers() {
        return Optional.ofNullable(usedOthers);
    }

    public YammerDeviceUsageUserDetail withUsedOthers(Boolean usedOthers) {
        YammerDeviceUsageUserDetail _x = _copy();
        _x.changedFields = changedFields.add("usedOthers");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.yammerDeviceUsageUserDetail");
        _x.usedOthers = usedOthers;
        return _x;
    }

    @Property(name="reportPeriod")
    @JsonIgnore
    public Optional<String> getReportPeriod() {
        return Optional.ofNullable(reportPeriod);
    }

    public YammerDeviceUsageUserDetail withReportPeriod(String reportPeriod) {
        YammerDeviceUsageUserDetail _x = _copy();
        _x.changedFields = changedFields.add("reportPeriod");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.yammerDeviceUsageUserDetail");
        _x.reportPeriod = reportPeriod;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public YammerDeviceUsageUserDetail patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        YammerDeviceUsageUserDetail _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public YammerDeviceUsageUserDetail put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        YammerDeviceUsageUserDetail _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private YammerDeviceUsageUserDetail _copy() {
        YammerDeviceUsageUserDetail _x = new YammerDeviceUsageUserDetail();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.reportRefreshDate = reportRefreshDate;
        _x.userPrincipalName = userPrincipalName;
        _x.displayName = displayName;
        _x.userState = userState;
        _x.stateChangeDate = stateChangeDate;
        _x.lastActivityDate = lastActivityDate;
        _x.usedWeb = usedWeb;
        _x.usedWindowsPhone = usedWindowsPhone;
        _x.usedAndroidPhone = usedAndroidPhone;
        _x.usediPhone = usediPhone;
        _x.usediPad = usediPad;
        _x.usedOthers = usedOthers;
        _x.reportPeriod = reportPeriod;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("YammerDeviceUsageUserDetail[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("reportRefreshDate=");
        b.append(this.reportRefreshDate);
        b.append(", ");
        b.append("userPrincipalName=");
        b.append(this.userPrincipalName);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("userState=");
        b.append(this.userState);
        b.append(", ");
        b.append("stateChangeDate=");
        b.append(this.stateChangeDate);
        b.append(", ");
        b.append("lastActivityDate=");
        b.append(this.lastActivityDate);
        b.append(", ");
        b.append("usedWeb=");
        b.append(this.usedWeb);
        b.append(", ");
        b.append("usedWindowsPhone=");
        b.append(this.usedWindowsPhone);
        b.append(", ");
        b.append("usedAndroidPhone=");
        b.append(this.usedAndroidPhone);
        b.append(", ");
        b.append("usediPhone=");
        b.append(this.usediPhone);
        b.append(", ");
        b.append("usediPad=");
        b.append(this.usediPad);
        b.append(", ");
        b.append("usedOthers=");
        b.append(this.usedOthers);
        b.append(", ");
        b.append("reportPeriod=");
        b.append(this.reportPeriod);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
