package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.EdmSchemaInfo;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.LocalDate;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "reportRefreshDate", 
    "userPrincipalName", 
    "displayName", 
    "userState", 
    "stateChangeDate", 
    "lastActivityDate", 
    "postedCount", 
    "readCount", 
    "likedCount", 
    "assignedProducts", 
    "reportPeriod"})
@JsonInclude(Include.NON_NULL)
public class YammerActivityUserDetail extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.yammerActivityUserDetail";
    }

    @JsonProperty("reportRefreshDate")
    protected LocalDate reportRefreshDate;

    @JsonProperty("userPrincipalName")
    protected String userPrincipalName;

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("userState")
    protected String userState;

    @JsonProperty("stateChangeDate")
    protected LocalDate stateChangeDate;

    @JsonProperty("lastActivityDate")
    protected LocalDate lastActivityDate;

    @JsonProperty("postedCount")
    protected Long postedCount;

    @JsonProperty("readCount")
    protected Long readCount;

    @JsonProperty("likedCount")
    protected Long likedCount;

    @JsonProperty("assignedProducts")
    protected List<String> assignedProducts;

    @JsonProperty("assignedProducts@nextLink")
    protected String assignedProductsNextLink;

    @JsonProperty("reportPeriod")
    protected String reportPeriod;

    protected YammerActivityUserDetail() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderYammerActivityUserDetail() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private LocalDate reportRefreshDate;
        private String userPrincipalName;
        private String displayName;
        private String userState;
        private LocalDate stateChangeDate;
        private LocalDate lastActivityDate;
        private Long postedCount;
        private Long readCount;
        private Long likedCount;
        private List<String> assignedProducts;
        private String assignedProductsNextLink;
        private String reportPeriod;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder reportRefreshDate(LocalDate reportRefreshDate) {
            this.reportRefreshDate = reportRefreshDate;
            this.changedFields = changedFields.add("reportRefreshDate");
            return this;
        }

        public Builder userPrincipalName(String userPrincipalName) {
            this.userPrincipalName = userPrincipalName;
            this.changedFields = changedFields.add("userPrincipalName");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder userState(String userState) {
            this.userState = userState;
            this.changedFields = changedFields.add("userState");
            return this;
        }

        public Builder stateChangeDate(LocalDate stateChangeDate) {
            this.stateChangeDate = stateChangeDate;
            this.changedFields = changedFields.add("stateChangeDate");
            return this;
        }

        public Builder lastActivityDate(LocalDate lastActivityDate) {
            this.lastActivityDate = lastActivityDate;
            this.changedFields = changedFields.add("lastActivityDate");
            return this;
        }

        public Builder postedCount(Long postedCount) {
            this.postedCount = postedCount;
            this.changedFields = changedFields.add("postedCount");
            return this;
        }

        public Builder readCount(Long readCount) {
            this.readCount = readCount;
            this.changedFields = changedFields.add("readCount");
            return this;
        }

        public Builder likedCount(Long likedCount) {
            this.likedCount = likedCount;
            this.changedFields = changedFields.add("likedCount");
            return this;
        }

        public Builder assignedProducts(List<String> assignedProducts) {
            this.assignedProducts = assignedProducts;
            this.changedFields = changedFields.add("assignedProducts");
            return this;
        }

        public Builder assignedProducts(String... assignedProducts) {
            return assignedProducts(Arrays.asList(assignedProducts));
        }

        public Builder assignedProductsNextLink(String assignedProductsNextLink) {
            this.assignedProductsNextLink = assignedProductsNextLink;
            this.changedFields = changedFields.add("assignedProducts");
            return this;
        }

        public Builder reportPeriod(String reportPeriod) {
            this.reportPeriod = reportPeriod;
            this.changedFields = changedFields.add("reportPeriod");
            return this;
        }

        public YammerActivityUserDetail build() {
            YammerActivityUserDetail _x = new YammerActivityUserDetail();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.yammerActivityUserDetail";
            _x.id = id;
            _x.reportRefreshDate = reportRefreshDate;
            _x.userPrincipalName = userPrincipalName;
            _x.displayName = displayName;
            _x.userState = userState;
            _x.stateChangeDate = stateChangeDate;
            _x.lastActivityDate = lastActivityDate;
            _x.postedCount = postedCount;
            _x.readCount = readCount;
            _x.likedCount = likedCount;
            _x.assignedProducts = assignedProducts;
            _x.assignedProductsNextLink = assignedProductsNextLink;
            _x.reportPeriod = reportPeriod;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    @Property(name="reportRefreshDate")
    @JsonIgnore
    public Optional<LocalDate> getReportRefreshDate() {
        return Optional.ofNullable(reportRefreshDate);
    }

    public YammerActivityUserDetail withReportRefreshDate(LocalDate reportRefreshDate) {
        YammerActivityUserDetail _x = _copy();
        _x.changedFields = changedFields.add("reportRefreshDate");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.yammerActivityUserDetail");
        _x.reportRefreshDate = reportRefreshDate;
        return _x;
    }

    @Property(name="userPrincipalName")
    @JsonIgnore
    public Optional<String> getUserPrincipalName() {
        return Optional.ofNullable(userPrincipalName);
    }

    public YammerActivityUserDetail withUserPrincipalName(String userPrincipalName) {
        YammerActivityUserDetail _x = _copy();
        _x.changedFields = changedFields.add("userPrincipalName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.yammerActivityUserDetail");
        _x.userPrincipalName = userPrincipalName;
        return _x;
    }

    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    public YammerActivityUserDetail withDisplayName(String displayName) {
        YammerActivityUserDetail _x = _copy();
        _x.changedFields = changedFields.add("displayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.yammerActivityUserDetail");
        _x.displayName = displayName;
        return _x;
    }

    @Property(name="userState")
    @JsonIgnore
    public Optional<String> getUserState() {
        return Optional.ofNullable(userState);
    }

    public YammerActivityUserDetail withUserState(String userState) {
        YammerActivityUserDetail _x = _copy();
        _x.changedFields = changedFields.add("userState");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.yammerActivityUserDetail");
        _x.userState = userState;
        return _x;
    }

    @Property(name="stateChangeDate")
    @JsonIgnore
    public Optional<LocalDate> getStateChangeDate() {
        return Optional.ofNullable(stateChangeDate);
    }

    public YammerActivityUserDetail withStateChangeDate(LocalDate stateChangeDate) {
        YammerActivityUserDetail _x = _copy();
        _x.changedFields = changedFields.add("stateChangeDate");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.yammerActivityUserDetail");
        _x.stateChangeDate = stateChangeDate;
        return _x;
    }

    @Property(name="lastActivityDate")
    @JsonIgnore
    public Optional<LocalDate> getLastActivityDate() {
        return Optional.ofNullable(lastActivityDate);
    }

    public YammerActivityUserDetail withLastActivityDate(LocalDate lastActivityDate) {
        YammerActivityUserDetail _x = _copy();
        _x.changedFields = changedFields.add("lastActivityDate");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.yammerActivityUserDetail");
        _x.lastActivityDate = lastActivityDate;
        return _x;
    }

    @Property(name="postedCount")
    @JsonIgnore
    public Optional<Long> getPostedCount() {
        return Optional.ofNullable(postedCount);
    }

    public YammerActivityUserDetail withPostedCount(Long postedCount) {
        YammerActivityUserDetail _x = _copy();
        _x.changedFields = changedFields.add("postedCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.yammerActivityUserDetail");
        _x.postedCount = postedCount;
        return _x;
    }

    @Property(name="readCount")
    @JsonIgnore
    public Optional<Long> getReadCount() {
        return Optional.ofNullable(readCount);
    }

    public YammerActivityUserDetail withReadCount(Long readCount) {
        YammerActivityUserDetail _x = _copy();
        _x.changedFields = changedFields.add("readCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.yammerActivityUserDetail");
        _x.readCount = readCount;
        return _x;
    }

    @Property(name="likedCount")
    @JsonIgnore
    public Optional<Long> getLikedCount() {
        return Optional.ofNullable(likedCount);
    }

    public YammerActivityUserDetail withLikedCount(Long likedCount) {
        YammerActivityUserDetail _x = _copy();
        _x.changedFields = changedFields.add("likedCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.yammerActivityUserDetail");
        _x.likedCount = likedCount;
        return _x;
    }

    @Property(name="assignedProducts")
    @JsonIgnore
    public CollectionPage<String> getAssignedProducts() {
        return new CollectionPage<String>(contextPath, String.class, assignedProducts, Optional.ofNullable(assignedProductsNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="assignedProducts")
    @JsonIgnore
    public CollectionPage<String> getAssignedProducts(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, assignedProducts, Optional.ofNullable(assignedProductsNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @Property(name="reportPeriod")
    @JsonIgnore
    public Optional<String> getReportPeriod() {
        return Optional.ofNullable(reportPeriod);
    }

    public YammerActivityUserDetail withReportPeriod(String reportPeriod) {
        YammerActivityUserDetail _x = _copy();
        _x.changedFields = changedFields.add("reportPeriod");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.yammerActivityUserDetail");
        _x.reportPeriod = reportPeriod;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public YammerActivityUserDetail patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        YammerActivityUserDetail _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public YammerActivityUserDetail put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        YammerActivityUserDetail _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private YammerActivityUserDetail _copy() {
        YammerActivityUserDetail _x = new YammerActivityUserDetail();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.reportRefreshDate = reportRefreshDate;
        _x.userPrincipalName = userPrincipalName;
        _x.displayName = displayName;
        _x.userState = userState;
        _x.stateChangeDate = stateChangeDate;
        _x.lastActivityDate = lastActivityDate;
        _x.postedCount = postedCount;
        _x.readCount = readCount;
        _x.likedCount = likedCount;
        _x.assignedProducts = assignedProducts;
        _x.reportPeriod = reportPeriod;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("YammerActivityUserDetail[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("reportRefreshDate=");
        b.append(this.reportRefreshDate);
        b.append(", ");
        b.append("userPrincipalName=");
        b.append(this.userPrincipalName);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("userState=");
        b.append(this.userState);
        b.append(", ");
        b.append("stateChangeDate=");
        b.append(this.stateChangeDate);
        b.append(", ");
        b.append("lastActivityDate=");
        b.append(this.lastActivityDate);
        b.append(", ");
        b.append("postedCount=");
        b.append(this.postedCount);
        b.append(", ");
        b.append("readCount=");
        b.append(this.readCount);
        b.append(", ");
        b.append("likedCount=");
        b.append(this.likedCount);
        b.append(", ");
        b.append("assignedProducts=");
        b.append(this.assignedProducts);
        b.append(", ");
        b.append("reportPeriod=");
        b.append(this.reportPeriod);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
