package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.FunctionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Function;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.TypedObject;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.complex.Json;
import odata.msgraph.client.beta.entity.request.WorkbookFilterRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "index", 
    "name", 
    "values"})
@JsonInclude(Include.NON_NULL)
public class WorkbookTableColumn extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.workbookTableColumn";
    }

    @JsonProperty("index")
    protected Integer index;

    @JsonProperty("name")
    protected String name;

    @JsonProperty("values")
    protected Json values;

    protected WorkbookTableColumn() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderWorkbookTableColumn() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private Integer index;
        private String name;
        private Json values;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder index(Integer index) {
            this.index = index;
            this.changedFields = changedFields.add("index");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.changedFields = changedFields.add("name");
            return this;
        }

        public Builder values(Json values) {
            this.values = values;
            this.changedFields = changedFields.add("values");
            return this;
        }

        public WorkbookTableColumn build() {
            WorkbookTableColumn _x = new WorkbookTableColumn();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.workbookTableColumn";
            _x.id = id;
            _x.index = index;
            _x.name = name;
            _x.values = values;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    @Property(name="index")
    @JsonIgnore
    public Optional<Integer> getIndex() {
        return Optional.ofNullable(index);
    }

    public WorkbookTableColumn withIndex(Integer index) {
        WorkbookTableColumn _x = _copy();
        _x.changedFields = changedFields.add("index");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.workbookTableColumn");
        _x.index = index;
        return _x;
    }

    @Property(name="name")
    @JsonIgnore
    public Optional<String> getName() {
        return Optional.ofNullable(name);
    }

    public WorkbookTableColumn withName(String name) {
        WorkbookTableColumn _x = _copy();
        _x.changedFields = changedFields.add("name");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.workbookTableColumn");
        _x.name = name;
        return _x;
    }

    @Property(name="values")
    @JsonIgnore
    public Optional<Json> getValues() {
        return Optional.ofNullable(values);
    }

    public WorkbookTableColumn withValues(Json values) {
        WorkbookTableColumn _x = _copy();
        _x.changedFields = changedFields.add("values");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.workbookTableColumn");
        _x.values = values;
        return _x;
    }

    @NavigationProperty(name="filter")
    @JsonIgnore
    public WorkbookFilterRequest getFilter() {
        return new WorkbookFilterRequest(contextPath.addSegment("filter"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public WorkbookTableColumn patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        WorkbookTableColumn _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public WorkbookTableColumn put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        WorkbookTableColumn _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private WorkbookTableColumn _copy() {
        WorkbookTableColumn _x = new WorkbookTableColumn();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.index = index;
        _x.name = name;
        _x.values = values;
        return _x;
    }

    @Function(name = "dataBodyRange")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<WorkbookRange> dataBodyRange() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new FunctionRequestReturningNonCollectionUnwrapped<WorkbookRange>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.dataBodyRange"), WorkbookRange.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Function(name = "headerRowRange")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<WorkbookRange> headerRowRange() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new FunctionRequestReturningNonCollectionUnwrapped<WorkbookRange>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.headerRowRange"), WorkbookRange.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Function(name = "range")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<WorkbookRange> range() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new FunctionRequestReturningNonCollectionUnwrapped<WorkbookRange>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.range"), WorkbookRange.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Function(name = "totalRowRange")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<WorkbookRange> totalRowRange() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new FunctionRequestReturningNonCollectionUnwrapped<WorkbookRange>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.totalRowRange"), WorkbookRange.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("WorkbookTableColumn[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("index=");
        b.append(this.index);
        b.append(", ");
        b.append("name=");
        b.append(this.name);
        b.append(", ");
        b.append("values=");
        b.append(this.values);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
