package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.TypedObject;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.entity.collection.request.WorkbookRangeBorderCollectionRequest;
import odata.msgraph.client.beta.entity.request.WorkbookFormatProtectionRequest;
import odata.msgraph.client.beta.entity.request.WorkbookRangeFillRequest;
import odata.msgraph.client.beta.entity.request.WorkbookRangeFontRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "columnWidth", 
    "horizontalAlignment", 
    "rowHeight", 
    "verticalAlignment", 
    "wrapText"})
@JsonInclude(Include.NON_NULL)
public class WorkbookRangeFormat extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.workbookRangeFormat";
    }

    @JsonProperty("columnWidth")
    protected Double columnWidth;

    @JsonProperty("horizontalAlignment")
    protected String horizontalAlignment;

    @JsonProperty("rowHeight")
    protected Double rowHeight;

    @JsonProperty("verticalAlignment")
    protected String verticalAlignment;

    @JsonProperty("wrapText")
    protected Boolean wrapText;

    protected WorkbookRangeFormat() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderWorkbookRangeFormat() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private Double columnWidth;
        private String horizontalAlignment;
        private Double rowHeight;
        private String verticalAlignment;
        private Boolean wrapText;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder columnWidth(Double columnWidth) {
            this.columnWidth = columnWidth;
            this.changedFields = changedFields.add("columnWidth");
            return this;
        }

        public Builder horizontalAlignment(String horizontalAlignment) {
            this.horizontalAlignment = horizontalAlignment;
            this.changedFields = changedFields.add("horizontalAlignment");
            return this;
        }

        public Builder rowHeight(Double rowHeight) {
            this.rowHeight = rowHeight;
            this.changedFields = changedFields.add("rowHeight");
            return this;
        }

        public Builder verticalAlignment(String verticalAlignment) {
            this.verticalAlignment = verticalAlignment;
            this.changedFields = changedFields.add("verticalAlignment");
            return this;
        }

        public Builder wrapText(Boolean wrapText) {
            this.wrapText = wrapText;
            this.changedFields = changedFields.add("wrapText");
            return this;
        }

        public WorkbookRangeFormat build() {
            WorkbookRangeFormat _x = new WorkbookRangeFormat();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.workbookRangeFormat";
            _x.id = id;
            _x.columnWidth = columnWidth;
            _x.horizontalAlignment = horizontalAlignment;
            _x.rowHeight = rowHeight;
            _x.verticalAlignment = verticalAlignment;
            _x.wrapText = wrapText;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    @Property(name="columnWidth")
    @JsonIgnore
    public Optional<Double> getColumnWidth() {
        return Optional.ofNullable(columnWidth);
    }

    public WorkbookRangeFormat withColumnWidth(Double columnWidth) {
        WorkbookRangeFormat _x = _copy();
        _x.changedFields = changedFields.add("columnWidth");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.workbookRangeFormat");
        _x.columnWidth = columnWidth;
        return _x;
    }

    @Property(name="horizontalAlignment")
    @JsonIgnore
    public Optional<String> getHorizontalAlignment() {
        return Optional.ofNullable(horizontalAlignment);
    }

    public WorkbookRangeFormat withHorizontalAlignment(String horizontalAlignment) {
        WorkbookRangeFormat _x = _copy();
        _x.changedFields = changedFields.add("horizontalAlignment");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.workbookRangeFormat");
        _x.horizontalAlignment = horizontalAlignment;
        return _x;
    }

    @Property(name="rowHeight")
    @JsonIgnore
    public Optional<Double> getRowHeight() {
        return Optional.ofNullable(rowHeight);
    }

    public WorkbookRangeFormat withRowHeight(Double rowHeight) {
        WorkbookRangeFormat _x = _copy();
        _x.changedFields = changedFields.add("rowHeight");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.workbookRangeFormat");
        _x.rowHeight = rowHeight;
        return _x;
    }

    @Property(name="verticalAlignment")
    @JsonIgnore
    public Optional<String> getVerticalAlignment() {
        return Optional.ofNullable(verticalAlignment);
    }

    public WorkbookRangeFormat withVerticalAlignment(String verticalAlignment) {
        WorkbookRangeFormat _x = _copy();
        _x.changedFields = changedFields.add("verticalAlignment");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.workbookRangeFormat");
        _x.verticalAlignment = verticalAlignment;
        return _x;
    }

    @Property(name="wrapText")
    @JsonIgnore
    public Optional<Boolean> getWrapText() {
        return Optional.ofNullable(wrapText);
    }

    public WorkbookRangeFormat withWrapText(Boolean wrapText) {
        WorkbookRangeFormat _x = _copy();
        _x.changedFields = changedFields.add("wrapText");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.workbookRangeFormat");
        _x.wrapText = wrapText;
        return _x;
    }

    @NavigationProperty(name="borders")
    @JsonIgnore
    public WorkbookRangeBorderCollectionRequest getBorders() {
        return new WorkbookRangeBorderCollectionRequest(
                        contextPath.addSegment("borders"));
    }

    @NavigationProperty(name="fill")
    @JsonIgnore
    public WorkbookRangeFillRequest getFill() {
        return new WorkbookRangeFillRequest(contextPath.addSegment("fill"));
    }

    @NavigationProperty(name="font")
    @JsonIgnore
    public WorkbookRangeFontRequest getFont() {
        return new WorkbookRangeFontRequest(contextPath.addSegment("font"));
    }

    @NavigationProperty(name="protection")
    @JsonIgnore
    public WorkbookFormatProtectionRequest getProtection() {
        return new WorkbookFormatProtectionRequest(contextPath.addSegment("protection"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public WorkbookRangeFormat patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        WorkbookRangeFormat _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public WorkbookRangeFormat put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        WorkbookRangeFormat _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private WorkbookRangeFormat _copy() {
        WorkbookRangeFormat _x = new WorkbookRangeFormat();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.columnWidth = columnWidth;
        _x.horizontalAlignment = horizontalAlignment;
        _x.rowHeight = rowHeight;
        _x.verticalAlignment = verticalAlignment;
        _x.wrapText = wrapText;
        return _x;
    }

    @Action(name = "autofitColumns")
    @JsonIgnore
    public ActionRequestNoReturn autofitColumns() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.autofitColumns"), _parameters);
    }

    @Action(name = "autofitRows")
    @JsonIgnore
    public ActionRequestNoReturn autofitRows() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.autofitRows"), _parameters);
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("WorkbookRangeFormat[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("columnWidth=");
        b.append(this.columnWidth);
        b.append(", ");
        b.append("horizontalAlignment=");
        b.append(this.horizontalAlignment);
        b.append(", ");
        b.append("rowHeight=");
        b.append(this.rowHeight);
        b.append(", ");
        b.append("verticalAlignment=");
        b.append(this.verticalAlignment);
        b.append(", ");
        b.append("wrapText=");
        b.append(this.wrapText);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
