package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;

import odata.msgraph.client.beta.complex.WorkbookOperationError;
import odata.msgraph.client.beta.enums.WorkbookOperationStatus;

@JsonPropertyOrder({
    "@odata.type", 
    "status", 
    "resourceLocation", 
    "error"})
@JsonInclude(Include.NON_NULL)
public class WorkbookOperation extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.workbookOperation";
    }

    @JsonProperty("status")
    protected WorkbookOperationStatus status;

    @JsonProperty("resourceLocation")
    protected String resourceLocation;

    @JsonProperty("error")
    protected WorkbookOperationError error;

    protected WorkbookOperation() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderWorkbookOperation() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private WorkbookOperationStatus status;
        private String resourceLocation;
        private WorkbookOperationError error;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder status(WorkbookOperationStatus status) {
            this.status = status;
            this.changedFields = changedFields.add("status");
            return this;
        }

        public Builder resourceLocation(String resourceLocation) {
            this.resourceLocation = resourceLocation;
            this.changedFields = changedFields.add("resourceLocation");
            return this;
        }

        public Builder error(WorkbookOperationError error) {
            this.error = error;
            this.changedFields = changedFields.add("error");
            return this;
        }

        public WorkbookOperation build() {
            WorkbookOperation _x = new WorkbookOperation();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.workbookOperation";
            _x.id = id;
            _x.status = status;
            _x.resourceLocation = resourceLocation;
            _x.error = error;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    @Property(name="status")
    @JsonIgnore
    public Optional<WorkbookOperationStatus> getStatus() {
        return Optional.ofNullable(status);
    }

    public WorkbookOperation withStatus(WorkbookOperationStatus status) {
        WorkbookOperation _x = _copy();
        _x.changedFields = changedFields.add("status");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.workbookOperation");
        _x.status = status;
        return _x;
    }

    @Property(name="resourceLocation")
    @JsonIgnore
    public Optional<String> getResourceLocation() {
        return Optional.ofNullable(resourceLocation);
    }

    public WorkbookOperation withResourceLocation(String resourceLocation) {
        WorkbookOperation _x = _copy();
        _x.changedFields = changedFields.add("resourceLocation");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.workbookOperation");
        _x.resourceLocation = resourceLocation;
        return _x;
    }

    @Property(name="error")
    @JsonIgnore
    public Optional<WorkbookOperationError> getError() {
        return Optional.ofNullable(error);
    }

    public WorkbookOperation withError(WorkbookOperationError error) {
        WorkbookOperation _x = _copy();
        _x.changedFields = changedFields.add("error");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.workbookOperation");
        _x.error = error;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public WorkbookOperation patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        WorkbookOperation _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public WorkbookOperation put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        WorkbookOperation _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private WorkbookOperation _copy() {
        WorkbookOperation _x = new WorkbookOperation();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.status = status;
        _x.resourceLocation = resourceLocation;
        _x.error = error;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("WorkbookOperation[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("status=");
        b.append(this.status);
        b.append(", ");
        b.append("resourceLocation=");
        b.append(this.resourceLocation);
        b.append(", ");
        b.append("error=");
        b.append(this.error);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
