package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.FunctionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Function;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.TypedObject;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.complex.Json;
import odata.msgraph.client.beta.entity.request.WorkbookWorksheetRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "comment", 
    "name", 
    "scope", 
    "type", 
    "value", 
    "visible"})
@JsonInclude(Include.NON_NULL)
public class WorkbookNamedItem extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.workbookNamedItem";
    }

    @JsonProperty("comment")
    protected String comment;

    @JsonProperty("name")
    protected String name;

    @JsonProperty("scope")
    protected String scope;

    @JsonProperty("type")
    protected String type;

    @JsonProperty("value")
    protected Json value;

    @JsonProperty("visible")
    protected Boolean visible;

    protected WorkbookNamedItem() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderWorkbookNamedItem() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String comment;
        private String name;
        private String scope;
        private String type;
        private Json value;
        private Boolean visible;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder comment(String comment) {
            this.comment = comment;
            this.changedFields = changedFields.add("comment");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.changedFields = changedFields.add("name");
            return this;
        }

        public Builder scope(String scope) {
            this.scope = scope;
            this.changedFields = changedFields.add("scope");
            return this;
        }

        public Builder type(String type) {
            this.type = type;
            this.changedFields = changedFields.add("type");
            return this;
        }

        public Builder value(Json value) {
            this.value = value;
            this.changedFields = changedFields.add("value");
            return this;
        }

        public Builder visible(Boolean visible) {
            this.visible = visible;
            this.changedFields = changedFields.add("visible");
            return this;
        }

        public WorkbookNamedItem build() {
            WorkbookNamedItem _x = new WorkbookNamedItem();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.workbookNamedItem";
            _x.id = id;
            _x.comment = comment;
            _x.name = name;
            _x.scope = scope;
            _x.type = type;
            _x.value = value;
            _x.visible = visible;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    @Property(name="comment")
    @JsonIgnore
    public Optional<String> getComment() {
        return Optional.ofNullable(comment);
    }

    public WorkbookNamedItem withComment(String comment) {
        WorkbookNamedItem _x = _copy();
        _x.changedFields = changedFields.add("comment");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.workbookNamedItem");
        _x.comment = comment;
        return _x;
    }

    @Property(name="name")
    @JsonIgnore
    public Optional<String> getName() {
        return Optional.ofNullable(name);
    }

    public WorkbookNamedItem withName(String name) {
        WorkbookNamedItem _x = _copy();
        _x.changedFields = changedFields.add("name");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.workbookNamedItem");
        _x.name = name;
        return _x;
    }

    @Property(name="scope")
    @JsonIgnore
    public Optional<String> getScope() {
        return Optional.ofNullable(scope);
    }

    public WorkbookNamedItem withScope(String scope) {
        WorkbookNamedItem _x = _copy();
        _x.changedFields = changedFields.add("scope");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.workbookNamedItem");
        _x.scope = scope;
        return _x;
    }

    @Property(name="type")
    @JsonIgnore
    public Optional<String> getType() {
        return Optional.ofNullable(type);
    }

    public WorkbookNamedItem withType(String type) {
        WorkbookNamedItem _x = _copy();
        _x.changedFields = changedFields.add("type");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.workbookNamedItem");
        _x.type = type;
        return _x;
    }

    @Property(name="value")
    @JsonIgnore
    public Optional<Json> getValue() {
        return Optional.ofNullable(value);
    }

    public WorkbookNamedItem withValue(Json value) {
        WorkbookNamedItem _x = _copy();
        _x.changedFields = changedFields.add("value");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.workbookNamedItem");
        _x.value = value;
        return _x;
    }

    @Property(name="visible")
    @JsonIgnore
    public Optional<Boolean> getVisible() {
        return Optional.ofNullable(visible);
    }

    public WorkbookNamedItem withVisible(Boolean visible) {
        WorkbookNamedItem _x = _copy();
        _x.changedFields = changedFields.add("visible");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.workbookNamedItem");
        _x.visible = visible;
        return _x;
    }

    @NavigationProperty(name="worksheet")
    @JsonIgnore
    public WorkbookWorksheetRequest getWorksheet() {
        return new WorkbookWorksheetRequest(contextPath.addSegment("worksheet"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public WorkbookNamedItem patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        WorkbookNamedItem _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public WorkbookNamedItem put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        WorkbookNamedItem _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private WorkbookNamedItem _copy() {
        WorkbookNamedItem _x = new WorkbookNamedItem();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.comment = comment;
        _x.name = name;
        _x.scope = scope;
        _x.type = type;
        _x.value = value;
        _x.visible = visible;
        return _x;
    }

    @Function(name = "range")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<WorkbookRange> range() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new FunctionRequestReturningNonCollectionUnwrapped<WorkbookRange>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.range"), WorkbookRange.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("WorkbookNamedItem[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("comment=");
        b.append(this.comment);
        b.append(", ");
        b.append("name=");
        b.append(this.name);
        b.append(", ");
        b.append("scope=");
        b.append(this.scope);
        b.append(", ");
        b.append("type=");
        b.append(this.type);
        b.append(", ");
        b.append("value=");
        b.append(this.value);
        b.append(", ");
        b.append("visible=");
        b.append(this.visible);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
