package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.guavamini.Preconditions;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.TypedObject;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.complex.Json;
import odata.msgraph.client.beta.complex.WorkbookFilterCriteria;
import odata.msgraph.client.beta.complex.WorkbookIcon;

@JsonPropertyOrder({
    "@odata.type", 
    "criteria"})
@JsonInclude(Include.NON_NULL)
public class WorkbookFilter extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.workbookFilter";
    }

    @JsonProperty("criteria")
    protected WorkbookFilterCriteria criteria;

    protected WorkbookFilter() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderWorkbookFilter() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private WorkbookFilterCriteria criteria;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder criteria(WorkbookFilterCriteria criteria) {
            this.criteria = criteria;
            this.changedFields = changedFields.add("criteria");
            return this;
        }

        public WorkbookFilter build() {
            WorkbookFilter _x = new WorkbookFilter();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.workbookFilter";
            _x.id = id;
            _x.criteria = criteria;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    @Property(name="criteria")
    @JsonIgnore
    public Optional<WorkbookFilterCriteria> getCriteria() {
        return Optional.ofNullable(criteria);
    }

    public WorkbookFilter withCriteria(WorkbookFilterCriteria criteria) {
        WorkbookFilter _x = _copy();
        _x.changedFields = changedFields.add("criteria");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.workbookFilter");
        _x.criteria = criteria;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public WorkbookFilter patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        WorkbookFilter _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public WorkbookFilter put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        WorkbookFilter _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private WorkbookFilter _copy() {
        WorkbookFilter _x = new WorkbookFilter();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.criteria = criteria;
        return _x;
    }

    @Action(name = "apply")
    @JsonIgnore
    public ActionRequestNoReturn apply(WorkbookFilterCriteria criteria) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("criteria", "microsoft.graph.workbookFilterCriteria", criteria)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.apply"), _parameters);
    }

    @Action(name = "applyBottomItemsFilter")
    @JsonIgnore
    public ActionRequestNoReturn applyBottomItemsFilter(Integer count) {
        Preconditions.checkNotNull(count, "count cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("count", "Edm.Int32", count)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.applyBottomItemsFilter"), _parameters);
    }

    @Action(name = "applyBottomPercentFilter")
    @JsonIgnore
    public ActionRequestNoReturn applyBottomPercentFilter(Integer percent) {
        Preconditions.checkNotNull(percent, "percent cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("percent", "Edm.Int32", percent)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.applyBottomPercentFilter"), _parameters);
    }

    @Action(name = "applyCellColorFilter")
    @JsonIgnore
    public ActionRequestNoReturn applyCellColorFilter(String color) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("color", "Edm.String", Checks.checkIsAscii(color))
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.applyCellColorFilter"), _parameters);
    }

    @Action(name = "applyCustomFilter")
    @JsonIgnore
    public ActionRequestNoReturn applyCustomFilter(String criteria1, String criteria2, String oper) {
        Preconditions.checkNotNull(oper, "oper cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("criteria1", "Edm.String", Checks.checkIsAscii(criteria1))
            .put("criteria2", "Edm.String", Checks.checkIsAscii(criteria2))
            .put("oper", "Edm.String", Checks.checkIsAscii(oper))
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.applyCustomFilter"), _parameters);
    }

    @Action(name = "applyDynamicFilter")
    @JsonIgnore
    public ActionRequestNoReturn applyDynamicFilter(String criteria) {
        Preconditions.checkNotNull(criteria, "criteria cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("criteria", "Edm.String", Checks.checkIsAscii(criteria))
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.applyDynamicFilter"), _parameters);
    }

    @Action(name = "applyFontColorFilter")
    @JsonIgnore
    public ActionRequestNoReturn applyFontColorFilter(String color) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("color", "Edm.String", Checks.checkIsAscii(color))
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.applyFontColorFilter"), _parameters);
    }

    @Action(name = "applyIconFilter")
    @JsonIgnore
    public ActionRequestNoReturn applyIconFilter(WorkbookIcon icon) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("icon", "microsoft.graph.workbookIcon", icon)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.applyIconFilter"), _parameters);
    }

    @Action(name = "applyTopItemsFilter")
    @JsonIgnore
    public ActionRequestNoReturn applyTopItemsFilter(Integer count) {
        Preconditions.checkNotNull(count, "count cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("count", "Edm.Int32", count)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.applyTopItemsFilter"), _parameters);
    }

    @Action(name = "applyTopPercentFilter")
    @JsonIgnore
    public ActionRequestNoReturn applyTopPercentFilter(Integer percent) {
        Preconditions.checkNotNull(percent, "percent cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("percent", "Edm.Int32", percent)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.applyTopPercentFilter"), _parameters);
    }

    @Action(name = "applyValuesFilter")
    @JsonIgnore
    public ActionRequestNoReturn applyValuesFilter(Json values) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("values", "microsoft.graph.Json", values)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.applyValuesFilter"), _parameters);
    }

    @Action(name = "clear")
    @JsonIgnore
    public ActionRequestNoReturn clear() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.clear"), _parameters);
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("WorkbookFilter[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("criteria=");
        b.append(this.criteria);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
