package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "bold", 
    "color", 
    "italic", 
    "name", 
    "size", 
    "underline"})
@JsonInclude(Include.NON_NULL)
public class WorkbookChartFont extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.workbookChartFont";
    }

    @JsonProperty("bold")
    protected Boolean bold;

    @JsonProperty("color")
    protected String color;

    @JsonProperty("italic")
    protected Boolean italic;

    @JsonProperty("name")
    protected String name;

    @JsonProperty("size")
    protected Double size;

    @JsonProperty("underline")
    protected String underline;

    protected WorkbookChartFont() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderWorkbookChartFont() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private Boolean bold;
        private String color;
        private Boolean italic;
        private String name;
        private Double size;
        private String underline;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder bold(Boolean bold) {
            this.bold = bold;
            this.changedFields = changedFields.add("bold");
            return this;
        }

        public Builder color(String color) {
            this.color = color;
            this.changedFields = changedFields.add("color");
            return this;
        }

        public Builder italic(Boolean italic) {
            this.italic = italic;
            this.changedFields = changedFields.add("italic");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.changedFields = changedFields.add("name");
            return this;
        }

        public Builder size(Double size) {
            this.size = size;
            this.changedFields = changedFields.add("size");
            return this;
        }

        public Builder underline(String underline) {
            this.underline = underline;
            this.changedFields = changedFields.add("underline");
            return this;
        }

        public WorkbookChartFont build() {
            WorkbookChartFont _x = new WorkbookChartFont();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.workbookChartFont";
            _x.id = id;
            _x.bold = bold;
            _x.color = color;
            _x.italic = italic;
            _x.name = name;
            _x.size = size;
            _x.underline = underline;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    @Property(name="bold")
    @JsonIgnore
    public Optional<Boolean> getBold() {
        return Optional.ofNullable(bold);
    }

    public WorkbookChartFont withBold(Boolean bold) {
        WorkbookChartFont _x = _copy();
        _x.changedFields = changedFields.add("bold");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.workbookChartFont");
        _x.bold = bold;
        return _x;
    }

    @Property(name="color")
    @JsonIgnore
    public Optional<String> getColor() {
        return Optional.ofNullable(color);
    }

    public WorkbookChartFont withColor(String color) {
        WorkbookChartFont _x = _copy();
        _x.changedFields = changedFields.add("color");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.workbookChartFont");
        _x.color = color;
        return _x;
    }

    @Property(name="italic")
    @JsonIgnore
    public Optional<Boolean> getItalic() {
        return Optional.ofNullable(italic);
    }

    public WorkbookChartFont withItalic(Boolean italic) {
        WorkbookChartFont _x = _copy();
        _x.changedFields = changedFields.add("italic");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.workbookChartFont");
        _x.italic = italic;
        return _x;
    }

    @Property(name="name")
    @JsonIgnore
    public Optional<String> getName() {
        return Optional.ofNullable(name);
    }

    public WorkbookChartFont withName(String name) {
        WorkbookChartFont _x = _copy();
        _x.changedFields = changedFields.add("name");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.workbookChartFont");
        _x.name = name;
        return _x;
    }

    @Property(name="size")
    @JsonIgnore
    public Optional<Double> getSize() {
        return Optional.ofNullable(size);
    }

    public WorkbookChartFont withSize(Double size) {
        WorkbookChartFont _x = _copy();
        _x.changedFields = changedFields.add("size");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.workbookChartFont");
        _x.size = size;
        return _x;
    }

    @Property(name="underline")
    @JsonIgnore
    public Optional<String> getUnderline() {
        return Optional.ofNullable(underline);
    }

    public WorkbookChartFont withUnderline(String underline) {
        WorkbookChartFont _x = _copy();
        _x.changedFields = changedFields.add("underline");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.workbookChartFont");
        _x.underline = underline;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public WorkbookChartFont patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        WorkbookChartFont _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public WorkbookChartFont put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        WorkbookChartFont _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private WorkbookChartFont _copy() {
        WorkbookChartFont _x = new WorkbookChartFont();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.bold = bold;
        _x.color = color;
        _x.italic = italic;
        _x.name = name;
        _x.size = size;
        _x.underline = underline;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("WorkbookChartFont[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("bold=");
        b.append(this.bold);
        b.append(", ");
        b.append("color=");
        b.append(this.color);
        b.append(", ");
        b.append("italic=");
        b.append(this.italic);
        b.append(", ");
        b.append("name=");
        b.append(this.name);
        b.append(", ");
        b.append("size=");
        b.append(this.size);
        b.append(", ");
        b.append("underline=");
        b.append(this.underline);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
