package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;

import odata.msgraph.client.beta.entity.request.WorkbookChartAxisTitleFormatRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "text", 
    "visible"})
@JsonInclude(Include.NON_NULL)
public class WorkbookChartAxisTitle extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.workbookChartAxisTitle";
    }

    @JsonProperty("text")
    protected String text;

    @JsonProperty("visible")
    protected Boolean visible;

    protected WorkbookChartAxisTitle() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderWorkbookChartAxisTitle() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String text;
        private Boolean visible;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder text(String text) {
            this.text = text;
            this.changedFields = changedFields.add("text");
            return this;
        }

        public Builder visible(Boolean visible) {
            this.visible = visible;
            this.changedFields = changedFields.add("visible");
            return this;
        }

        public WorkbookChartAxisTitle build() {
            WorkbookChartAxisTitle _x = new WorkbookChartAxisTitle();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.workbookChartAxisTitle";
            _x.id = id;
            _x.text = text;
            _x.visible = visible;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    @Property(name="text")
    @JsonIgnore
    public Optional<String> getText() {
        return Optional.ofNullable(text);
    }

    public WorkbookChartAxisTitle withText(String text) {
        WorkbookChartAxisTitle _x = _copy();
        _x.changedFields = changedFields.add("text");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.workbookChartAxisTitle");
        _x.text = text;
        return _x;
    }

    @Property(name="visible")
    @JsonIgnore
    public Optional<Boolean> getVisible() {
        return Optional.ofNullable(visible);
    }

    public WorkbookChartAxisTitle withVisible(Boolean visible) {
        WorkbookChartAxisTitle _x = _copy();
        _x.changedFields = changedFields.add("visible");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.workbookChartAxisTitle");
        _x.visible = visible;
        return _x;
    }

    @NavigationProperty(name="format")
    @JsonIgnore
    public WorkbookChartAxisTitleFormatRequest getFormat() {
        return new WorkbookChartAxisTitleFormatRequest(contextPath.addSegment("format"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public WorkbookChartAxisTitle patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        WorkbookChartAxisTitle _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public WorkbookChartAxisTitle put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        WorkbookChartAxisTitle _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private WorkbookChartAxisTitle _copy() {
        WorkbookChartAxisTitle _x = new WorkbookChartAxisTitle();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.text = text;
        _x.visible = visible;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("WorkbookChartAxisTitle[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("text=");
        b.append(this.text);
        b.append(", ");
        b.append("visible=");
        b.append(this.visible);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
