package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;

import odata.msgraph.client.beta.complex.Json;
import odata.msgraph.client.beta.entity.request.WorkbookChartAxisFormatRequest;
import odata.msgraph.client.beta.entity.request.WorkbookChartAxisTitleRequest;
import odata.msgraph.client.beta.entity.request.WorkbookChartGridlinesRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "majorUnit", 
    "maximum", 
    "minimum", 
    "minorUnit"})
@JsonInclude(Include.NON_NULL)
public class WorkbookChartAxis extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.workbookChartAxis";
    }

    @JsonProperty("majorUnit")
    protected Json majorUnit;

    @JsonProperty("maximum")
    protected Json maximum;

    @JsonProperty("minimum")
    protected Json minimum;

    @JsonProperty("minorUnit")
    protected Json minorUnit;

    protected WorkbookChartAxis() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderWorkbookChartAxis() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private Json majorUnit;
        private Json maximum;
        private Json minimum;
        private Json minorUnit;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder majorUnit(Json majorUnit) {
            this.majorUnit = majorUnit;
            this.changedFields = changedFields.add("majorUnit");
            return this;
        }

        public Builder maximum(Json maximum) {
            this.maximum = maximum;
            this.changedFields = changedFields.add("maximum");
            return this;
        }

        public Builder minimum(Json minimum) {
            this.minimum = minimum;
            this.changedFields = changedFields.add("minimum");
            return this;
        }

        public Builder minorUnit(Json minorUnit) {
            this.minorUnit = minorUnit;
            this.changedFields = changedFields.add("minorUnit");
            return this;
        }

        public WorkbookChartAxis build() {
            WorkbookChartAxis _x = new WorkbookChartAxis();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.workbookChartAxis";
            _x.id = id;
            _x.majorUnit = majorUnit;
            _x.maximum = maximum;
            _x.minimum = minimum;
            _x.minorUnit = minorUnit;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    @Property(name="majorUnit")
    @JsonIgnore
    public Optional<Json> getMajorUnit() {
        return Optional.ofNullable(majorUnit);
    }

    public WorkbookChartAxis withMajorUnit(Json majorUnit) {
        WorkbookChartAxis _x = _copy();
        _x.changedFields = changedFields.add("majorUnit");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.workbookChartAxis");
        _x.majorUnit = majorUnit;
        return _x;
    }

    @Property(name="maximum")
    @JsonIgnore
    public Optional<Json> getMaximum() {
        return Optional.ofNullable(maximum);
    }

    public WorkbookChartAxis withMaximum(Json maximum) {
        WorkbookChartAxis _x = _copy();
        _x.changedFields = changedFields.add("maximum");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.workbookChartAxis");
        _x.maximum = maximum;
        return _x;
    }

    @Property(name="minimum")
    @JsonIgnore
    public Optional<Json> getMinimum() {
        return Optional.ofNullable(minimum);
    }

    public WorkbookChartAxis withMinimum(Json minimum) {
        WorkbookChartAxis _x = _copy();
        _x.changedFields = changedFields.add("minimum");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.workbookChartAxis");
        _x.minimum = minimum;
        return _x;
    }

    @Property(name="minorUnit")
    @JsonIgnore
    public Optional<Json> getMinorUnit() {
        return Optional.ofNullable(minorUnit);
    }

    public WorkbookChartAxis withMinorUnit(Json minorUnit) {
        WorkbookChartAxis _x = _copy();
        _x.changedFields = changedFields.add("minorUnit");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.workbookChartAxis");
        _x.minorUnit = minorUnit;
        return _x;
    }

    @NavigationProperty(name="format")
    @JsonIgnore
    public WorkbookChartAxisFormatRequest getFormat() {
        return new WorkbookChartAxisFormatRequest(contextPath.addSegment("format"));
    }

    @NavigationProperty(name="majorGridlines")
    @JsonIgnore
    public WorkbookChartGridlinesRequest getMajorGridlines() {
        return new WorkbookChartGridlinesRequest(contextPath.addSegment("majorGridlines"));
    }

    @NavigationProperty(name="minorGridlines")
    @JsonIgnore
    public WorkbookChartGridlinesRequest getMinorGridlines() {
        return new WorkbookChartGridlinesRequest(contextPath.addSegment("minorGridlines"));
    }

    @NavigationProperty(name="title")
    @JsonIgnore
    public WorkbookChartAxisTitleRequest getTitle() {
        return new WorkbookChartAxisTitleRequest(contextPath.addSegment("title"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public WorkbookChartAxis patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        WorkbookChartAxis _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public WorkbookChartAxis put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        WorkbookChartAxis _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private WorkbookChartAxis _copy() {
        WorkbookChartAxis _x = new WorkbookChartAxis();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.majorUnit = majorUnit;
        _x.maximum = maximum;
        _x.minimum = minimum;
        _x.minorUnit = minorUnit;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("WorkbookChartAxis[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("majorUnit=");
        b.append(this.majorUnit);
        b.append(", ");
        b.append("maximum=");
        b.append(this.maximum);
        b.append(", ");
        b.append("minimum=");
        b.append(this.minimum);
        b.append(", ");
        b.append("minorUnit=");
        b.append(this.minorUnit);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
