package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.guavamini.Preconditions;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.ActionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.FunctionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.annotation.Function;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.TypedObject;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Map;

import odata.msgraph.client.beta.complex.WorkbookSessionInfo;
import odata.msgraph.client.beta.entity.collection.request.WorkbookCommentCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.WorkbookNamedItemCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.WorkbookOperationCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.WorkbookTableCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.WorkbookWorksheetCollectionRequest;
import odata.msgraph.client.beta.entity.request.WorkbookApplicationRequest;
import odata.msgraph.client.beta.entity.request.WorkbookFunctionsRequest;

@JsonPropertyOrder({
    "@odata.type"})
@JsonInclude(Include.NON_NULL)
public class Workbook extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.workbook";
    }

    protected Workbook() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderWorkbook() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Workbook build() {
            Workbook _x = new Workbook();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.workbook";
            _x.id = id;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    @NavigationProperty(name="application")
    @JsonIgnore
    public WorkbookApplicationRequest getApplication() {
        return new WorkbookApplicationRequest(contextPath.addSegment("application"));
    }

    @NavigationProperty(name="names")
    @JsonIgnore
    public WorkbookNamedItemCollectionRequest getNames() {
        return new WorkbookNamedItemCollectionRequest(
                        contextPath.addSegment("names"));
    }

    @NavigationProperty(name="tables")
    @JsonIgnore
    public WorkbookTableCollectionRequest getTables() {
        return new WorkbookTableCollectionRequest(
                        contextPath.addSegment("tables"));
    }

    @NavigationProperty(name="worksheets")
    @JsonIgnore
    public WorkbookWorksheetCollectionRequest getWorksheets() {
        return new WorkbookWorksheetCollectionRequest(
                        contextPath.addSegment("worksheets"));
    }

    @NavigationProperty(name="comments")
    @JsonIgnore
    public WorkbookCommentCollectionRequest getComments() {
        return new WorkbookCommentCollectionRequest(
                        contextPath.addSegment("comments"));
    }

    @NavigationProperty(name="functions")
    @JsonIgnore
    public WorkbookFunctionsRequest getFunctions() {
        return new WorkbookFunctionsRequest(contextPath.addSegment("functions"));
    }

    /**
     * <p>
     * <b>Org.OData.Capabilities.V1.TopSupported</b>
     * <p>
     * false
     * <p>
     * <b>Org.OData.Capabilities.V1.SkipSupported</b>
     * <p>
     * false
     * <p>
     * <b>Org.OData.Capabilities.V1.CountRestrictions</b>
     * <p>
     * Countable = false
     * <p>
     * <b>Org.OData.Capabilities.V1.FilterRestrictions</b>
     * <p>
     * Filterable = false
     * 
     * @return navigational property operations
     */
    @NavigationProperty(name="operations")
    @JsonIgnore
    public WorkbookOperationCollectionRequest getOperations() {
        return new WorkbookOperationCollectionRequest(
                        contextPath.addSegment("operations"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Workbook patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Workbook _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Workbook put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Workbook _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Workbook _copy() {
        Workbook _x = new Workbook();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        return _x;
    }

    @Action(name = "createSession")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookSessionInfo> createSession(Boolean persistChanges) {
        Preconditions.checkNotNull(persistChanges, "persistChanges cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("persistChanges", "Edm.Boolean", persistChanges)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookSessionInfo>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.createSession"), WorkbookSessionInfo.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Action(name = "closeSession")
    @JsonIgnore
    public ActionRequestNoReturn closeSession() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.closeSession"), _parameters);
    }

    @Action(name = "refreshSession")
    @JsonIgnore
    public ActionRequestNoReturn refreshSession() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.refreshSession"), _parameters);
    }

    @Function(name = "sessionInfoResource")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<WorkbookSessionInfo> sessionInfoResource(String key) {
        Preconditions.checkNotNull(key, "key cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("key", "Edm.String", Checks.checkIsAscii(key))
            .build();
        return new FunctionRequestReturningNonCollectionUnwrapped<WorkbookSessionInfo>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.sessionInfoResource"), WorkbookSessionInfo.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Workbook[");
        b.append("id=");
        b.append(this.id);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
