package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.complex.DeviceManagementApplicabilityRuleDeviceMode;
import odata.msgraph.client.beta.complex.DeviceManagementApplicabilityRuleOsEdition;
import odata.msgraph.client.beta.complex.DeviceManagementApplicabilityRuleOsVersion;
import odata.msgraph.client.beta.enums.MeteredConnectionLimitType;
import odata.msgraph.client.beta.enums.WiFiProxySetting;
import odata.msgraph.client.beta.enums.WiFiSecurityType;


/**
 * <i>“Device Configuration.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "preSharedKey", 
    "wifiSecurityType", 
    "meteredConnectionLimit", 
    "ssid", 
    "networkName", 
    "connectAutomatically", 
    "connectToPreferredNetwork", 
    "connectWhenNetworkNameIsHidden", 
    "proxySetting", 
    "proxyManualAddress", 
    "proxyManualPort", 
    "proxyAutomaticConfigurationUrl", 
    "forceFIPSCompliance"})
@JsonInclude(Include.NON_NULL)
public class WindowsWifiConfiguration extends DeviceConfiguration implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.windowsWifiConfiguration";
    }

    @JsonProperty("preSharedKey")
    protected String preSharedKey;

    @JsonProperty("wifiSecurityType")
    protected WiFiSecurityType wifiSecurityType;

    @JsonProperty("meteredConnectionLimit")
    protected MeteredConnectionLimitType meteredConnectionLimit;

    @JsonProperty("ssid")
    protected String ssid;

    @JsonProperty("networkName")
    protected String networkName;

    @JsonProperty("connectAutomatically")
    protected Boolean connectAutomatically;

    @JsonProperty("connectToPreferredNetwork")
    protected Boolean connectToPreferredNetwork;

    @JsonProperty("connectWhenNetworkNameIsHidden")
    protected Boolean connectWhenNetworkNameIsHidden;

    @JsonProperty("proxySetting")
    protected WiFiProxySetting proxySetting;

    @JsonProperty("proxyManualAddress")
    protected String proxyManualAddress;

    @JsonProperty("proxyManualPort")
    protected Integer proxyManualPort;

    @JsonProperty("proxyAutomaticConfigurationUrl")
    protected String proxyAutomaticConfigurationUrl;

    @JsonProperty("forceFIPSCompliance")
    protected Boolean forceFIPSCompliance;

    protected WindowsWifiConfiguration() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderWindowsWifiConfiguration() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private OffsetDateTime lastModifiedDateTime;
        private List<String> roleScopeTagIds;
        private String roleScopeTagIdsNextLink;
        private Boolean supportsScopeTags;
        private DeviceManagementApplicabilityRuleOsEdition deviceManagementApplicabilityRuleOsEdition;
        private DeviceManagementApplicabilityRuleOsVersion deviceManagementApplicabilityRuleOsVersion;
        private DeviceManagementApplicabilityRuleDeviceMode deviceManagementApplicabilityRuleDeviceMode;
        private OffsetDateTime createdDateTime;
        private String description;
        private String displayName;
        private Integer version;
        private String preSharedKey;
        private WiFiSecurityType wifiSecurityType;
        private MeteredConnectionLimitType meteredConnectionLimit;
        private String ssid;
        private String networkName;
        private Boolean connectAutomatically;
        private Boolean connectToPreferredNetwork;
        private Boolean connectWhenNetworkNameIsHidden;
        private WiFiProxySetting proxySetting;
        private String proxyManualAddress;
        private Integer proxyManualPort;
        private String proxyAutomaticConfigurationUrl;
        private Boolean forceFIPSCompliance;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder lastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
            this.lastModifiedDateTime = lastModifiedDateTime;
            this.changedFields = changedFields.add("lastModifiedDateTime");
            return this;
        }

        public Builder roleScopeTagIds(List<String> roleScopeTagIds) {
            this.roleScopeTagIds = roleScopeTagIds;
            this.changedFields = changedFields.add("roleScopeTagIds");
            return this;
        }

        public Builder roleScopeTagIds(String... roleScopeTagIds) {
            return roleScopeTagIds(Arrays.asList(roleScopeTagIds));
        }

        public Builder roleScopeTagIdsNextLink(String roleScopeTagIdsNextLink) {
            this.roleScopeTagIdsNextLink = roleScopeTagIdsNextLink;
            this.changedFields = changedFields.add("roleScopeTagIds");
            return this;
        }

        public Builder supportsScopeTags(Boolean supportsScopeTags) {
            this.supportsScopeTags = supportsScopeTags;
            this.changedFields = changedFields.add("supportsScopeTags");
            return this;
        }

        public Builder deviceManagementApplicabilityRuleOsEdition(DeviceManagementApplicabilityRuleOsEdition deviceManagementApplicabilityRuleOsEdition) {
            this.deviceManagementApplicabilityRuleOsEdition = deviceManagementApplicabilityRuleOsEdition;
            this.changedFields = changedFields.add("deviceManagementApplicabilityRuleOsEdition");
            return this;
        }

        public Builder deviceManagementApplicabilityRuleOsVersion(DeviceManagementApplicabilityRuleOsVersion deviceManagementApplicabilityRuleOsVersion) {
            this.deviceManagementApplicabilityRuleOsVersion = deviceManagementApplicabilityRuleOsVersion;
            this.changedFields = changedFields.add("deviceManagementApplicabilityRuleOsVersion");
            return this;
        }

        public Builder deviceManagementApplicabilityRuleDeviceMode(DeviceManagementApplicabilityRuleDeviceMode deviceManagementApplicabilityRuleDeviceMode) {
            this.deviceManagementApplicabilityRuleDeviceMode = deviceManagementApplicabilityRuleDeviceMode;
            this.changedFields = changedFields.add("deviceManagementApplicabilityRuleDeviceMode");
            return this;
        }

        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder version(Integer version) {
            this.version = version;
            this.changedFields = changedFields.add("version");
            return this;
        }

        /**
         * <i>“This is the pre-shared key for WPA Personal Wi-Fi network.”</i>
         * 
         * @param preSharedKey
         *            value of {@code preSharedKey} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder preSharedKey(String preSharedKey) {
            this.preSharedKey = preSharedKey;
            this.changedFields = changedFields.add("preSharedKey");
            return this;
        }

        /**
         * <i>“Specify the Wifi Security Type.”</i>
         * 
         * @param wifiSecurityType
         *            value of {@code wifiSecurityType} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder wifiSecurityType(WiFiSecurityType wifiSecurityType) {
            this.wifiSecurityType = wifiSecurityType;
            this.changedFields = changedFields.add("wifiSecurityType");
            return this;
        }

        /**
         * <i>“Specify the metered connection limit type for the wifi connection.”</i>
         * 
         * @param meteredConnectionLimit
         *            value of {@code meteredConnectionLimit} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder meteredConnectionLimit(MeteredConnectionLimitType meteredConnectionLimit) {
            this.meteredConnectionLimit = meteredConnectionLimit;
            this.changedFields = changedFields.add("meteredConnectionLimit");
            return this;
        }

        /**
         * <i>“Specify the SSID of the wifi connection.”</i>
         * 
         * @param ssid
         *            value of {@code ssid} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder ssid(String ssid) {
            this.ssid = ssid;
            this.changedFields = changedFields.add("ssid");
            return this;
        }

        /**
         * <i>“Specify the network configuration name.”</i>
         * 
         * @param networkName
         *            value of {@code networkName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder networkName(String networkName) {
            this.networkName = networkName;
            this.changedFields = changedFields.add("networkName");
            return this;
        }

        /**
         * <i>“Specify whether the wifi connection should connect automatically when in range.”</i>
         * 
         * @param connectAutomatically
         *            value of {@code connectAutomatically} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder connectAutomatically(Boolean connectAutomatically) {
            this.connectAutomatically = connectAutomatically;
            this.changedFields = changedFields.add("connectAutomatically");
            return this;
        }

        /**
         * <i>“Specify whether the wifi connection should connect to more preferred networks
         * when already connected to this one.  Requires ConnectAutomatically to be true.”</i>
         * 
         * @param connectToPreferredNetwork
         *            value of {@code connectToPreferredNetwork} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder connectToPreferredNetwork(Boolean connectToPreferredNetwork) {
            this.connectToPreferredNetwork = connectToPreferredNetwork;
            this.changedFields = changedFields.add("connectToPreferredNetwork");
            return this;
        }

        /**
         * <i>“Specify whether the wifi connection should connect automatically even when the
         * SSID is not broadcasting.”</i>
         * 
         * @param connectWhenNetworkNameIsHidden
         *            value of {@code connectWhenNetworkNameIsHidden} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder connectWhenNetworkNameIsHidden(Boolean connectWhenNetworkNameIsHidden) {
            this.connectWhenNetworkNameIsHidden = connectWhenNetworkNameIsHidden;
            this.changedFields = changedFields.add("connectWhenNetworkNameIsHidden");
            return this;
        }

        /**
         * <i>“Specify the proxy setting for Wi-Fi configuration”</i>
         * 
         * @param proxySetting
         *            value of {@code proxySetting} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder proxySetting(WiFiProxySetting proxySetting) {
            this.proxySetting = proxySetting;
            this.changedFields = changedFields.add("proxySetting");
            return this;
        }

        /**
         * <i>“Specify the IP address for the proxy server.”</i>
         * 
         * @param proxyManualAddress
         *            value of {@code proxyManualAddress} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder proxyManualAddress(String proxyManualAddress) {
            this.proxyManualAddress = proxyManualAddress;
            this.changedFields = changedFields.add("proxyManualAddress");
            return this;
        }

        /**
         * <i>“Specify the port for the proxy server.”</i>
         * 
         * @param proxyManualPort
         *            value of {@code proxyManualPort} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder proxyManualPort(Integer proxyManualPort) {
            this.proxyManualPort = proxyManualPort;
            this.changedFields = changedFields.add("proxyManualPort");
            return this;
        }

        /**
         * <i>“Specify the URL for the proxy server configuration script.”</i>
         * 
         * @param proxyAutomaticConfigurationUrl
         *            value of {@code proxyAutomaticConfigurationUrl} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder proxyAutomaticConfigurationUrl(String proxyAutomaticConfigurationUrl) {
            this.proxyAutomaticConfigurationUrl = proxyAutomaticConfigurationUrl;
            this.changedFields = changedFields.add("proxyAutomaticConfigurationUrl");
            return this;
        }

        /**
         * <i>“Specify whether to force FIPS compliance.”</i>
         * 
         * @param forceFIPSCompliance
         *            value of {@code forceFIPSCompliance} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder forceFIPSCompliance(Boolean forceFIPSCompliance) {
            this.forceFIPSCompliance = forceFIPSCompliance;
            this.changedFields = changedFields.add("forceFIPSCompliance");
            return this;
        }

        public WindowsWifiConfiguration build() {
            WindowsWifiConfiguration _x = new WindowsWifiConfiguration();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.windowsWifiConfiguration";
            _x.id = id;
            _x.lastModifiedDateTime = lastModifiedDateTime;
            _x.roleScopeTagIds = roleScopeTagIds;
            _x.roleScopeTagIdsNextLink = roleScopeTagIdsNextLink;
            _x.supportsScopeTags = supportsScopeTags;
            _x.deviceManagementApplicabilityRuleOsEdition = deviceManagementApplicabilityRuleOsEdition;
            _x.deviceManagementApplicabilityRuleOsVersion = deviceManagementApplicabilityRuleOsVersion;
            _x.deviceManagementApplicabilityRuleDeviceMode = deviceManagementApplicabilityRuleDeviceMode;
            _x.createdDateTime = createdDateTime;
            _x.description = description;
            _x.displayName = displayName;
            _x.version = version;
            _x.preSharedKey = preSharedKey;
            _x.wifiSecurityType = wifiSecurityType;
            _x.meteredConnectionLimit = meteredConnectionLimit;
            _x.ssid = ssid;
            _x.networkName = networkName;
            _x.connectAutomatically = connectAutomatically;
            _x.connectToPreferredNetwork = connectToPreferredNetwork;
            _x.connectWhenNetworkNameIsHidden = connectWhenNetworkNameIsHidden;
            _x.proxySetting = proxySetting;
            _x.proxyManualAddress = proxyManualAddress;
            _x.proxyManualPort = proxyManualPort;
            _x.proxyAutomaticConfigurationUrl = proxyAutomaticConfigurationUrl;
            _x.forceFIPSCompliance = forceFIPSCompliance;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    /**
     * <i>“This is the pre-shared key for WPA Personal Wi-Fi network.”</i>
     * 
     * @return property preSharedKey
     */
    @Property(name="preSharedKey")
    @JsonIgnore
    public Optional<String> getPreSharedKey() {
        return Optional.ofNullable(preSharedKey);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code preSharedKey}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“This is the pre-shared key for WPA Personal Wi-Fi network.”</i>
     * 
     * @param preSharedKey
     *            new value of {@code preSharedKey} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code preSharedKey} field changed
     */
    public WindowsWifiConfiguration withPreSharedKey(String preSharedKey) {
        WindowsWifiConfiguration _x = _copy();
        _x.changedFields = changedFields.add("preSharedKey");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsWifiConfiguration");
        _x.preSharedKey = preSharedKey;
        return _x;
    }

    /**
     * <i>“Specify the Wifi Security Type.”</i>
     * 
     * @return property wifiSecurityType
     */
    @Property(name="wifiSecurityType")
    @JsonIgnore
    public Optional<WiFiSecurityType> getWifiSecurityType() {
        return Optional.ofNullable(wifiSecurityType);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code wifiSecurityType}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Specify the Wifi Security Type.”</i>
     * 
     * @param wifiSecurityType
     *            new value of {@code wifiSecurityType} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code wifiSecurityType} field changed
     */
    public WindowsWifiConfiguration withWifiSecurityType(WiFiSecurityType wifiSecurityType) {
        WindowsWifiConfiguration _x = _copy();
        _x.changedFields = changedFields.add("wifiSecurityType");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsWifiConfiguration");
        _x.wifiSecurityType = wifiSecurityType;
        return _x;
    }

    /**
     * <i>“Specify the metered connection limit type for the wifi connection.”</i>
     * 
     * @return property meteredConnectionLimit
     */
    @Property(name="meteredConnectionLimit")
    @JsonIgnore
    public Optional<MeteredConnectionLimitType> getMeteredConnectionLimit() {
        return Optional.ofNullable(meteredConnectionLimit);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * meteredConnectionLimit} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Specify the metered connection limit type for the wifi connection.”</i>
     * 
     * @param meteredConnectionLimit
     *            new value of {@code meteredConnectionLimit} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code meteredConnectionLimit} field changed
     */
    public WindowsWifiConfiguration withMeteredConnectionLimit(MeteredConnectionLimitType meteredConnectionLimit) {
        WindowsWifiConfiguration _x = _copy();
        _x.changedFields = changedFields.add("meteredConnectionLimit");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsWifiConfiguration");
        _x.meteredConnectionLimit = meteredConnectionLimit;
        return _x;
    }

    /**
     * <i>“Specify the SSID of the wifi connection.”</i>
     * 
     * @return property ssid
     */
    @Property(name="ssid")
    @JsonIgnore
    public Optional<String> getSsid() {
        return Optional.ofNullable(ssid);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code ssid} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Specify the SSID of the wifi connection.”</i>
     * 
     * @param ssid
     *            new value of {@code ssid} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code ssid} field changed
     */
    public WindowsWifiConfiguration withSsid(String ssid) {
        WindowsWifiConfiguration _x = _copy();
        _x.changedFields = changedFields.add("ssid");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsWifiConfiguration");
        _x.ssid = ssid;
        return _x;
    }

    /**
     * <i>“Specify the network configuration name.”</i>
     * 
     * @return property networkName
     */
    @Property(name="networkName")
    @JsonIgnore
    public Optional<String> getNetworkName() {
        return Optional.ofNullable(networkName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code networkName}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Specify the network configuration name.”</i>
     * 
     * @param networkName
     *            new value of {@code networkName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code networkName} field changed
     */
    public WindowsWifiConfiguration withNetworkName(String networkName) {
        WindowsWifiConfiguration _x = _copy();
        _x.changedFields = changedFields.add("networkName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsWifiConfiguration");
        _x.networkName = networkName;
        return _x;
    }

    /**
     * <i>“Specify whether the wifi connection should connect automatically when in range.”</i>
     * 
     * @return property connectAutomatically
     */
    @Property(name="connectAutomatically")
    @JsonIgnore
    public Optional<Boolean> getConnectAutomatically() {
        return Optional.ofNullable(connectAutomatically);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * connectAutomatically} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Specify whether the wifi connection should connect automatically when in range.”</i>
     * 
     * @param connectAutomatically
     *            new value of {@code connectAutomatically} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code connectAutomatically} field changed
     */
    public WindowsWifiConfiguration withConnectAutomatically(Boolean connectAutomatically) {
        WindowsWifiConfiguration _x = _copy();
        _x.changedFields = changedFields.add("connectAutomatically");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsWifiConfiguration");
        _x.connectAutomatically = connectAutomatically;
        return _x;
    }

    /**
     * <i>“Specify whether the wifi connection should connect to more preferred networks
     * when already connected to this one.  Requires ConnectAutomatically to be true.”</i>
     * 
     * @return property connectToPreferredNetwork
     */
    @Property(name="connectToPreferredNetwork")
    @JsonIgnore
    public Optional<Boolean> getConnectToPreferredNetwork() {
        return Optional.ofNullable(connectToPreferredNetwork);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * connectToPreferredNetwork} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Specify whether the wifi connection should connect to more preferred networks
     * when already connected to this one.  Requires ConnectAutomatically to be true.”</i>
     * 
     * @param connectToPreferredNetwork
     *            new value of {@code connectToPreferredNetwork} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code connectToPreferredNetwork} field changed
     */
    public WindowsWifiConfiguration withConnectToPreferredNetwork(Boolean connectToPreferredNetwork) {
        WindowsWifiConfiguration _x = _copy();
        _x.changedFields = changedFields.add("connectToPreferredNetwork");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsWifiConfiguration");
        _x.connectToPreferredNetwork = connectToPreferredNetwork;
        return _x;
    }

    /**
     * <i>“Specify whether the wifi connection should connect automatically even when the
     * SSID is not broadcasting.”</i>
     * 
     * @return property connectWhenNetworkNameIsHidden
     */
    @Property(name="connectWhenNetworkNameIsHidden")
    @JsonIgnore
    public Optional<Boolean> getConnectWhenNetworkNameIsHidden() {
        return Optional.ofNullable(connectWhenNetworkNameIsHidden);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * connectWhenNetworkNameIsHidden} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Specify whether the wifi connection should connect automatically even when the
     * SSID is not broadcasting.”</i>
     * 
     * @param connectWhenNetworkNameIsHidden
     *            new value of {@code connectWhenNetworkNameIsHidden} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code connectWhenNetworkNameIsHidden} field changed
     */
    public WindowsWifiConfiguration withConnectWhenNetworkNameIsHidden(Boolean connectWhenNetworkNameIsHidden) {
        WindowsWifiConfiguration _x = _copy();
        _x.changedFields = changedFields.add("connectWhenNetworkNameIsHidden");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsWifiConfiguration");
        _x.connectWhenNetworkNameIsHidden = connectWhenNetworkNameIsHidden;
        return _x;
    }

    /**
     * <i>“Specify the proxy setting for Wi-Fi configuration”</i>
     * 
     * @return property proxySetting
     */
    @Property(name="proxySetting")
    @JsonIgnore
    public Optional<WiFiProxySetting> getProxySetting() {
        return Optional.ofNullable(proxySetting);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code proxySetting}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Specify the proxy setting for Wi-Fi configuration”</i>
     * 
     * @param proxySetting
     *            new value of {@code proxySetting} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code proxySetting} field changed
     */
    public WindowsWifiConfiguration withProxySetting(WiFiProxySetting proxySetting) {
        WindowsWifiConfiguration _x = _copy();
        _x.changedFields = changedFields.add("proxySetting");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsWifiConfiguration");
        _x.proxySetting = proxySetting;
        return _x;
    }

    /**
     * <i>“Specify the IP address for the proxy server.”</i>
     * 
     * @return property proxyManualAddress
     */
    @Property(name="proxyManualAddress")
    @JsonIgnore
    public Optional<String> getProxyManualAddress() {
        return Optional.ofNullable(proxyManualAddress);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * proxyManualAddress} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Specify the IP address for the proxy server.”</i>
     * 
     * @param proxyManualAddress
     *            new value of {@code proxyManualAddress} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code proxyManualAddress} field changed
     */
    public WindowsWifiConfiguration withProxyManualAddress(String proxyManualAddress) {
        WindowsWifiConfiguration _x = _copy();
        _x.changedFields = changedFields.add("proxyManualAddress");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsWifiConfiguration");
        _x.proxyManualAddress = proxyManualAddress;
        return _x;
    }

    /**
     * <i>“Specify the port for the proxy server.”</i>
     * 
     * @return property proxyManualPort
     */
    @Property(name="proxyManualPort")
    @JsonIgnore
    public Optional<Integer> getProxyManualPort() {
        return Optional.ofNullable(proxyManualPort);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code proxyManualPort}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Specify the port for the proxy server.”</i>
     * 
     * @param proxyManualPort
     *            new value of {@code proxyManualPort} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code proxyManualPort} field changed
     */
    public WindowsWifiConfiguration withProxyManualPort(Integer proxyManualPort) {
        WindowsWifiConfiguration _x = _copy();
        _x.changedFields = changedFields.add("proxyManualPort");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsWifiConfiguration");
        _x.proxyManualPort = proxyManualPort;
        return _x;
    }

    /**
     * <i>“Specify the URL for the proxy server configuration script.”</i>
     * 
     * @return property proxyAutomaticConfigurationUrl
     */
    @Property(name="proxyAutomaticConfigurationUrl")
    @JsonIgnore
    public Optional<String> getProxyAutomaticConfigurationUrl() {
        return Optional.ofNullable(proxyAutomaticConfigurationUrl);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * proxyAutomaticConfigurationUrl} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Specify the URL for the proxy server configuration script.”</i>
     * 
     * @param proxyAutomaticConfigurationUrl
     *            new value of {@code proxyAutomaticConfigurationUrl} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code proxyAutomaticConfigurationUrl} field changed
     */
    public WindowsWifiConfiguration withProxyAutomaticConfigurationUrl(String proxyAutomaticConfigurationUrl) {
        WindowsWifiConfiguration _x = _copy();
        _x.changedFields = changedFields.add("proxyAutomaticConfigurationUrl");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsWifiConfiguration");
        _x.proxyAutomaticConfigurationUrl = proxyAutomaticConfigurationUrl;
        return _x;
    }

    /**
     * <i>“Specify whether to force FIPS compliance.”</i>
     * 
     * @return property forceFIPSCompliance
     */
    @Property(name="forceFIPSCompliance")
    @JsonIgnore
    public Optional<Boolean> getForceFIPSCompliance() {
        return Optional.ofNullable(forceFIPSCompliance);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * forceFIPSCompliance} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Specify whether to force FIPS compliance.”</i>
     * 
     * @param forceFIPSCompliance
     *            new value of {@code forceFIPSCompliance} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code forceFIPSCompliance} field changed
     */
    public WindowsWifiConfiguration withForceFIPSCompliance(Boolean forceFIPSCompliance) {
        WindowsWifiConfiguration _x = _copy();
        _x.changedFields = changedFields.add("forceFIPSCompliance");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsWifiConfiguration");
        _x.forceFIPSCompliance = forceFIPSCompliance;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public WindowsWifiConfiguration patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        WindowsWifiConfiguration _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public WindowsWifiConfiguration put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        WindowsWifiConfiguration _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private WindowsWifiConfiguration _copy() {
        WindowsWifiConfiguration _x = new WindowsWifiConfiguration();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        _x.roleScopeTagIds = roleScopeTagIds;
        _x.supportsScopeTags = supportsScopeTags;
        _x.deviceManagementApplicabilityRuleOsEdition = deviceManagementApplicabilityRuleOsEdition;
        _x.deviceManagementApplicabilityRuleOsVersion = deviceManagementApplicabilityRuleOsVersion;
        _x.deviceManagementApplicabilityRuleDeviceMode = deviceManagementApplicabilityRuleDeviceMode;
        _x.createdDateTime = createdDateTime;
        _x.description = description;
        _x.displayName = displayName;
        _x.version = version;
        _x.preSharedKey = preSharedKey;
        _x.wifiSecurityType = wifiSecurityType;
        _x.meteredConnectionLimit = meteredConnectionLimit;
        _x.ssid = ssid;
        _x.networkName = networkName;
        _x.connectAutomatically = connectAutomatically;
        _x.connectToPreferredNetwork = connectToPreferredNetwork;
        _x.connectWhenNetworkNameIsHidden = connectWhenNetworkNameIsHidden;
        _x.proxySetting = proxySetting;
        _x.proxyManualAddress = proxyManualAddress;
        _x.proxyManualPort = proxyManualPort;
        _x.proxyAutomaticConfigurationUrl = proxyAutomaticConfigurationUrl;
        _x.forceFIPSCompliance = forceFIPSCompliance;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("WindowsWifiConfiguration[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append(", ");
        b.append("roleScopeTagIds=");
        b.append(this.roleScopeTagIds);
        b.append(", ");
        b.append("supportsScopeTags=");
        b.append(this.supportsScopeTags);
        b.append(", ");
        b.append("deviceManagementApplicabilityRuleOsEdition=");
        b.append(this.deviceManagementApplicabilityRuleOsEdition);
        b.append(", ");
        b.append("deviceManagementApplicabilityRuleOsVersion=");
        b.append(this.deviceManagementApplicabilityRuleOsVersion);
        b.append(", ");
        b.append("deviceManagementApplicabilityRuleDeviceMode=");
        b.append(this.deviceManagementApplicabilityRuleDeviceMode);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("version=");
        b.append(this.version);
        b.append(", ");
        b.append("preSharedKey=");
        b.append(this.preSharedKey);
        b.append(", ");
        b.append("wifiSecurityType=");
        b.append(this.wifiSecurityType);
        b.append(", ");
        b.append("meteredConnectionLimit=");
        b.append(this.meteredConnectionLimit);
        b.append(", ");
        b.append("ssid=");
        b.append(this.ssid);
        b.append(", ");
        b.append("networkName=");
        b.append(this.networkName);
        b.append(", ");
        b.append("connectAutomatically=");
        b.append(this.connectAutomatically);
        b.append(", ");
        b.append("connectToPreferredNetwork=");
        b.append(this.connectToPreferredNetwork);
        b.append(", ");
        b.append("connectWhenNetworkNameIsHidden=");
        b.append(this.connectWhenNetworkNameIsHidden);
        b.append(", ");
        b.append("proxySetting=");
        b.append(this.proxySetting);
        b.append(", ");
        b.append("proxyManualAddress=");
        b.append(this.proxyManualAddress);
        b.append(", ");
        b.append("proxyManualPort=");
        b.append(this.proxyManualPort);
        b.append(", ");
        b.append("proxyAutomaticConfigurationUrl=");
        b.append(this.proxyAutomaticConfigurationUrl);
        b.append(", ");
        b.append("forceFIPSCompliance=");
        b.append(this.forceFIPSCompliance);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
