package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.complex.VpnServer;
import odata.msgraph.client.beta.schema.SchemaInfo;


/**
 * <i>“Windows VPN configuration profile.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "connectionName", 
    "servers", 
    "customXml"})
@JsonInclude(Include.NON_NULL)
public class WindowsVpnConfiguration extends DeviceConfiguration implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.windowsVpnConfiguration";
    }

    @JsonProperty("connectionName")
    protected String connectionName;

    @JsonProperty("servers")
    protected List<VpnServer> servers;

    @JsonProperty("servers@nextLink")
    protected String serversNextLink;

    @JsonProperty("customXml")
    protected byte[] customXml;

    protected WindowsVpnConfiguration() {
        super();
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    /**
     * <i>“Connection name displayed to the user.”</i>
     * 
     * @return property connectionName
     */
    @Property(name="connectionName")
    @JsonIgnore
    public Optional<String> getConnectionName() {
        return Optional.ofNullable(connectionName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code connectionName}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Connection name displayed to the user.”</i>
     * 
     * @param connectionName
     *            new value of {@code connectionName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code connectionName} field changed
     */
    public WindowsVpnConfiguration withConnectionName(String connectionName) {
        WindowsVpnConfiguration _x = _copy();
        _x.changedFields = changedFields.add("connectionName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsVpnConfiguration");
        _x.connectionName = connectionName;
        return _x;
    }

    /**
     * <i>“List of VPN Servers on the network. Make sure end users can access these network
     * locations. This collection can contain a maximum of 500 elements.”</i>
     * 
     * @return property servers
     */
    @Property(name="servers")
    @JsonIgnore
    public CollectionPage<VpnServer> getServers() {
        return new CollectionPage<VpnServer>(contextPath, VpnServer.class, servers, Optional.ofNullable(serversNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * <i>“List of VPN Servers on the network. Make sure end users can access these network
     * locations. This collection can contain a maximum of 500 elements.”</i>
     * 
     * @return property servers
     */
    @Property(name="servers")
    @JsonIgnore
    public CollectionPage<VpnServer> getServers(HttpRequestOptions options) {
        return new CollectionPage<VpnServer>(contextPath, VpnServer.class, servers, Optional.ofNullable(serversNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    /**
     * <i>“Custom XML commands that configures the VPN connection. (UTF8 encoded byte array
     * )”</i>
     * 
     * @return property customXml
     */
    @Property(name="customXml")
    @JsonIgnore
    public Optional<byte[]> getCustomXml() {
        return Optional.ofNullable(customXml);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code customXml} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Custom XML commands that configures the VPN connection. (UTF8 encoded byte array
     * )”</i>
     * 
     * @param customXml
     *            new value of {@code customXml} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code customXml} field changed
     */
    public WindowsVpnConfiguration withCustomXml(byte[] customXml) {
        WindowsVpnConfiguration _x = _copy();
        _x.changedFields = changedFields.add("customXml");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsVpnConfiguration");
        _x.customXml = customXml;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public WindowsVpnConfiguration patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        WindowsVpnConfiguration _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public WindowsVpnConfiguration put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        WindowsVpnConfiguration _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private WindowsVpnConfiguration _copy() {
        WindowsVpnConfiguration _x = new WindowsVpnConfiguration();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        _x.roleScopeTagIds = roleScopeTagIds;
        _x.supportsScopeTags = supportsScopeTags;
        _x.deviceManagementApplicabilityRuleOsEdition = deviceManagementApplicabilityRuleOsEdition;
        _x.deviceManagementApplicabilityRuleOsVersion = deviceManagementApplicabilityRuleOsVersion;
        _x.deviceManagementApplicabilityRuleDeviceMode = deviceManagementApplicabilityRuleDeviceMode;
        _x.createdDateTime = createdDateTime;
        _x.description = description;
        _x.displayName = displayName;
        _x.version = version;
        _x.connectionName = connectionName;
        _x.servers = servers;
        _x.customXml = customXml;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("WindowsVpnConfiguration[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append(", ");
        b.append("roleScopeTagIds=");
        b.append(this.roleScopeTagIds);
        b.append(", ");
        b.append("supportsScopeTags=");
        b.append(this.supportsScopeTags);
        b.append(", ");
        b.append("deviceManagementApplicabilityRuleOsEdition=");
        b.append(this.deviceManagementApplicabilityRuleOsEdition);
        b.append(", ");
        b.append("deviceManagementApplicabilityRuleOsVersion=");
        b.append(this.deviceManagementApplicabilityRuleOsVersion);
        b.append(", ");
        b.append("deviceManagementApplicabilityRuleDeviceMode=");
        b.append(this.deviceManagementApplicabilityRuleDeviceMode);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("version=");
        b.append(this.version);
        b.append(", ");
        b.append("connectionName=");
        b.append(this.connectionName);
        b.append(", ");
        b.append("servers=");
        b.append(this.servers);
        b.append(", ");
        b.append("customXml=");
        b.append(this.customXml);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
