package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.OffsetDateTime;
import java.util.Optional;

import odata.msgraph.client.beta.enums.WindowsUpdateStatus;

@JsonPropertyOrder({
    "@odata.type", 
    "deviceId", 
    "userId", 
    "deviceDisplayName", 
    "userPrincipalName", 
    "status", 
    "qualityUpdateVersion", 
    "featureUpdateVersion", 
    "lastScanDateTime", 
    "lastSyncDateTime"})
@JsonInclude(Include.NON_NULL)
public class WindowsUpdateState extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.windowsUpdateState";
    }

    @JsonProperty("deviceId")
    protected String deviceId;

    @JsonProperty("userId")
    protected String userId;

    @JsonProperty("deviceDisplayName")
    protected String deviceDisplayName;

    @JsonProperty("userPrincipalName")
    protected String userPrincipalName;

    @JsonProperty("status")
    protected WindowsUpdateStatus status;

    @JsonProperty("qualityUpdateVersion")
    protected String qualityUpdateVersion;

    @JsonProperty("featureUpdateVersion")
    protected String featureUpdateVersion;

    @JsonProperty("lastScanDateTime")
    protected OffsetDateTime lastScanDateTime;

    @JsonProperty("lastSyncDateTime")
    protected OffsetDateTime lastSyncDateTime;

    protected WindowsUpdateState() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderWindowsUpdateState() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String deviceId;
        private String userId;
        private String deviceDisplayName;
        private String userPrincipalName;
        private WindowsUpdateStatus status;
        private String qualityUpdateVersion;
        private String featureUpdateVersion;
        private OffsetDateTime lastScanDateTime;
        private OffsetDateTime lastSyncDateTime;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        /**
         * <i>“The id of the device.”</i>
         * 
         * @param deviceId
         *            value of {@code deviceId} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder deviceId(String deviceId) {
            this.deviceId = deviceId;
            this.changedFields = changedFields.add("deviceId");
            return this;
        }

        /**
         * <i>“The id of the user.”</i>
         * 
         * @param userId
         *            value of {@code userId} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder userId(String userId) {
            this.userId = userId;
            this.changedFields = changedFields.add("userId");
            return this;
        }

        /**
         * <i>“Device display name.”</i>
         * 
         * @param deviceDisplayName
         *            value of {@code deviceDisplayName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder deviceDisplayName(String deviceDisplayName) {
            this.deviceDisplayName = deviceDisplayName;
            this.changedFields = changedFields.add("deviceDisplayName");
            return this;
        }

        /**
         * <i>“User principal name.”</i>
         * 
         * @param userPrincipalName
         *            value of {@code userPrincipalName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder userPrincipalName(String userPrincipalName) {
            this.userPrincipalName = userPrincipalName;
            this.changedFields = changedFields.add("userPrincipalName");
            return this;
        }

        /**
         * <i>“Windows udpate status.”</i>
         * 
         * @param status
         *            value of {@code status} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder status(WindowsUpdateStatus status) {
            this.status = status;
            this.changedFields = changedFields.add("status");
            return this;
        }

        /**
         * <i>“The Quality Update Version of the device.”</i>
         * 
         * @param qualityUpdateVersion
         *            value of {@code qualityUpdateVersion} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder qualityUpdateVersion(String qualityUpdateVersion) {
            this.qualityUpdateVersion = qualityUpdateVersion;
            this.changedFields = changedFields.add("qualityUpdateVersion");
            return this;
        }

        /**
         * <i>“The current feature update version of the device.”</i>
         * 
         * @param featureUpdateVersion
         *            value of {@code featureUpdateVersion} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder featureUpdateVersion(String featureUpdateVersion) {
            this.featureUpdateVersion = featureUpdateVersion;
            this.changedFields = changedFields.add("featureUpdateVersion");
            return this;
        }

        /**
         * <i>“The date time that the Windows Update Agent did a successful scan.”</i>
         * 
         * @param lastScanDateTime
         *            value of {@code lastScanDateTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder lastScanDateTime(OffsetDateTime lastScanDateTime) {
            this.lastScanDateTime = lastScanDateTime;
            this.changedFields = changedFields.add("lastScanDateTime");
            return this;
        }

        /**
         * <i>“Last date time that the device sync with with Microsoft Intune.”</i>
         * 
         * @param lastSyncDateTime
         *            value of {@code lastSyncDateTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder lastSyncDateTime(OffsetDateTime lastSyncDateTime) {
            this.lastSyncDateTime = lastSyncDateTime;
            this.changedFields = changedFields.add("lastSyncDateTime");
            return this;
        }

        public WindowsUpdateState build() {
            WindowsUpdateState _x = new WindowsUpdateState();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.windowsUpdateState";
            _x.id = id;
            _x.deviceId = deviceId;
            _x.userId = userId;
            _x.deviceDisplayName = deviceDisplayName;
            _x.userPrincipalName = userPrincipalName;
            _x.status = status;
            _x.qualityUpdateVersion = qualityUpdateVersion;
            _x.featureUpdateVersion = featureUpdateVersion;
            _x.lastScanDateTime = lastScanDateTime;
            _x.lastSyncDateTime = lastSyncDateTime;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    /**
     * <i>“The id of the device.”</i>
     * 
     * @return property deviceId
     */
    @Property(name="deviceId")
    @JsonIgnore
    public Optional<String> getDeviceId() {
        return Optional.ofNullable(deviceId);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code deviceId} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“The id of the device.”</i>
     * 
     * @param deviceId
     *            new value of {@code deviceId} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code deviceId} field changed
     */
    public WindowsUpdateState withDeviceId(String deviceId) {
        WindowsUpdateState _x = _copy();
        _x.changedFields = changedFields.add("deviceId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsUpdateState");
        _x.deviceId = deviceId;
        return _x;
    }

    /**
     * <i>“The id of the user.”</i>
     * 
     * @return property userId
     */
    @Property(name="userId")
    @JsonIgnore
    public Optional<String> getUserId() {
        return Optional.ofNullable(userId);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code userId} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“The id of the user.”</i>
     * 
     * @param userId
     *            new value of {@code userId} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code userId} field changed
     */
    public WindowsUpdateState withUserId(String userId) {
        WindowsUpdateState _x = _copy();
        _x.changedFields = changedFields.add("userId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsUpdateState");
        _x.userId = userId;
        return _x;
    }

    /**
     * <i>“Device display name.”</i>
     * 
     * @return property deviceDisplayName
     */
    @Property(name="deviceDisplayName")
    @JsonIgnore
    public Optional<String> getDeviceDisplayName() {
        return Optional.ofNullable(deviceDisplayName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code deviceDisplayName
     * } field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Device display name.”</i>
     * 
     * @param deviceDisplayName
     *            new value of {@code deviceDisplayName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code deviceDisplayName} field changed
     */
    public WindowsUpdateState withDeviceDisplayName(String deviceDisplayName) {
        WindowsUpdateState _x = _copy();
        _x.changedFields = changedFields.add("deviceDisplayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsUpdateState");
        _x.deviceDisplayName = deviceDisplayName;
        return _x;
    }

    /**
     * <i>“User principal name.”</i>
     * 
     * @return property userPrincipalName
     */
    @Property(name="userPrincipalName")
    @JsonIgnore
    public Optional<String> getUserPrincipalName() {
        return Optional.ofNullable(userPrincipalName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code userPrincipalName
     * } field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“User principal name.”</i>
     * 
     * @param userPrincipalName
     *            new value of {@code userPrincipalName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code userPrincipalName} field changed
     */
    public WindowsUpdateState withUserPrincipalName(String userPrincipalName) {
        WindowsUpdateState _x = _copy();
        _x.changedFields = changedFields.add("userPrincipalName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsUpdateState");
        _x.userPrincipalName = userPrincipalName;
        return _x;
    }

    /**
     * <i>“Windows udpate status.”</i>
     * 
     * @return property status
     */
    @Property(name="status")
    @JsonIgnore
    public Optional<WindowsUpdateStatus> getStatus() {
        return Optional.ofNullable(status);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code status} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Windows udpate status.”</i>
     * 
     * @param status
     *            new value of {@code status} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code status} field changed
     */
    public WindowsUpdateState withStatus(WindowsUpdateStatus status) {
        WindowsUpdateState _x = _copy();
        _x.changedFields = changedFields.add("status");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsUpdateState");
        _x.status = status;
        return _x;
    }

    /**
     * <i>“The Quality Update Version of the device.”</i>
     * 
     * @return property qualityUpdateVersion
     */
    @Property(name="qualityUpdateVersion")
    @JsonIgnore
    public Optional<String> getQualityUpdateVersion() {
        return Optional.ofNullable(qualityUpdateVersion);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * qualityUpdateVersion} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“The Quality Update Version of the device.”</i>
     * 
     * @param qualityUpdateVersion
     *            new value of {@code qualityUpdateVersion} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code qualityUpdateVersion} field changed
     */
    public WindowsUpdateState withQualityUpdateVersion(String qualityUpdateVersion) {
        WindowsUpdateState _x = _copy();
        _x.changedFields = changedFields.add("qualityUpdateVersion");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsUpdateState");
        _x.qualityUpdateVersion = qualityUpdateVersion;
        return _x;
    }

    /**
     * <i>“The current feature update version of the device.”</i>
     * 
     * @return property featureUpdateVersion
     */
    @Property(name="featureUpdateVersion")
    @JsonIgnore
    public Optional<String> getFeatureUpdateVersion() {
        return Optional.ofNullable(featureUpdateVersion);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * featureUpdateVersion} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“The current feature update version of the device.”</i>
     * 
     * @param featureUpdateVersion
     *            new value of {@code featureUpdateVersion} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code featureUpdateVersion} field changed
     */
    public WindowsUpdateState withFeatureUpdateVersion(String featureUpdateVersion) {
        WindowsUpdateState _x = _copy();
        _x.changedFields = changedFields.add("featureUpdateVersion");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsUpdateState");
        _x.featureUpdateVersion = featureUpdateVersion;
        return _x;
    }

    /**
     * <i>“The date time that the Windows Update Agent did a successful scan.”</i>
     * 
     * @return property lastScanDateTime
     */
    @Property(name="lastScanDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getLastScanDateTime() {
        return Optional.ofNullable(lastScanDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code lastScanDateTime}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The date time that the Windows Update Agent did a successful scan.”</i>
     * 
     * @param lastScanDateTime
     *            new value of {@code lastScanDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code lastScanDateTime} field changed
     */
    public WindowsUpdateState withLastScanDateTime(OffsetDateTime lastScanDateTime) {
        WindowsUpdateState _x = _copy();
        _x.changedFields = changedFields.add("lastScanDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsUpdateState");
        _x.lastScanDateTime = lastScanDateTime;
        return _x;
    }

    /**
     * <i>“Last date time that the device sync with with Microsoft Intune.”</i>
     * 
     * @return property lastSyncDateTime
     */
    @Property(name="lastSyncDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getLastSyncDateTime() {
        return Optional.ofNullable(lastSyncDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code lastSyncDateTime}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Last date time that the device sync with with Microsoft Intune.”</i>
     * 
     * @param lastSyncDateTime
     *            new value of {@code lastSyncDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code lastSyncDateTime} field changed
     */
    public WindowsUpdateState withLastSyncDateTime(OffsetDateTime lastSyncDateTime) {
        WindowsUpdateState _x = _copy();
        _x.changedFields = changedFields.add("lastSyncDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsUpdateState");
        _x.lastSyncDateTime = lastSyncDateTime;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public WindowsUpdateState patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        WindowsUpdateState _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public WindowsUpdateState put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        WindowsUpdateState _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private WindowsUpdateState _copy() {
        WindowsUpdateState _x = new WindowsUpdateState();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.deviceId = deviceId;
        _x.userId = userId;
        _x.deviceDisplayName = deviceDisplayName;
        _x.userPrincipalName = userPrincipalName;
        _x.status = status;
        _x.qualityUpdateVersion = qualityUpdateVersion;
        _x.featureUpdateVersion = featureUpdateVersion;
        _x.lastScanDateTime = lastScanDateTime;
        _x.lastSyncDateTime = lastSyncDateTime;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("WindowsUpdateState[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("deviceId=");
        b.append(this.deviceId);
        b.append(", ");
        b.append("userId=");
        b.append(this.userId);
        b.append(", ");
        b.append("deviceDisplayName=");
        b.append(this.deviceDisplayName);
        b.append(", ");
        b.append("userPrincipalName=");
        b.append(this.userPrincipalName);
        b.append(", ");
        b.append("status=");
        b.append(this.status);
        b.append(", ");
        b.append("qualityUpdateVersion=");
        b.append(this.qualityUpdateVersion);
        b.append(", ");
        b.append("featureUpdateVersion=");
        b.append(this.featureUpdateVersion);
        b.append(", ");
        b.append("lastScanDateTime=");
        b.append(this.lastScanDateTime);
        b.append(", ");
        b.append("lastSyncDateTime=");
        b.append(this.lastSyncDateTime);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
