package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.complex.MimeContent;
import odata.msgraph.client.beta.complex.WindowsMinimumOperatingSystem;
import odata.msgraph.client.beta.entity.collection.request.MobileContainedAppCollectionRequest;
import odata.msgraph.client.beta.enums.MobileAppPublishingState;
import odata.msgraph.client.beta.enums.WindowsArchitecture;
import odata.msgraph.client.beta.enums.WindowsDeviceType;


/**
 * <i>“Contains properties and inherited properties for Windows Universal AppX Line Of
 * Business apps.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "applicableArchitectures", 
    "applicableDeviceTypes", 
    "identityName", 
    "identityPublisherHash", 
    "identityResourceIdentifier", 
    "isBundle", 
    "minimumSupportedOperatingSystem", 
    "identityVersion"})
@JsonInclude(Include.NON_NULL)
public class WindowsUniversalAppX extends MobileLobApp implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.windowsUniversalAppX";
    }

    @JsonProperty("applicableArchitectures")
    protected WindowsArchitecture applicableArchitectures;

    @JsonProperty("applicableDeviceTypes")
    protected WindowsDeviceType applicableDeviceTypes;

    @JsonProperty("identityName")
    protected String identityName;

    @JsonProperty("identityPublisherHash")
    protected String identityPublisherHash;

    @JsonProperty("identityResourceIdentifier")
    protected String identityResourceIdentifier;

    @JsonProperty("isBundle")
    protected Boolean isBundle;

    @JsonProperty("minimumSupportedOperatingSystem")
    protected WindowsMinimumOperatingSystem minimumSupportedOperatingSystem;

    @JsonProperty("identityVersion")
    protected String identityVersion;

    protected WindowsUniversalAppX() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderWindowsUniversalAppX() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String displayName;
        private String description;
        private String publisher;
        private MimeContent largeIcon;
        private OffsetDateTime createdDateTime;
        private OffsetDateTime lastModifiedDateTime;
        private Boolean isFeatured;
        private String privacyInformationUrl;
        private String informationUrl;
        private String owner;
        private String developer;
        private String notes;
        private Integer uploadState;
        private MobileAppPublishingState publishingState;
        private Boolean isAssigned;
        private List<String> roleScopeTagIds;
        private String roleScopeTagIdsNextLink;
        private Integer dependentAppCount;
        private String committedContentVersion;
        private String fileName;
        private Long size;
        private WindowsArchitecture applicableArchitectures;
        private WindowsDeviceType applicableDeviceTypes;
        private String identityName;
        private String identityPublisherHash;
        private String identityResourceIdentifier;
        private Boolean isBundle;
        private WindowsMinimumOperatingSystem minimumSupportedOperatingSystem;
        private String identityVersion;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder publisher(String publisher) {
            this.publisher = publisher;
            this.changedFields = changedFields.add("publisher");
            return this;
        }

        public Builder largeIcon(MimeContent largeIcon) {
            this.largeIcon = largeIcon;
            this.changedFields = changedFields.add("largeIcon");
            return this;
        }

        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        public Builder lastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
            this.lastModifiedDateTime = lastModifiedDateTime;
            this.changedFields = changedFields.add("lastModifiedDateTime");
            return this;
        }

        public Builder isFeatured(Boolean isFeatured) {
            this.isFeatured = isFeatured;
            this.changedFields = changedFields.add("isFeatured");
            return this;
        }

        public Builder privacyInformationUrl(String privacyInformationUrl) {
            this.privacyInformationUrl = privacyInformationUrl;
            this.changedFields = changedFields.add("privacyInformationUrl");
            return this;
        }

        public Builder informationUrl(String informationUrl) {
            this.informationUrl = informationUrl;
            this.changedFields = changedFields.add("informationUrl");
            return this;
        }

        public Builder owner(String owner) {
            this.owner = owner;
            this.changedFields = changedFields.add("owner");
            return this;
        }

        public Builder developer(String developer) {
            this.developer = developer;
            this.changedFields = changedFields.add("developer");
            return this;
        }

        public Builder notes(String notes) {
            this.notes = notes;
            this.changedFields = changedFields.add("notes");
            return this;
        }

        public Builder uploadState(Integer uploadState) {
            this.uploadState = uploadState;
            this.changedFields = changedFields.add("uploadState");
            return this;
        }

        public Builder publishingState(MobileAppPublishingState publishingState) {
            this.publishingState = publishingState;
            this.changedFields = changedFields.add("publishingState");
            return this;
        }

        public Builder isAssigned(Boolean isAssigned) {
            this.isAssigned = isAssigned;
            this.changedFields = changedFields.add("isAssigned");
            return this;
        }

        public Builder roleScopeTagIds(List<String> roleScopeTagIds) {
            this.roleScopeTagIds = roleScopeTagIds;
            this.changedFields = changedFields.add("roleScopeTagIds");
            return this;
        }

        public Builder roleScopeTagIds(String... roleScopeTagIds) {
            return roleScopeTagIds(Arrays.asList(roleScopeTagIds));
        }

        public Builder roleScopeTagIdsNextLink(String roleScopeTagIdsNextLink) {
            this.roleScopeTagIdsNextLink = roleScopeTagIdsNextLink;
            this.changedFields = changedFields.add("roleScopeTagIds");
            return this;
        }

        public Builder dependentAppCount(Integer dependentAppCount) {
            this.dependentAppCount = dependentAppCount;
            this.changedFields = changedFields.add("dependentAppCount");
            return this;
        }

        public Builder committedContentVersion(String committedContentVersion) {
            this.committedContentVersion = committedContentVersion;
            this.changedFields = changedFields.add("committedContentVersion");
            return this;
        }

        public Builder fileName(String fileName) {
            this.fileName = fileName;
            this.changedFields = changedFields.add("fileName");
            return this;
        }

        public Builder size(Long size) {
            this.size = size;
            this.changedFields = changedFields.add("size");
            return this;
        }

        /**
         * <i>“The Windows architecture(s) for which this app can run on.”</i>
         * 
         * @param applicableArchitectures
         *            value of {@code applicableArchitectures} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder applicableArchitectures(WindowsArchitecture applicableArchitectures) {
            this.applicableArchitectures = applicableArchitectures;
            this.changedFields = changedFields.add("applicableArchitectures");
            return this;
        }

        /**
         * <i>“The Windows device type(s) for which this app can run on.”</i>
         * 
         * @param applicableDeviceTypes
         *            value of {@code applicableDeviceTypes} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder applicableDeviceTypes(WindowsDeviceType applicableDeviceTypes) {
            this.applicableDeviceTypes = applicableDeviceTypes;
            this.changedFields = changedFields.add("applicableDeviceTypes");
            return this;
        }

        /**
         * <i>“The Identity Name.”</i>
         * 
         * @param identityName
         *            value of {@code identityName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder identityName(String identityName) {
            this.identityName = identityName;
            this.changedFields = changedFields.add("identityName");
            return this;
        }

        /**
         * <i>“The Identity Publisher Hash.”</i>
         * 
         * @param identityPublisherHash
         *            value of {@code identityPublisherHash} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder identityPublisherHash(String identityPublisherHash) {
            this.identityPublisherHash = identityPublisherHash;
            this.changedFields = changedFields.add("identityPublisherHash");
            return this;
        }

        /**
         * <i>“The Identity Resource Identifier.”</i>
         * 
         * @param identityResourceIdentifier
         *            value of {@code identityResourceIdentifier} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder identityResourceIdentifier(String identityResourceIdentifier) {
            this.identityResourceIdentifier = identityResourceIdentifier;
            this.changedFields = changedFields.add("identityResourceIdentifier");
            return this;
        }

        /**
         * <i>“Whether or not the app is a bundle.”</i>
         * 
         * @param isBundle
         *            value of {@code isBundle} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder isBundle(Boolean isBundle) {
            this.isBundle = isBundle;
            this.changedFields = changedFields.add("isBundle");
            return this;
        }

        /**
         * <i>“The value for the minimum applicable operating system.”</i>
         * 
         * @param minimumSupportedOperatingSystem
         *            value of {@code minimumSupportedOperatingSystem} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder minimumSupportedOperatingSystem(WindowsMinimumOperatingSystem minimumSupportedOperatingSystem) {
            this.minimumSupportedOperatingSystem = minimumSupportedOperatingSystem;
            this.changedFields = changedFields.add("minimumSupportedOperatingSystem");
            return this;
        }

        /**
         * <i>“The identity version.”</i>
         * 
         * @param identityVersion
         *            value of {@code identityVersion} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder identityVersion(String identityVersion) {
            this.identityVersion = identityVersion;
            this.changedFields = changedFields.add("identityVersion");
            return this;
        }

        public WindowsUniversalAppX build() {
            WindowsUniversalAppX _x = new WindowsUniversalAppX();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.windowsUniversalAppX";
            _x.id = id;
            _x.displayName = displayName;
            _x.description = description;
            _x.publisher = publisher;
            _x.largeIcon = largeIcon;
            _x.createdDateTime = createdDateTime;
            _x.lastModifiedDateTime = lastModifiedDateTime;
            _x.isFeatured = isFeatured;
            _x.privacyInformationUrl = privacyInformationUrl;
            _x.informationUrl = informationUrl;
            _x.owner = owner;
            _x.developer = developer;
            _x.notes = notes;
            _x.uploadState = uploadState;
            _x.publishingState = publishingState;
            _x.isAssigned = isAssigned;
            _x.roleScopeTagIds = roleScopeTagIds;
            _x.roleScopeTagIdsNextLink = roleScopeTagIdsNextLink;
            _x.dependentAppCount = dependentAppCount;
            _x.committedContentVersion = committedContentVersion;
            _x.fileName = fileName;
            _x.size = size;
            _x.applicableArchitectures = applicableArchitectures;
            _x.applicableDeviceTypes = applicableDeviceTypes;
            _x.identityName = identityName;
            _x.identityPublisherHash = identityPublisherHash;
            _x.identityResourceIdentifier = identityResourceIdentifier;
            _x.isBundle = isBundle;
            _x.minimumSupportedOperatingSystem = minimumSupportedOperatingSystem;
            _x.identityVersion = identityVersion;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    /**
     * <i>“The Windows architecture(s) for which this app can run on.”</i>
     * 
     * @return property applicableArchitectures
     */
    @Property(name="applicableArchitectures")
    @JsonIgnore
    public Optional<WindowsArchitecture> getApplicableArchitectures() {
        return Optional.ofNullable(applicableArchitectures);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * applicableArchitectures} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“The Windows architecture(s) for which this app can run on.”</i>
     * 
     * @param applicableArchitectures
     *            new value of {@code applicableArchitectures} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code applicableArchitectures} field changed
     */
    public WindowsUniversalAppX withApplicableArchitectures(WindowsArchitecture applicableArchitectures) {
        WindowsUniversalAppX _x = _copy();
        _x.changedFields = changedFields.add("applicableArchitectures");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsUniversalAppX");
        _x.applicableArchitectures = applicableArchitectures;
        return _x;
    }

    /**
     * <i>“The Windows device type(s) for which this app can run on.”</i>
     * 
     * @return property applicableDeviceTypes
     */
    @Property(name="applicableDeviceTypes")
    @JsonIgnore
    public Optional<WindowsDeviceType> getApplicableDeviceTypes() {
        return Optional.ofNullable(applicableDeviceTypes);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * applicableDeviceTypes} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“The Windows device type(s) for which this app can run on.”</i>
     * 
     * @param applicableDeviceTypes
     *            new value of {@code applicableDeviceTypes} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code applicableDeviceTypes} field changed
     */
    public WindowsUniversalAppX withApplicableDeviceTypes(WindowsDeviceType applicableDeviceTypes) {
        WindowsUniversalAppX _x = _copy();
        _x.changedFields = changedFields.add("applicableDeviceTypes");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsUniversalAppX");
        _x.applicableDeviceTypes = applicableDeviceTypes;
        return _x;
    }

    /**
     * <i>“The Identity Name.”</i>
     * 
     * @return property identityName
     */
    @Property(name="identityName")
    @JsonIgnore
    public Optional<String> getIdentityName() {
        return Optional.ofNullable(identityName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code identityName}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The Identity Name.”</i>
     * 
     * @param identityName
     *            new value of {@code identityName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code identityName} field changed
     */
    public WindowsUniversalAppX withIdentityName(String identityName) {
        WindowsUniversalAppX _x = _copy();
        _x.changedFields = changedFields.add("identityName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsUniversalAppX");
        _x.identityName = identityName;
        return _x;
    }

    /**
     * <i>“The Identity Publisher Hash.”</i>
     * 
     * @return property identityPublisherHash
     */
    @Property(name="identityPublisherHash")
    @JsonIgnore
    public Optional<String> getIdentityPublisherHash() {
        return Optional.ofNullable(identityPublisherHash);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * identityPublisherHash} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“The Identity Publisher Hash.”</i>
     * 
     * @param identityPublisherHash
     *            new value of {@code identityPublisherHash} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code identityPublisherHash} field changed
     */
    public WindowsUniversalAppX withIdentityPublisherHash(String identityPublisherHash) {
        WindowsUniversalAppX _x = _copy();
        _x.changedFields = changedFields.add("identityPublisherHash");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsUniversalAppX");
        _x.identityPublisherHash = identityPublisherHash;
        return _x;
    }

    /**
     * <i>“The Identity Resource Identifier.”</i>
     * 
     * @return property identityResourceIdentifier
     */
    @Property(name="identityResourceIdentifier")
    @JsonIgnore
    public Optional<String> getIdentityResourceIdentifier() {
        return Optional.ofNullable(identityResourceIdentifier);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * identityResourceIdentifier} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“The Identity Resource Identifier.”</i>
     * 
     * @param identityResourceIdentifier
     *            new value of {@code identityResourceIdentifier} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code identityResourceIdentifier} field changed
     */
    public WindowsUniversalAppX withIdentityResourceIdentifier(String identityResourceIdentifier) {
        WindowsUniversalAppX _x = _copy();
        _x.changedFields = changedFields.add("identityResourceIdentifier");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsUniversalAppX");
        _x.identityResourceIdentifier = identityResourceIdentifier;
        return _x;
    }

    /**
     * <i>“Whether or not the app is a bundle.”</i>
     * 
     * @return property isBundle
     */
    @Property(name="isBundle")
    @JsonIgnore
    public Optional<Boolean> getIsBundle() {
        return Optional.ofNullable(isBundle);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code isBundle} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Whether or not the app is a bundle.”</i>
     * 
     * @param isBundle
     *            new value of {@code isBundle} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code isBundle} field changed
     */
    public WindowsUniversalAppX withIsBundle(Boolean isBundle) {
        WindowsUniversalAppX _x = _copy();
        _x.changedFields = changedFields.add("isBundle");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsUniversalAppX");
        _x.isBundle = isBundle;
        return _x;
    }

    /**
     * <i>“The value for the minimum applicable operating system.”</i>
     * 
     * @return property minimumSupportedOperatingSystem
     */
    @Property(name="minimumSupportedOperatingSystem")
    @JsonIgnore
    public Optional<WindowsMinimumOperatingSystem> getMinimumSupportedOperatingSystem() {
        return Optional.ofNullable(minimumSupportedOperatingSystem);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * minimumSupportedOperatingSystem} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“The value for the minimum applicable operating system.”</i>
     * 
     * @param minimumSupportedOperatingSystem
     *            new value of {@code minimumSupportedOperatingSystem} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code minimumSupportedOperatingSystem} field changed
     */
    public WindowsUniversalAppX withMinimumSupportedOperatingSystem(WindowsMinimumOperatingSystem minimumSupportedOperatingSystem) {
        WindowsUniversalAppX _x = _copy();
        _x.changedFields = changedFields.add("minimumSupportedOperatingSystem");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsUniversalAppX");
        _x.minimumSupportedOperatingSystem = minimumSupportedOperatingSystem;
        return _x;
    }

    /**
     * <i>“The identity version.”</i>
     * 
     * @return property identityVersion
     */
    @Property(name="identityVersion")
    @JsonIgnore
    public Optional<String> getIdentityVersion() {
        return Optional.ofNullable(identityVersion);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code identityVersion}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The identity version.”</i>
     * 
     * @param identityVersion
     *            new value of {@code identityVersion} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code identityVersion} field changed
     */
    public WindowsUniversalAppX withIdentityVersion(String identityVersion) {
        WindowsUniversalAppX _x = _copy();
        _x.changedFields = changedFields.add("identityVersion");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsUniversalAppX");
        _x.identityVersion = identityVersion;
        return _x;
    }

    /**
     * <i>“The collection of contained apps in the committed mobileAppContent of a
     * windowsUniversalAppX app.”</i>
     * 
     * @return navigational property committedContainedApps
     */
    @NavigationProperty(name="committedContainedApps")
    @JsonIgnore
    public MobileContainedAppCollectionRequest getCommittedContainedApps() {
        return new MobileContainedAppCollectionRequest(
                        contextPath.addSegment("committedContainedApps"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public WindowsUniversalAppX patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        WindowsUniversalAppX _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public WindowsUniversalAppX put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        WindowsUniversalAppX _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private WindowsUniversalAppX _copy() {
        WindowsUniversalAppX _x = new WindowsUniversalAppX();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.displayName = displayName;
        _x.description = description;
        _x.publisher = publisher;
        _x.largeIcon = largeIcon;
        _x.createdDateTime = createdDateTime;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        _x.isFeatured = isFeatured;
        _x.privacyInformationUrl = privacyInformationUrl;
        _x.informationUrl = informationUrl;
        _x.owner = owner;
        _x.developer = developer;
        _x.notes = notes;
        _x.uploadState = uploadState;
        _x.publishingState = publishingState;
        _x.isAssigned = isAssigned;
        _x.roleScopeTagIds = roleScopeTagIds;
        _x.dependentAppCount = dependentAppCount;
        _x.committedContentVersion = committedContentVersion;
        _x.fileName = fileName;
        _x.size = size;
        _x.applicableArchitectures = applicableArchitectures;
        _x.applicableDeviceTypes = applicableDeviceTypes;
        _x.identityName = identityName;
        _x.identityPublisherHash = identityPublisherHash;
        _x.identityResourceIdentifier = identityResourceIdentifier;
        _x.isBundle = isBundle;
        _x.minimumSupportedOperatingSystem = minimumSupportedOperatingSystem;
        _x.identityVersion = identityVersion;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("WindowsUniversalAppX[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("publisher=");
        b.append(this.publisher);
        b.append(", ");
        b.append("largeIcon=");
        b.append(this.largeIcon);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append(", ");
        b.append("isFeatured=");
        b.append(this.isFeatured);
        b.append(", ");
        b.append("privacyInformationUrl=");
        b.append(this.privacyInformationUrl);
        b.append(", ");
        b.append("informationUrl=");
        b.append(this.informationUrl);
        b.append(", ");
        b.append("owner=");
        b.append(this.owner);
        b.append(", ");
        b.append("developer=");
        b.append(this.developer);
        b.append(", ");
        b.append("notes=");
        b.append(this.notes);
        b.append(", ");
        b.append("uploadState=");
        b.append(this.uploadState);
        b.append(", ");
        b.append("publishingState=");
        b.append(this.publishingState);
        b.append(", ");
        b.append("isAssigned=");
        b.append(this.isAssigned);
        b.append(", ");
        b.append("roleScopeTagIds=");
        b.append(this.roleScopeTagIds);
        b.append(", ");
        b.append("dependentAppCount=");
        b.append(this.dependentAppCount);
        b.append(", ");
        b.append("committedContentVersion=");
        b.append(this.committedContentVersion);
        b.append(", ");
        b.append("fileName=");
        b.append(this.fileName);
        b.append(", ");
        b.append("size=");
        b.append(this.size);
        b.append(", ");
        b.append("applicableArchitectures=");
        b.append(this.applicableArchitectures);
        b.append(", ");
        b.append("applicableDeviceTypes=");
        b.append(this.applicableDeviceTypes);
        b.append(", ");
        b.append("identityName=");
        b.append(this.identityName);
        b.append(", ");
        b.append("identityPublisherHash=");
        b.append(this.identityPublisherHash);
        b.append(", ");
        b.append("identityResourceIdentifier=");
        b.append(this.identityResourceIdentifier);
        b.append(", ");
        b.append("isBundle=");
        b.append(this.isBundle);
        b.append(", ");
        b.append("minimumSupportedOperatingSystem=");
        b.append(this.minimumSupportedOperatingSystem);
        b.append(", ");
        b.append("identityVersion=");
        b.append(this.identityVersion);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
