package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.EdmSchemaInfo;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.complex.DeviceManagementApplicabilityRuleDeviceMode;
import odata.msgraph.client.beta.complex.DeviceManagementApplicabilityRuleOsEdition;
import odata.msgraph.client.beta.complex.DeviceManagementApplicabilityRuleOsVersion;
import odata.msgraph.client.beta.complex.VpnServer;
import odata.msgraph.client.beta.complex.Windows81VpnProxyServer;
import odata.msgraph.client.beta.entity.request.WindowsPhone81CertificateProfileBaseRequest;
import odata.msgraph.client.beta.enums.VpnAuthenticationMethod;
import odata.msgraph.client.beta.enums.WindowsVpnConnectionType;


/**
 * <i>“By providing the configurations in this profile you can instruct the Windows
 * Phone 8.1 to connect to desired VPN endpoint. By specifying the authentication
 * method and security types expected by VPN endpoint you can make the VPN
 * connection seamless for end user.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "bypassVpnOnCompanyWifi", 
    "bypassVpnOnHomeWifi", 
    "authenticationMethod", 
    "rememberUserCredentials", 
    "dnsSuffixSearchList"})
@JsonInclude(Include.NON_NULL)
public class WindowsPhone81VpnConfiguration extends Windows81VpnConfiguration implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.windowsPhone81VpnConfiguration";
    }

    @JsonProperty("bypassVpnOnCompanyWifi")
    protected Boolean bypassVpnOnCompanyWifi;

    @JsonProperty("bypassVpnOnHomeWifi")
    protected Boolean bypassVpnOnHomeWifi;

    @JsonProperty("authenticationMethod")
    protected VpnAuthenticationMethod authenticationMethod;

    @JsonProperty("rememberUserCredentials")
    protected Boolean rememberUserCredentials;

    @JsonProperty("dnsSuffixSearchList")
    protected List<String> dnsSuffixSearchList;

    @JsonProperty("dnsSuffixSearchList@nextLink")
    protected String dnsSuffixSearchListNextLink;

    protected WindowsPhone81VpnConfiguration() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderWindowsPhone81VpnConfiguration() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private OffsetDateTime lastModifiedDateTime;
        private List<String> roleScopeTagIds;
        private String roleScopeTagIdsNextLink;
        private Boolean supportsScopeTags;
        private DeviceManagementApplicabilityRuleOsEdition deviceManagementApplicabilityRuleOsEdition;
        private DeviceManagementApplicabilityRuleOsVersion deviceManagementApplicabilityRuleOsVersion;
        private DeviceManagementApplicabilityRuleDeviceMode deviceManagementApplicabilityRuleDeviceMode;
        private OffsetDateTime createdDateTime;
        private String description;
        private String displayName;
        private Integer version;
        private String connectionName;
        private List<VpnServer> servers;
        private String serversNextLink;
        private byte[] customXml;
        private Boolean applyOnlyToWindows81;
        private WindowsVpnConnectionType connectionType;
        private String loginGroupOrDomain;
        private Boolean enableSplitTunneling;
        private Windows81VpnProxyServer proxyServer;
        private Boolean bypassVpnOnCompanyWifi;
        private Boolean bypassVpnOnHomeWifi;
        private VpnAuthenticationMethod authenticationMethod;
        private Boolean rememberUserCredentials;
        private List<String> dnsSuffixSearchList;
        private String dnsSuffixSearchListNextLink;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder lastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
            this.lastModifiedDateTime = lastModifiedDateTime;
            this.changedFields = changedFields.add("lastModifiedDateTime");
            return this;
        }

        public Builder roleScopeTagIds(List<String> roleScopeTagIds) {
            this.roleScopeTagIds = roleScopeTagIds;
            this.changedFields = changedFields.add("roleScopeTagIds");
            return this;
        }

        public Builder roleScopeTagIds(String... roleScopeTagIds) {
            return roleScopeTagIds(Arrays.asList(roleScopeTagIds));
        }

        public Builder roleScopeTagIdsNextLink(String roleScopeTagIdsNextLink) {
            this.roleScopeTagIdsNextLink = roleScopeTagIdsNextLink;
            this.changedFields = changedFields.add("roleScopeTagIds");
            return this;
        }

        public Builder supportsScopeTags(Boolean supportsScopeTags) {
            this.supportsScopeTags = supportsScopeTags;
            this.changedFields = changedFields.add("supportsScopeTags");
            return this;
        }

        public Builder deviceManagementApplicabilityRuleOsEdition(DeviceManagementApplicabilityRuleOsEdition deviceManagementApplicabilityRuleOsEdition) {
            this.deviceManagementApplicabilityRuleOsEdition = deviceManagementApplicabilityRuleOsEdition;
            this.changedFields = changedFields.add("deviceManagementApplicabilityRuleOsEdition");
            return this;
        }

        public Builder deviceManagementApplicabilityRuleOsVersion(DeviceManagementApplicabilityRuleOsVersion deviceManagementApplicabilityRuleOsVersion) {
            this.deviceManagementApplicabilityRuleOsVersion = deviceManagementApplicabilityRuleOsVersion;
            this.changedFields = changedFields.add("deviceManagementApplicabilityRuleOsVersion");
            return this;
        }

        public Builder deviceManagementApplicabilityRuleDeviceMode(DeviceManagementApplicabilityRuleDeviceMode deviceManagementApplicabilityRuleDeviceMode) {
            this.deviceManagementApplicabilityRuleDeviceMode = deviceManagementApplicabilityRuleDeviceMode;
            this.changedFields = changedFields.add("deviceManagementApplicabilityRuleDeviceMode");
            return this;
        }

        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder version(Integer version) {
            this.version = version;
            this.changedFields = changedFields.add("version");
            return this;
        }

        public Builder connectionName(String connectionName) {
            this.connectionName = connectionName;
            this.changedFields = changedFields.add("connectionName");
            return this;
        }

        public Builder servers(List<VpnServer> servers) {
            this.servers = servers;
            this.changedFields = changedFields.add("servers");
            return this;
        }

        public Builder servers(VpnServer... servers) {
            return servers(Arrays.asList(servers));
        }

        public Builder serversNextLink(String serversNextLink) {
            this.serversNextLink = serversNextLink;
            this.changedFields = changedFields.add("servers");
            return this;
        }

        public Builder customXml(byte[] customXml) {
            this.customXml = customXml;
            this.changedFields = changedFields.add("customXml");
            return this;
        }

        public Builder applyOnlyToWindows81(Boolean applyOnlyToWindows81) {
            this.applyOnlyToWindows81 = applyOnlyToWindows81;
            this.changedFields = changedFields.add("applyOnlyToWindows81");
            return this;
        }

        public Builder connectionType(WindowsVpnConnectionType connectionType) {
            this.connectionType = connectionType;
            this.changedFields = changedFields.add("connectionType");
            return this;
        }

        public Builder loginGroupOrDomain(String loginGroupOrDomain) {
            this.loginGroupOrDomain = loginGroupOrDomain;
            this.changedFields = changedFields.add("loginGroupOrDomain");
            return this;
        }

        public Builder enableSplitTunneling(Boolean enableSplitTunneling) {
            this.enableSplitTunneling = enableSplitTunneling;
            this.changedFields = changedFields.add("enableSplitTunneling");
            return this;
        }

        public Builder proxyServer(Windows81VpnProxyServer proxyServer) {
            this.proxyServer = proxyServer;
            this.changedFields = changedFields.add("proxyServer");
            return this;
        }

        /**
         * <i>“Bypass VPN on company Wi-Fi.”</i>
         * 
         * @param bypassVpnOnCompanyWifi
         *            value of {@code bypassVpnOnCompanyWifi} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder bypassVpnOnCompanyWifi(Boolean bypassVpnOnCompanyWifi) {
            this.bypassVpnOnCompanyWifi = bypassVpnOnCompanyWifi;
            this.changedFields = changedFields.add("bypassVpnOnCompanyWifi");
            return this;
        }

        /**
         * <i>“Bypass VPN on home Wi-Fi.”</i>
         * 
         * @param bypassVpnOnHomeWifi
         *            value of {@code bypassVpnOnHomeWifi} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder bypassVpnOnHomeWifi(Boolean bypassVpnOnHomeWifi) {
            this.bypassVpnOnHomeWifi = bypassVpnOnHomeWifi;
            this.changedFields = changedFields.add("bypassVpnOnHomeWifi");
            return this;
        }

        /**
         * <i>“Authentication method.”</i>
         * 
         * @param authenticationMethod
         *            value of {@code authenticationMethod} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder authenticationMethod(VpnAuthenticationMethod authenticationMethod) {
            this.authenticationMethod = authenticationMethod;
            this.changedFields = changedFields.add("authenticationMethod");
            return this;
        }

        /**
         * <i>“Remember user credentials.”</i>
         * 
         * @param rememberUserCredentials
         *            value of {@code rememberUserCredentials} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder rememberUserCredentials(Boolean rememberUserCredentials) {
            this.rememberUserCredentials = rememberUserCredentials;
            this.changedFields = changedFields.add("rememberUserCredentials");
            return this;
        }

        /**
         * <i>“DNS suffix search list.”</i>
         * 
         * @param dnsSuffixSearchList
         *            value of {@code dnsSuffixSearchList} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder dnsSuffixSearchList(List<String> dnsSuffixSearchList) {
            this.dnsSuffixSearchList = dnsSuffixSearchList;
            this.changedFields = changedFields.add("dnsSuffixSearchList");
            return this;
        }

        /**
         * <i>“DNS suffix search list.”</i>
         * 
         * @param dnsSuffixSearchList
         *            value of {@code dnsSuffixSearchList} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder dnsSuffixSearchList(String... dnsSuffixSearchList) {
            return dnsSuffixSearchList(Arrays.asList(dnsSuffixSearchList));
        }

        /**
         * <i>“DNS suffix search list.”</i>
         * 
         * @param dnsSuffixSearchListNextLink
         *            value of {@code dnsSuffixSearchList@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder dnsSuffixSearchListNextLink(String dnsSuffixSearchListNextLink) {
            this.dnsSuffixSearchListNextLink = dnsSuffixSearchListNextLink;
            this.changedFields = changedFields.add("dnsSuffixSearchList");
            return this;
        }

        public WindowsPhone81VpnConfiguration build() {
            WindowsPhone81VpnConfiguration _x = new WindowsPhone81VpnConfiguration();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.windowsPhone81VpnConfiguration";
            _x.id = id;
            _x.lastModifiedDateTime = lastModifiedDateTime;
            _x.roleScopeTagIds = roleScopeTagIds;
            _x.roleScopeTagIdsNextLink = roleScopeTagIdsNextLink;
            _x.supportsScopeTags = supportsScopeTags;
            _x.deviceManagementApplicabilityRuleOsEdition = deviceManagementApplicabilityRuleOsEdition;
            _x.deviceManagementApplicabilityRuleOsVersion = deviceManagementApplicabilityRuleOsVersion;
            _x.deviceManagementApplicabilityRuleDeviceMode = deviceManagementApplicabilityRuleDeviceMode;
            _x.createdDateTime = createdDateTime;
            _x.description = description;
            _x.displayName = displayName;
            _x.version = version;
            _x.connectionName = connectionName;
            _x.servers = servers;
            _x.serversNextLink = serversNextLink;
            _x.customXml = customXml;
            _x.applyOnlyToWindows81 = applyOnlyToWindows81;
            _x.connectionType = connectionType;
            _x.loginGroupOrDomain = loginGroupOrDomain;
            _x.enableSplitTunneling = enableSplitTunneling;
            _x.proxyServer = proxyServer;
            _x.bypassVpnOnCompanyWifi = bypassVpnOnCompanyWifi;
            _x.bypassVpnOnHomeWifi = bypassVpnOnHomeWifi;
            _x.authenticationMethod = authenticationMethod;
            _x.rememberUserCredentials = rememberUserCredentials;
            _x.dnsSuffixSearchList = dnsSuffixSearchList;
            _x.dnsSuffixSearchListNextLink = dnsSuffixSearchListNextLink;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    /**
     * <i>“Bypass VPN on company Wi-Fi.”</i>
     * 
     * @return property bypassVpnOnCompanyWifi
     */
    @Property(name="bypassVpnOnCompanyWifi")
    @JsonIgnore
    public Optional<Boolean> getBypassVpnOnCompanyWifi() {
        return Optional.ofNullable(bypassVpnOnCompanyWifi);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * bypassVpnOnCompanyWifi} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Bypass VPN on company Wi-Fi.”</i>
     * 
     * @param bypassVpnOnCompanyWifi
     *            new value of {@code bypassVpnOnCompanyWifi} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code bypassVpnOnCompanyWifi} field changed
     */
    public WindowsPhone81VpnConfiguration withBypassVpnOnCompanyWifi(Boolean bypassVpnOnCompanyWifi) {
        WindowsPhone81VpnConfiguration _x = _copy();
        _x.changedFields = changedFields.add("bypassVpnOnCompanyWifi");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsPhone81VpnConfiguration");
        _x.bypassVpnOnCompanyWifi = bypassVpnOnCompanyWifi;
        return _x;
    }

    /**
     * <i>“Bypass VPN on home Wi-Fi.”</i>
     * 
     * @return property bypassVpnOnHomeWifi
     */
    @Property(name="bypassVpnOnHomeWifi")
    @JsonIgnore
    public Optional<Boolean> getBypassVpnOnHomeWifi() {
        return Optional.ofNullable(bypassVpnOnHomeWifi);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * bypassVpnOnHomeWifi} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Bypass VPN on home Wi-Fi.”</i>
     * 
     * @param bypassVpnOnHomeWifi
     *            new value of {@code bypassVpnOnHomeWifi} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code bypassVpnOnHomeWifi} field changed
     */
    public WindowsPhone81VpnConfiguration withBypassVpnOnHomeWifi(Boolean bypassVpnOnHomeWifi) {
        WindowsPhone81VpnConfiguration _x = _copy();
        _x.changedFields = changedFields.add("bypassVpnOnHomeWifi");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsPhone81VpnConfiguration");
        _x.bypassVpnOnHomeWifi = bypassVpnOnHomeWifi;
        return _x;
    }

    /**
     * <i>“Authentication method.”</i>
     * 
     * @return property authenticationMethod
     */
    @Property(name="authenticationMethod")
    @JsonIgnore
    public Optional<VpnAuthenticationMethod> getAuthenticationMethod() {
        return Optional.ofNullable(authenticationMethod);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * authenticationMethod} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Authentication method.”</i>
     * 
     * @param authenticationMethod
     *            new value of {@code authenticationMethod} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code authenticationMethod} field changed
     */
    public WindowsPhone81VpnConfiguration withAuthenticationMethod(VpnAuthenticationMethod authenticationMethod) {
        WindowsPhone81VpnConfiguration _x = _copy();
        _x.changedFields = changedFields.add("authenticationMethod");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsPhone81VpnConfiguration");
        _x.authenticationMethod = authenticationMethod;
        return _x;
    }

    /**
     * <i>“Remember user credentials.”</i>
     * 
     * @return property rememberUserCredentials
     */
    @Property(name="rememberUserCredentials")
    @JsonIgnore
    public Optional<Boolean> getRememberUserCredentials() {
        return Optional.ofNullable(rememberUserCredentials);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * rememberUserCredentials} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Remember user credentials.”</i>
     * 
     * @param rememberUserCredentials
     *            new value of {@code rememberUserCredentials} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code rememberUserCredentials} field changed
     */
    public WindowsPhone81VpnConfiguration withRememberUserCredentials(Boolean rememberUserCredentials) {
        WindowsPhone81VpnConfiguration _x = _copy();
        _x.changedFields = changedFields.add("rememberUserCredentials");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsPhone81VpnConfiguration");
        _x.rememberUserCredentials = rememberUserCredentials;
        return _x;
    }

    /**
     * <i>“DNS suffix search list.”</i>
     * 
     * @return property dnsSuffixSearchList
     */
    @Property(name="dnsSuffixSearchList")
    @JsonIgnore
    public CollectionPage<String> getDnsSuffixSearchList() {
        return new CollectionPage<String>(contextPath, String.class, dnsSuffixSearchList, Optional.ofNullable(dnsSuffixSearchListNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * <i>“DNS suffix search list.”</i>
     * 
     * @return property dnsSuffixSearchList
     */
    @Property(name="dnsSuffixSearchList")
    @JsonIgnore
    public CollectionPage<String> getDnsSuffixSearchList(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, dnsSuffixSearchList, Optional.ofNullable(dnsSuffixSearchListNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    /**
     * <i>“Identity certificate for client authentication when authentication method is
     * certificate.”</i>
     * 
     * @return navigational property identityCertificate
     */
    @NavigationProperty(name="identityCertificate")
    @JsonIgnore
    public WindowsPhone81CertificateProfileBaseRequest getIdentityCertificate() {
        return new WindowsPhone81CertificateProfileBaseRequest(contextPath.addSegment("identityCertificate"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public WindowsPhone81VpnConfiguration patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        WindowsPhone81VpnConfiguration _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public WindowsPhone81VpnConfiguration put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        WindowsPhone81VpnConfiguration _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private WindowsPhone81VpnConfiguration _copy() {
        WindowsPhone81VpnConfiguration _x = new WindowsPhone81VpnConfiguration();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        _x.roleScopeTagIds = roleScopeTagIds;
        _x.supportsScopeTags = supportsScopeTags;
        _x.deviceManagementApplicabilityRuleOsEdition = deviceManagementApplicabilityRuleOsEdition;
        _x.deviceManagementApplicabilityRuleOsVersion = deviceManagementApplicabilityRuleOsVersion;
        _x.deviceManagementApplicabilityRuleDeviceMode = deviceManagementApplicabilityRuleDeviceMode;
        _x.createdDateTime = createdDateTime;
        _x.description = description;
        _x.displayName = displayName;
        _x.version = version;
        _x.connectionName = connectionName;
        _x.servers = servers;
        _x.customXml = customXml;
        _x.applyOnlyToWindows81 = applyOnlyToWindows81;
        _x.connectionType = connectionType;
        _x.loginGroupOrDomain = loginGroupOrDomain;
        _x.enableSplitTunneling = enableSplitTunneling;
        _x.proxyServer = proxyServer;
        _x.bypassVpnOnCompanyWifi = bypassVpnOnCompanyWifi;
        _x.bypassVpnOnHomeWifi = bypassVpnOnHomeWifi;
        _x.authenticationMethod = authenticationMethod;
        _x.rememberUserCredentials = rememberUserCredentials;
        _x.dnsSuffixSearchList = dnsSuffixSearchList;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("WindowsPhone81VpnConfiguration[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append(", ");
        b.append("roleScopeTagIds=");
        b.append(this.roleScopeTagIds);
        b.append(", ");
        b.append("supportsScopeTags=");
        b.append(this.supportsScopeTags);
        b.append(", ");
        b.append("deviceManagementApplicabilityRuleOsEdition=");
        b.append(this.deviceManagementApplicabilityRuleOsEdition);
        b.append(", ");
        b.append("deviceManagementApplicabilityRuleOsVersion=");
        b.append(this.deviceManagementApplicabilityRuleOsVersion);
        b.append(", ");
        b.append("deviceManagementApplicabilityRuleDeviceMode=");
        b.append(this.deviceManagementApplicabilityRuleDeviceMode);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("version=");
        b.append(this.version);
        b.append(", ");
        b.append("connectionName=");
        b.append(this.connectionName);
        b.append(", ");
        b.append("servers=");
        b.append(this.servers);
        b.append(", ");
        b.append("customXml=");
        b.append(this.customXml);
        b.append(", ");
        b.append("applyOnlyToWindows81=");
        b.append(this.applyOnlyToWindows81);
        b.append(", ");
        b.append("connectionType=");
        b.append(this.connectionType);
        b.append(", ");
        b.append("loginGroupOrDomain=");
        b.append(this.loginGroupOrDomain);
        b.append(", ");
        b.append("enableSplitTunneling=");
        b.append(this.enableSplitTunneling);
        b.append(", ");
        b.append("proxyServer=");
        b.append(this.proxyServer);
        b.append(", ");
        b.append("bypassVpnOnCompanyWifi=");
        b.append(this.bypassVpnOnCompanyWifi);
        b.append(", ");
        b.append("bypassVpnOnHomeWifi=");
        b.append(this.bypassVpnOnHomeWifi);
        b.append(", ");
        b.append("authenticationMethod=");
        b.append(this.authenticationMethod);
        b.append(", ");
        b.append("rememberUserCredentials=");
        b.append(this.rememberUserCredentials);
        b.append(", ");
        b.append("dnsSuffixSearchList=");
        b.append(this.dnsSuffixSearchList);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
