package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.complex.MimeContent;
import odata.msgraph.client.beta.complex.WindowsMinimumOperatingSystem;
import odata.msgraph.client.beta.complex.WindowsPackageInformation;
import odata.msgraph.client.beta.enums.MobileAppPublishingState;
import odata.msgraph.client.beta.enums.WindowsArchitecture;
import odata.msgraph.client.beta.schema.SchemaInfo;


/**
 * <i>“Contains properties and inherited properties for Windows Phone 8.1 AppX Bundle
 * Line Of Business apps.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "appXPackageInformationList"})
@JsonInclude(Include.NON_NULL)
public class WindowsPhone81AppXBundle extends WindowsPhone81AppX implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.windowsPhone81AppXBundle";
    }

    @JsonProperty("appXPackageInformationList")
    protected List<WindowsPackageInformation> appXPackageInformationList;

    @JsonProperty("appXPackageInformationList@nextLink")
    protected String appXPackageInformationListNextLink;

    protected WindowsPhone81AppXBundle() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderWindowsPhone81AppXBundle() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String displayName;
        private String description;
        private String publisher;
        private MimeContent largeIcon;
        private OffsetDateTime createdDateTime;
        private OffsetDateTime lastModifiedDateTime;
        private Boolean isFeatured;
        private String privacyInformationUrl;
        private String informationUrl;
        private String owner;
        private String developer;
        private String notes;
        private Integer uploadState;
        private MobileAppPublishingState publishingState;
        private Boolean isAssigned;
        private List<String> roleScopeTagIds;
        private String roleScopeTagIdsNextLink;
        private Integer dependentAppCount;
        private String committedContentVersion;
        private String fileName;
        private Long size;
        private WindowsArchitecture applicableArchitectures;
        private String identityName;
        private String identityPublisherHash;
        private String identityResourceIdentifier;
        private WindowsMinimumOperatingSystem minimumSupportedOperatingSystem;
        private String phoneProductIdentifier;
        private String phonePublisherId;
        private String identityVersion;
        private List<WindowsPackageInformation> appXPackageInformationList;
        private String appXPackageInformationListNextLink;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder publisher(String publisher) {
            this.publisher = publisher;
            this.changedFields = changedFields.add("publisher");
            return this;
        }

        public Builder largeIcon(MimeContent largeIcon) {
            this.largeIcon = largeIcon;
            this.changedFields = changedFields.add("largeIcon");
            return this;
        }

        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        public Builder lastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
            this.lastModifiedDateTime = lastModifiedDateTime;
            this.changedFields = changedFields.add("lastModifiedDateTime");
            return this;
        }

        public Builder isFeatured(Boolean isFeatured) {
            this.isFeatured = isFeatured;
            this.changedFields = changedFields.add("isFeatured");
            return this;
        }

        public Builder privacyInformationUrl(String privacyInformationUrl) {
            this.privacyInformationUrl = privacyInformationUrl;
            this.changedFields = changedFields.add("privacyInformationUrl");
            return this;
        }

        public Builder informationUrl(String informationUrl) {
            this.informationUrl = informationUrl;
            this.changedFields = changedFields.add("informationUrl");
            return this;
        }

        public Builder owner(String owner) {
            this.owner = owner;
            this.changedFields = changedFields.add("owner");
            return this;
        }

        public Builder developer(String developer) {
            this.developer = developer;
            this.changedFields = changedFields.add("developer");
            return this;
        }

        public Builder notes(String notes) {
            this.notes = notes;
            this.changedFields = changedFields.add("notes");
            return this;
        }

        public Builder uploadState(Integer uploadState) {
            this.uploadState = uploadState;
            this.changedFields = changedFields.add("uploadState");
            return this;
        }

        public Builder publishingState(MobileAppPublishingState publishingState) {
            this.publishingState = publishingState;
            this.changedFields = changedFields.add("publishingState");
            return this;
        }

        public Builder isAssigned(Boolean isAssigned) {
            this.isAssigned = isAssigned;
            this.changedFields = changedFields.add("isAssigned");
            return this;
        }

        public Builder roleScopeTagIds(List<String> roleScopeTagIds) {
            this.roleScopeTagIds = roleScopeTagIds;
            this.changedFields = changedFields.add("roleScopeTagIds");
            return this;
        }

        public Builder roleScopeTagIds(String... roleScopeTagIds) {
            return roleScopeTagIds(Arrays.asList(roleScopeTagIds));
        }

        public Builder roleScopeTagIdsNextLink(String roleScopeTagIdsNextLink) {
            this.roleScopeTagIdsNextLink = roleScopeTagIdsNextLink;
            this.changedFields = changedFields.add("roleScopeTagIds");
            return this;
        }

        public Builder dependentAppCount(Integer dependentAppCount) {
            this.dependentAppCount = dependentAppCount;
            this.changedFields = changedFields.add("dependentAppCount");
            return this;
        }

        public Builder committedContentVersion(String committedContentVersion) {
            this.committedContentVersion = committedContentVersion;
            this.changedFields = changedFields.add("committedContentVersion");
            return this;
        }

        public Builder fileName(String fileName) {
            this.fileName = fileName;
            this.changedFields = changedFields.add("fileName");
            return this;
        }

        public Builder size(Long size) {
            this.size = size;
            this.changedFields = changedFields.add("size");
            return this;
        }

        public Builder applicableArchitectures(WindowsArchitecture applicableArchitectures) {
            this.applicableArchitectures = applicableArchitectures;
            this.changedFields = changedFields.add("applicableArchitectures");
            return this;
        }

        public Builder identityName(String identityName) {
            this.identityName = identityName;
            this.changedFields = changedFields.add("identityName");
            return this;
        }

        public Builder identityPublisherHash(String identityPublisherHash) {
            this.identityPublisherHash = identityPublisherHash;
            this.changedFields = changedFields.add("identityPublisherHash");
            return this;
        }

        public Builder identityResourceIdentifier(String identityResourceIdentifier) {
            this.identityResourceIdentifier = identityResourceIdentifier;
            this.changedFields = changedFields.add("identityResourceIdentifier");
            return this;
        }

        public Builder minimumSupportedOperatingSystem(WindowsMinimumOperatingSystem minimumSupportedOperatingSystem) {
            this.minimumSupportedOperatingSystem = minimumSupportedOperatingSystem;
            this.changedFields = changedFields.add("minimumSupportedOperatingSystem");
            return this;
        }

        public Builder phoneProductIdentifier(String phoneProductIdentifier) {
            this.phoneProductIdentifier = phoneProductIdentifier;
            this.changedFields = changedFields.add("phoneProductIdentifier");
            return this;
        }

        public Builder phonePublisherId(String phonePublisherId) {
            this.phonePublisherId = phonePublisherId;
            this.changedFields = changedFields.add("phonePublisherId");
            return this;
        }

        public Builder identityVersion(String identityVersion) {
            this.identityVersion = identityVersion;
            this.changedFields = changedFields.add("identityVersion");
            return this;
        }

        /**
         * <i>“The list of AppX Package Information.”</i>
         * 
         * @param appXPackageInformationList
         *            value of {@code appXPackageInformationList} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder appXPackageInformationList(List<WindowsPackageInformation> appXPackageInformationList) {
            this.appXPackageInformationList = appXPackageInformationList;
            this.changedFields = changedFields.add("appXPackageInformationList");
            return this;
        }

        /**
         * <i>“The list of AppX Package Information.”</i>
         * 
         * @param appXPackageInformationList
         *            value of {@code appXPackageInformationList} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder appXPackageInformationList(WindowsPackageInformation... appXPackageInformationList) {
            return appXPackageInformationList(Arrays.asList(appXPackageInformationList));
        }

        /**
         * <i>“The list of AppX Package Information.”</i>
         * 
         * @param appXPackageInformationListNextLink
         *            value of {@code appXPackageInformationList@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder appXPackageInformationListNextLink(String appXPackageInformationListNextLink) {
            this.appXPackageInformationListNextLink = appXPackageInformationListNextLink;
            this.changedFields = changedFields.add("appXPackageInformationList");
            return this;
        }

        public WindowsPhone81AppXBundle build() {
            WindowsPhone81AppXBundle _x = new WindowsPhone81AppXBundle();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.windowsPhone81AppXBundle";
            _x.id = id;
            _x.displayName = displayName;
            _x.description = description;
            _x.publisher = publisher;
            _x.largeIcon = largeIcon;
            _x.createdDateTime = createdDateTime;
            _x.lastModifiedDateTime = lastModifiedDateTime;
            _x.isFeatured = isFeatured;
            _x.privacyInformationUrl = privacyInformationUrl;
            _x.informationUrl = informationUrl;
            _x.owner = owner;
            _x.developer = developer;
            _x.notes = notes;
            _x.uploadState = uploadState;
            _x.publishingState = publishingState;
            _x.isAssigned = isAssigned;
            _x.roleScopeTagIds = roleScopeTagIds;
            _x.roleScopeTagIdsNextLink = roleScopeTagIdsNextLink;
            _x.dependentAppCount = dependentAppCount;
            _x.committedContentVersion = committedContentVersion;
            _x.fileName = fileName;
            _x.size = size;
            _x.applicableArchitectures = applicableArchitectures;
            _x.identityName = identityName;
            _x.identityPublisherHash = identityPublisherHash;
            _x.identityResourceIdentifier = identityResourceIdentifier;
            _x.minimumSupportedOperatingSystem = minimumSupportedOperatingSystem;
            _x.phoneProductIdentifier = phoneProductIdentifier;
            _x.phonePublisherId = phonePublisherId;
            _x.identityVersion = identityVersion;
            _x.appXPackageInformationList = appXPackageInformationList;
            _x.appXPackageInformationListNextLink = appXPackageInformationListNextLink;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    /**
     * <i>“The list of AppX Package Information.”</i>
     * 
     * @return property appXPackageInformationList
     */
    @Property(name="appXPackageInformationList")
    @JsonIgnore
    public CollectionPage<WindowsPackageInformation> getAppXPackageInformationList() {
        return new CollectionPage<WindowsPackageInformation>(contextPath, WindowsPackageInformation.class, appXPackageInformationList, Optional.ofNullable(appXPackageInformationListNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * <i>“The list of AppX Package Information.”</i>
     * 
     * @return property appXPackageInformationList
     */
    @Property(name="appXPackageInformationList")
    @JsonIgnore
    public CollectionPage<WindowsPackageInformation> getAppXPackageInformationList(HttpRequestOptions options) {
        return new CollectionPage<WindowsPackageInformation>(contextPath, WindowsPackageInformation.class, appXPackageInformationList, Optional.ofNullable(appXPackageInformationListNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public WindowsPhone81AppXBundle patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        WindowsPhone81AppXBundle _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public WindowsPhone81AppXBundle put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        WindowsPhone81AppXBundle _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private WindowsPhone81AppXBundle _copy() {
        WindowsPhone81AppXBundle _x = new WindowsPhone81AppXBundle();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.displayName = displayName;
        _x.description = description;
        _x.publisher = publisher;
        _x.largeIcon = largeIcon;
        _x.createdDateTime = createdDateTime;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        _x.isFeatured = isFeatured;
        _x.privacyInformationUrl = privacyInformationUrl;
        _x.informationUrl = informationUrl;
        _x.owner = owner;
        _x.developer = developer;
        _x.notes = notes;
        _x.uploadState = uploadState;
        _x.publishingState = publishingState;
        _x.isAssigned = isAssigned;
        _x.roleScopeTagIds = roleScopeTagIds;
        _x.dependentAppCount = dependentAppCount;
        _x.committedContentVersion = committedContentVersion;
        _x.fileName = fileName;
        _x.size = size;
        _x.applicableArchitectures = applicableArchitectures;
        _x.identityName = identityName;
        _x.identityPublisherHash = identityPublisherHash;
        _x.identityResourceIdentifier = identityResourceIdentifier;
        _x.minimumSupportedOperatingSystem = minimumSupportedOperatingSystem;
        _x.phoneProductIdentifier = phoneProductIdentifier;
        _x.phonePublisherId = phonePublisherId;
        _x.identityVersion = identityVersion;
        _x.appXPackageInformationList = appXPackageInformationList;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("WindowsPhone81AppXBundle[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("publisher=");
        b.append(this.publisher);
        b.append(", ");
        b.append("largeIcon=");
        b.append(this.largeIcon);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append(", ");
        b.append("isFeatured=");
        b.append(this.isFeatured);
        b.append(", ");
        b.append("privacyInformationUrl=");
        b.append(this.privacyInformationUrl);
        b.append(", ");
        b.append("informationUrl=");
        b.append(this.informationUrl);
        b.append(", ");
        b.append("owner=");
        b.append(this.owner);
        b.append(", ");
        b.append("developer=");
        b.append(this.developer);
        b.append(", ");
        b.append("notes=");
        b.append(this.notes);
        b.append(", ");
        b.append("uploadState=");
        b.append(this.uploadState);
        b.append(", ");
        b.append("publishingState=");
        b.append(this.publishingState);
        b.append(", ");
        b.append("isAssigned=");
        b.append(this.isAssigned);
        b.append(", ");
        b.append("roleScopeTagIds=");
        b.append(this.roleScopeTagIds);
        b.append(", ");
        b.append("dependentAppCount=");
        b.append(this.dependentAppCount);
        b.append(", ");
        b.append("committedContentVersion=");
        b.append(this.committedContentVersion);
        b.append(", ");
        b.append("fileName=");
        b.append(this.fileName);
        b.append(", ");
        b.append("size=");
        b.append(this.size);
        b.append(", ");
        b.append("applicableArchitectures=");
        b.append(this.applicableArchitectures);
        b.append(", ");
        b.append("identityName=");
        b.append(this.identityName);
        b.append(", ");
        b.append("identityPublisherHash=");
        b.append(this.identityPublisherHash);
        b.append(", ");
        b.append("identityResourceIdentifier=");
        b.append(this.identityResourceIdentifier);
        b.append(", ");
        b.append("minimumSupportedOperatingSystem=");
        b.append(this.minimumSupportedOperatingSystem);
        b.append(", ");
        b.append("phoneProductIdentifier=");
        b.append(this.phoneProductIdentifier);
        b.append(", ");
        b.append("phonePublisherId=");
        b.append(this.phonePublisherId);
        b.append(", ");
        b.append("identityVersion=");
        b.append(this.identityVersion);
        b.append(", ");
        b.append("appXPackageInformationList=");
        b.append(this.appXPackageInformationList);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
