package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.complex.MimeContent;
import odata.msgraph.client.beta.enums.MobileAppPublishingState;


/**
 * <i>“Contains properties and inherited properties for Windows Mobile MSI Line Of
 * Business apps.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "commandLine", 
    "productCode", 
    "productVersion", 
    "ignoreVersionDetection", 
    "identityVersion", 
    "useDeviceContext"})
@JsonInclude(Include.NON_NULL)
public class WindowsMobileMSI extends MobileLobApp implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.windowsMobileMSI";
    }

    @JsonProperty("commandLine")
    protected String commandLine;

    @JsonProperty("productCode")
    protected String productCode;

    @JsonProperty("productVersion")
    protected String productVersion;

    @JsonProperty("ignoreVersionDetection")
    protected Boolean ignoreVersionDetection;

    @JsonProperty("identityVersion")
    protected String identityVersion;

    @JsonProperty("useDeviceContext")
    protected Boolean useDeviceContext;

    protected WindowsMobileMSI() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderWindowsMobileMSI() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String displayName;
        private String description;
        private String publisher;
        private MimeContent largeIcon;
        private OffsetDateTime createdDateTime;
        private OffsetDateTime lastModifiedDateTime;
        private Boolean isFeatured;
        private String privacyInformationUrl;
        private String informationUrl;
        private String owner;
        private String developer;
        private String notes;
        private Integer uploadState;
        private MobileAppPublishingState publishingState;
        private Boolean isAssigned;
        private List<String> roleScopeTagIds;
        private String roleScopeTagIdsNextLink;
        private Integer dependentAppCount;
        private String committedContentVersion;
        private String fileName;
        private Long size;
        private String commandLine;
        private String productCode;
        private String productVersion;
        private Boolean ignoreVersionDetection;
        private String identityVersion;
        private Boolean useDeviceContext;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder publisher(String publisher) {
            this.publisher = publisher;
            this.changedFields = changedFields.add("publisher");
            return this;
        }

        public Builder largeIcon(MimeContent largeIcon) {
            this.largeIcon = largeIcon;
            this.changedFields = changedFields.add("largeIcon");
            return this;
        }

        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        public Builder lastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
            this.lastModifiedDateTime = lastModifiedDateTime;
            this.changedFields = changedFields.add("lastModifiedDateTime");
            return this;
        }

        public Builder isFeatured(Boolean isFeatured) {
            this.isFeatured = isFeatured;
            this.changedFields = changedFields.add("isFeatured");
            return this;
        }

        public Builder privacyInformationUrl(String privacyInformationUrl) {
            this.privacyInformationUrl = privacyInformationUrl;
            this.changedFields = changedFields.add("privacyInformationUrl");
            return this;
        }

        public Builder informationUrl(String informationUrl) {
            this.informationUrl = informationUrl;
            this.changedFields = changedFields.add("informationUrl");
            return this;
        }

        public Builder owner(String owner) {
            this.owner = owner;
            this.changedFields = changedFields.add("owner");
            return this;
        }

        public Builder developer(String developer) {
            this.developer = developer;
            this.changedFields = changedFields.add("developer");
            return this;
        }

        public Builder notes(String notes) {
            this.notes = notes;
            this.changedFields = changedFields.add("notes");
            return this;
        }

        public Builder uploadState(Integer uploadState) {
            this.uploadState = uploadState;
            this.changedFields = changedFields.add("uploadState");
            return this;
        }

        public Builder publishingState(MobileAppPublishingState publishingState) {
            this.publishingState = publishingState;
            this.changedFields = changedFields.add("publishingState");
            return this;
        }

        public Builder isAssigned(Boolean isAssigned) {
            this.isAssigned = isAssigned;
            this.changedFields = changedFields.add("isAssigned");
            return this;
        }

        public Builder roleScopeTagIds(List<String> roleScopeTagIds) {
            this.roleScopeTagIds = roleScopeTagIds;
            this.changedFields = changedFields.add("roleScopeTagIds");
            return this;
        }

        public Builder roleScopeTagIds(String... roleScopeTagIds) {
            return roleScopeTagIds(Arrays.asList(roleScopeTagIds));
        }

        public Builder roleScopeTagIdsNextLink(String roleScopeTagIdsNextLink) {
            this.roleScopeTagIdsNextLink = roleScopeTagIdsNextLink;
            this.changedFields = changedFields.add("roleScopeTagIds");
            return this;
        }

        public Builder dependentAppCount(Integer dependentAppCount) {
            this.dependentAppCount = dependentAppCount;
            this.changedFields = changedFields.add("dependentAppCount");
            return this;
        }

        public Builder committedContentVersion(String committedContentVersion) {
            this.committedContentVersion = committedContentVersion;
            this.changedFields = changedFields.add("committedContentVersion");
            return this;
        }

        public Builder fileName(String fileName) {
            this.fileName = fileName;
            this.changedFields = changedFields.add("fileName");
            return this;
        }

        public Builder size(Long size) {
            this.size = size;
            this.changedFields = changedFields.add("size");
            return this;
        }

        /**
         * <i>“The command line.”</i>
         * 
         * @param commandLine
         *            value of {@code commandLine} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder commandLine(String commandLine) {
            this.commandLine = commandLine;
            this.changedFields = changedFields.add("commandLine");
            return this;
        }

        /**
         * <i>“The product code.”</i>
         * 
         * @param productCode
         *            value of {@code productCode} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder productCode(String productCode) {
            this.productCode = productCode;
            this.changedFields = changedFields.add("productCode");
            return this;
        }

        /**
         * <i>“The product version of Windows Mobile MSI Line of Business (LoB) app.”</i>
         * 
         * @param productVersion
         *            value of {@code productVersion} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder productVersion(String productVersion) {
            this.productVersion = productVersion;
            this.changedFields = changedFields.add("productVersion");
            return this;
        }

        /**
         * <i>“A boolean to control whether the app's version will be used to detect the app
         * after it is installed on a device. Set this to true for Windows Mobile MSI Line
         * of Business (LoB) apps that use a self update feature.”</i>
         * 
         * @param ignoreVersionDetection
         *            value of {@code ignoreVersionDetection} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder ignoreVersionDetection(Boolean ignoreVersionDetection) {
            this.ignoreVersionDetection = ignoreVersionDetection;
            this.changedFields = changedFields.add("ignoreVersionDetection");
            return this;
        }

        /**
         * <i>“The identity version.”</i>
         * 
         * @param identityVersion
         *            value of {@code identityVersion} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder identityVersion(String identityVersion) {
            this.identityVersion = identityVersion;
            this.changedFields = changedFields.add("identityVersion");
            return this;
        }

        /**
         * <i>“Indicates whether to install a dual-mode MSI in the device context. If true, app
         * will be installed for all users. If false, app will be installed per-user. If
         * null, service will use the MSI package's default install context. In case of
         * dual-mode MSI, this default will be per-user.  Cannot be set for non-dual-mode
         * apps.  Cannot be changed after initial creation of the application.”</i>
         * 
         * @param useDeviceContext
         *            value of {@code useDeviceContext} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder useDeviceContext(Boolean useDeviceContext) {
            this.useDeviceContext = useDeviceContext;
            this.changedFields = changedFields.add("useDeviceContext");
            return this;
        }

        public WindowsMobileMSI build() {
            WindowsMobileMSI _x = new WindowsMobileMSI();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.windowsMobileMSI";
            _x.id = id;
            _x.displayName = displayName;
            _x.description = description;
            _x.publisher = publisher;
            _x.largeIcon = largeIcon;
            _x.createdDateTime = createdDateTime;
            _x.lastModifiedDateTime = lastModifiedDateTime;
            _x.isFeatured = isFeatured;
            _x.privacyInformationUrl = privacyInformationUrl;
            _x.informationUrl = informationUrl;
            _x.owner = owner;
            _x.developer = developer;
            _x.notes = notes;
            _x.uploadState = uploadState;
            _x.publishingState = publishingState;
            _x.isAssigned = isAssigned;
            _x.roleScopeTagIds = roleScopeTagIds;
            _x.roleScopeTagIdsNextLink = roleScopeTagIdsNextLink;
            _x.dependentAppCount = dependentAppCount;
            _x.committedContentVersion = committedContentVersion;
            _x.fileName = fileName;
            _x.size = size;
            _x.commandLine = commandLine;
            _x.productCode = productCode;
            _x.productVersion = productVersion;
            _x.ignoreVersionDetection = ignoreVersionDetection;
            _x.identityVersion = identityVersion;
            _x.useDeviceContext = useDeviceContext;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    /**
     * <i>“The command line.”</i>
     * 
     * @return property commandLine
     */
    @Property(name="commandLine")
    @JsonIgnore
    public Optional<String> getCommandLine() {
        return Optional.ofNullable(commandLine);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code commandLine}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The command line.”</i>
     * 
     * @param commandLine
     *            new value of {@code commandLine} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code commandLine} field changed
     */
    public WindowsMobileMSI withCommandLine(String commandLine) {
        WindowsMobileMSI _x = _copy();
        _x.changedFields = changedFields.add("commandLine");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsMobileMSI");
        _x.commandLine = commandLine;
        return _x;
    }

    /**
     * <i>“The product code.”</i>
     * 
     * @return property productCode
     */
    @Property(name="productCode")
    @JsonIgnore
    public Optional<String> getProductCode() {
        return Optional.ofNullable(productCode);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code productCode}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The product code.”</i>
     * 
     * @param productCode
     *            new value of {@code productCode} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code productCode} field changed
     */
    public WindowsMobileMSI withProductCode(String productCode) {
        WindowsMobileMSI _x = _copy();
        _x.changedFields = changedFields.add("productCode");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsMobileMSI");
        _x.productCode = productCode;
        return _x;
    }

    /**
     * <i>“The product version of Windows Mobile MSI Line of Business (LoB) app.”</i>
     * 
     * @return property productVersion
     */
    @Property(name="productVersion")
    @JsonIgnore
    public Optional<String> getProductVersion() {
        return Optional.ofNullable(productVersion);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code productVersion}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The product version of Windows Mobile MSI Line of Business (LoB) app.”</i>
     * 
     * @param productVersion
     *            new value of {@code productVersion} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code productVersion} field changed
     */
    public WindowsMobileMSI withProductVersion(String productVersion) {
        WindowsMobileMSI _x = _copy();
        _x.changedFields = changedFields.add("productVersion");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsMobileMSI");
        _x.productVersion = productVersion;
        return _x;
    }

    /**
     * <i>“A boolean to control whether the app's version will be used to detect the app
     * after it is installed on a device. Set this to true for Windows Mobile MSI Line
     * of Business (LoB) apps that use a self update feature.”</i>
     * 
     * @return property ignoreVersionDetection
     */
    @Property(name="ignoreVersionDetection")
    @JsonIgnore
    public Optional<Boolean> getIgnoreVersionDetection() {
        return Optional.ofNullable(ignoreVersionDetection);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * ignoreVersionDetection} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“A boolean to control whether the app's version will be used to detect the app
     * after it is installed on a device. Set this to true for Windows Mobile MSI Line
     * of Business (LoB) apps that use a self update feature.”</i>
     * 
     * @param ignoreVersionDetection
     *            new value of {@code ignoreVersionDetection} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code ignoreVersionDetection} field changed
     */
    public WindowsMobileMSI withIgnoreVersionDetection(Boolean ignoreVersionDetection) {
        WindowsMobileMSI _x = _copy();
        _x.changedFields = changedFields.add("ignoreVersionDetection");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsMobileMSI");
        _x.ignoreVersionDetection = ignoreVersionDetection;
        return _x;
    }

    /**
     * <i>“The identity version.”</i>
     * 
     * @return property identityVersion
     */
    @Property(name="identityVersion")
    @JsonIgnore
    public Optional<String> getIdentityVersion() {
        return Optional.ofNullable(identityVersion);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code identityVersion}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The identity version.”</i>
     * 
     * @param identityVersion
     *            new value of {@code identityVersion} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code identityVersion} field changed
     */
    public WindowsMobileMSI withIdentityVersion(String identityVersion) {
        WindowsMobileMSI _x = _copy();
        _x.changedFields = changedFields.add("identityVersion");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsMobileMSI");
        _x.identityVersion = identityVersion;
        return _x;
    }

    /**
     * <i>“Indicates whether to install a dual-mode MSI in the device context. If true, app
     * will be installed for all users. If false, app will be installed per-user. If
     * null, service will use the MSI package's default install context. In case of
     * dual-mode MSI, this default will be per-user.  Cannot be set for non-dual-mode
     * apps.  Cannot be changed after initial creation of the application.”</i>
     * 
     * @return property useDeviceContext
     */
    @Property(name="useDeviceContext")
    @JsonIgnore
    public Optional<Boolean> getUseDeviceContext() {
        return Optional.ofNullable(useDeviceContext);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code useDeviceContext}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Indicates whether to install a dual-mode MSI in the device context. If true, app
     * will be installed for all users. If false, app will be installed per-user. If
     * null, service will use the MSI package's default install context. In case of
     * dual-mode MSI, this default will be per-user.  Cannot be set for non-dual-mode
     * apps.  Cannot be changed after initial creation of the application.”</i>
     * 
     * @param useDeviceContext
     *            new value of {@code useDeviceContext} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code useDeviceContext} field changed
     */
    public WindowsMobileMSI withUseDeviceContext(Boolean useDeviceContext) {
        WindowsMobileMSI _x = _copy();
        _x.changedFields = changedFields.add("useDeviceContext");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsMobileMSI");
        _x.useDeviceContext = useDeviceContext;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public WindowsMobileMSI patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        WindowsMobileMSI _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public WindowsMobileMSI put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        WindowsMobileMSI _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private WindowsMobileMSI _copy() {
        WindowsMobileMSI _x = new WindowsMobileMSI();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.displayName = displayName;
        _x.description = description;
        _x.publisher = publisher;
        _x.largeIcon = largeIcon;
        _x.createdDateTime = createdDateTime;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        _x.isFeatured = isFeatured;
        _x.privacyInformationUrl = privacyInformationUrl;
        _x.informationUrl = informationUrl;
        _x.owner = owner;
        _x.developer = developer;
        _x.notes = notes;
        _x.uploadState = uploadState;
        _x.publishingState = publishingState;
        _x.isAssigned = isAssigned;
        _x.roleScopeTagIds = roleScopeTagIds;
        _x.dependentAppCount = dependentAppCount;
        _x.committedContentVersion = committedContentVersion;
        _x.fileName = fileName;
        _x.size = size;
        _x.commandLine = commandLine;
        _x.productCode = productCode;
        _x.productVersion = productVersion;
        _x.ignoreVersionDetection = ignoreVersionDetection;
        _x.identityVersion = identityVersion;
        _x.useDeviceContext = useDeviceContext;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("WindowsMobileMSI[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("publisher=");
        b.append(this.publisher);
        b.append(", ");
        b.append("largeIcon=");
        b.append(this.largeIcon);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append(", ");
        b.append("isFeatured=");
        b.append(this.isFeatured);
        b.append(", ");
        b.append("privacyInformationUrl=");
        b.append(this.privacyInformationUrl);
        b.append(", ");
        b.append("informationUrl=");
        b.append(this.informationUrl);
        b.append(", ");
        b.append("owner=");
        b.append(this.owner);
        b.append(", ");
        b.append("developer=");
        b.append(this.developer);
        b.append(", ");
        b.append("notes=");
        b.append(this.notes);
        b.append(", ");
        b.append("uploadState=");
        b.append(this.uploadState);
        b.append(", ");
        b.append("publishingState=");
        b.append(this.publishingState);
        b.append(", ");
        b.append("isAssigned=");
        b.append(this.isAssigned);
        b.append(", ");
        b.append("roleScopeTagIds=");
        b.append(this.roleScopeTagIds);
        b.append(", ");
        b.append("dependentAppCount=");
        b.append(this.dependentAppCount);
        b.append(", ");
        b.append("committedContentVersion=");
        b.append(this.committedContentVersion);
        b.append(", ");
        b.append("fileName=");
        b.append(this.fileName);
        b.append(", ");
        b.append("size=");
        b.append(this.size);
        b.append(", ");
        b.append("commandLine=");
        b.append(this.commandLine);
        b.append(", ");
        b.append("productCode=");
        b.append(this.productCode);
        b.append(", ");
        b.append("productVersion=");
        b.append(this.productVersion);
        b.append(", ");
        b.append("ignoreVersionDetection=");
        b.append(this.ignoreVersionDetection);
        b.append(", ");
        b.append("identityVersion=");
        b.append(this.identityVersion);
        b.append(", ");
        b.append("useDeviceContext=");
        b.append(this.useDeviceContext);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
