package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.OffsetDateTime;
import java.util.Optional;

import odata.msgraph.client.beta.enums.HealthState;


/**
 * <i>“Windows management app health state entity.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "healthState", 
    "installedVersion", 
    "lastCheckInDateTime", 
    "deviceName", 
    "deviceOSVersion"})
@JsonInclude(Include.NON_NULL)
public class WindowsManagementAppHealthState extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.windowsManagementAppHealthState";
    }

    @JsonProperty("healthState")
    protected HealthState healthState;

    @JsonProperty("installedVersion")
    protected String installedVersion;

    @JsonProperty("lastCheckInDateTime")
    protected OffsetDateTime lastCheckInDateTime;

    @JsonProperty("deviceName")
    protected String deviceName;

    @JsonProperty("deviceOSVersion")
    protected String deviceOSVersion;

    protected WindowsManagementAppHealthState() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderWindowsManagementAppHealthState() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private HealthState healthState;
        private String installedVersion;
        private OffsetDateTime lastCheckInDateTime;
        private String deviceName;
        private String deviceOSVersion;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        /**
         * <i>“Windows management app health state.”</i>
         * 
         * @param healthState
         *            value of {@code healthState} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder healthState(HealthState healthState) {
            this.healthState = healthState;
            this.changedFields = changedFields.add("healthState");
            return this;
        }

        /**
         * <i>“Windows management app installed version.”</i>
         * 
         * @param installedVersion
         *            value of {@code installedVersion} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder installedVersion(String installedVersion) {
            this.installedVersion = installedVersion;
            this.changedFields = changedFields.add("installedVersion");
            return this;
        }

        /**
         * <i>“Windows management app last check-in time.”</i>
         * 
         * @param lastCheckInDateTime
         *            value of {@code lastCheckInDateTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder lastCheckInDateTime(OffsetDateTime lastCheckInDateTime) {
            this.lastCheckInDateTime = lastCheckInDateTime;
            this.changedFields = changedFields.add("lastCheckInDateTime");
            return this;
        }

        /**
         * <i>“Name of the device on which Windows management app is installed.”</i>
         * 
         * @param deviceName
         *            value of {@code deviceName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder deviceName(String deviceName) {
            this.deviceName = deviceName;
            this.changedFields = changedFields.add("deviceName");
            return this;
        }

        /**
         * <i>“Windows 10 OS version of the device on which Windows management app is installed
         * .”</i>
         * 
         * @param deviceOSVersion
         *            value of {@code deviceOSVersion} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder deviceOSVersion(String deviceOSVersion) {
            this.deviceOSVersion = deviceOSVersion;
            this.changedFields = changedFields.add("deviceOSVersion");
            return this;
        }

        public WindowsManagementAppHealthState build() {
            WindowsManagementAppHealthState _x = new WindowsManagementAppHealthState();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.windowsManagementAppHealthState";
            _x.id = id;
            _x.healthState = healthState;
            _x.installedVersion = installedVersion;
            _x.lastCheckInDateTime = lastCheckInDateTime;
            _x.deviceName = deviceName;
            _x.deviceOSVersion = deviceOSVersion;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    /**
     * <i>“Windows management app health state.”</i>
     * 
     * @return property healthState
     */
    @Property(name="healthState")
    @JsonIgnore
    public Optional<HealthState> getHealthState() {
        return Optional.ofNullable(healthState);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code healthState}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Windows management app health state.”</i>
     * 
     * @param healthState
     *            new value of {@code healthState} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code healthState} field changed
     */
    public WindowsManagementAppHealthState withHealthState(HealthState healthState) {
        WindowsManagementAppHealthState _x = _copy();
        _x.changedFields = changedFields.add("healthState");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsManagementAppHealthState");
        _x.healthState = healthState;
        return _x;
    }

    /**
     * <i>“Windows management app installed version.”</i>
     * 
     * @return property installedVersion
     */
    @Property(name="installedVersion")
    @JsonIgnore
    public Optional<String> getInstalledVersion() {
        return Optional.ofNullable(installedVersion);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code installedVersion}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Windows management app installed version.”</i>
     * 
     * @param installedVersion
     *            new value of {@code installedVersion} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code installedVersion} field changed
     */
    public WindowsManagementAppHealthState withInstalledVersion(String installedVersion) {
        WindowsManagementAppHealthState _x = _copy();
        _x.changedFields = changedFields.add("installedVersion");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsManagementAppHealthState");
        _x.installedVersion = installedVersion;
        return _x;
    }

    /**
     * <i>“Windows management app last check-in time.”</i>
     * 
     * @return property lastCheckInDateTime
     */
    @Property(name="lastCheckInDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getLastCheckInDateTime() {
        return Optional.ofNullable(lastCheckInDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * lastCheckInDateTime} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Windows management app last check-in time.”</i>
     * 
     * @param lastCheckInDateTime
     *            new value of {@code lastCheckInDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code lastCheckInDateTime} field changed
     */
    public WindowsManagementAppHealthState withLastCheckInDateTime(OffsetDateTime lastCheckInDateTime) {
        WindowsManagementAppHealthState _x = _copy();
        _x.changedFields = changedFields.add("lastCheckInDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsManagementAppHealthState");
        _x.lastCheckInDateTime = lastCheckInDateTime;
        return _x;
    }

    /**
     * <i>“Name of the device on which Windows management app is installed.”</i>
     * 
     * @return property deviceName
     */
    @Property(name="deviceName")
    @JsonIgnore
    public Optional<String> getDeviceName() {
        return Optional.ofNullable(deviceName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code deviceName} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Name of the device on which Windows management app is installed.”</i>
     * 
     * @param deviceName
     *            new value of {@code deviceName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code deviceName} field changed
     */
    public WindowsManagementAppHealthState withDeviceName(String deviceName) {
        WindowsManagementAppHealthState _x = _copy();
        _x.changedFields = changedFields.add("deviceName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsManagementAppHealthState");
        _x.deviceName = deviceName;
        return _x;
    }

    /**
     * <i>“Windows 10 OS version of the device on which Windows management app is installed
     * .”</i>
     * 
     * @return property deviceOSVersion
     */
    @Property(name="deviceOSVersion")
    @JsonIgnore
    public Optional<String> getDeviceOSVersion() {
        return Optional.ofNullable(deviceOSVersion);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code deviceOSVersion}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Windows 10 OS version of the device on which Windows management app is installed
     * .”</i>
     * 
     * @param deviceOSVersion
     *            new value of {@code deviceOSVersion} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code deviceOSVersion} field changed
     */
    public WindowsManagementAppHealthState withDeviceOSVersion(String deviceOSVersion) {
        WindowsManagementAppHealthState _x = _copy();
        _x.changedFields = changedFields.add("deviceOSVersion");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsManagementAppHealthState");
        _x.deviceOSVersion = deviceOSVersion;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public WindowsManagementAppHealthState patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        WindowsManagementAppHealthState _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public WindowsManagementAppHealthState put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        WindowsManagementAppHealthState _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private WindowsManagementAppHealthState _copy() {
        WindowsManagementAppHealthState _x = new WindowsManagementAppHealthState();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.healthState = healthState;
        _x.installedVersion = installedVersion;
        _x.lastCheckInDateTime = lastCheckInDateTime;
        _x.deviceName = deviceName;
        _x.deviceOSVersion = deviceOSVersion;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("WindowsManagementAppHealthState[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("healthState=");
        b.append(this.healthState);
        b.append(", ");
        b.append("installedVersion=");
        b.append(this.installedVersion);
        b.append(", ");
        b.append("lastCheckInDateTime=");
        b.append(this.lastCheckInDateTime);
        b.append(", ");
        b.append("deviceName=");
        b.append(this.deviceName);
        b.append(", ");
        b.append("deviceOSVersion=");
        b.append(this.deviceOSVersion);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
