package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.OffsetDateTime;
import java.util.Optional;

import odata.msgraph.client.beta.entity.collection.request.WindowsProtectionStateCollectionRequest;
import odata.msgraph.client.beta.enums.WindowsMalwareCategory;
import odata.msgraph.client.beta.enums.WindowsMalwareSeverity;


/**
 * <i>“Malware information entity.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "displayName", 
    "additionalInformationUrl", 
    "severity", 
    "category", 
    "lastDetectionDateTime"})
@JsonInclude(Include.NON_NULL)
public class WindowsMalwareInformation extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.windowsMalwareInformation";
    }

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("additionalInformationUrl")
    protected String additionalInformationUrl;

    @JsonProperty("severity")
    protected WindowsMalwareSeverity severity;

    @JsonProperty("category")
    protected WindowsMalwareCategory category;

    @JsonProperty("lastDetectionDateTime")
    protected OffsetDateTime lastDetectionDateTime;

    protected WindowsMalwareInformation() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderWindowsMalwareInformation() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String displayName;
        private String additionalInformationUrl;
        private WindowsMalwareSeverity severity;
        private WindowsMalwareCategory category;
        private OffsetDateTime lastDetectionDateTime;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        /**
         * <i>“Malware name”</i>
         * 
         * @param displayName
         *            value of {@code displayName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        /**
         * <i>“Information URL to learn more about the malware”</i>
         * 
         * @param additionalInformationUrl
         *            value of {@code additionalInformationUrl} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder additionalInformationUrl(String additionalInformationUrl) {
            this.additionalInformationUrl = additionalInformationUrl;
            this.changedFields = changedFields.add("additionalInformationUrl");
            return this;
        }

        /**
         * <i>“Severity of the malware”</i>
         * 
         * @param severity
         *            value of {@code severity} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder severity(WindowsMalwareSeverity severity) {
            this.severity = severity;
            this.changedFields = changedFields.add("severity");
            return this;
        }

        /**
         * <i>“Category of the malware”</i>
         * 
         * @param category
         *            value of {@code category} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder category(WindowsMalwareCategory category) {
            this.category = category;
            this.changedFields = changedFields.add("category");
            return this;
        }

        /**
         * <i>“The last time the malware is detected”</i>
         * 
         * @param lastDetectionDateTime
         *            value of {@code lastDetectionDateTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder lastDetectionDateTime(OffsetDateTime lastDetectionDateTime) {
            this.lastDetectionDateTime = lastDetectionDateTime;
            this.changedFields = changedFields.add("lastDetectionDateTime");
            return this;
        }

        public WindowsMalwareInformation build() {
            WindowsMalwareInformation _x = new WindowsMalwareInformation();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.windowsMalwareInformation";
            _x.id = id;
            _x.displayName = displayName;
            _x.additionalInformationUrl = additionalInformationUrl;
            _x.severity = severity;
            _x.category = category;
            _x.lastDetectionDateTime = lastDetectionDateTime;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    /**
     * <i>“Malware name”</i>
     * 
     * @return property displayName
     */
    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code displayName}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Malware name”</i>
     * 
     * @param displayName
     *            new value of {@code displayName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code displayName} field changed
     */
    public WindowsMalwareInformation withDisplayName(String displayName) {
        WindowsMalwareInformation _x = _copy();
        _x.changedFields = changedFields.add("displayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsMalwareInformation");
        _x.displayName = displayName;
        return _x;
    }

    /**
     * <i>“Information URL to learn more about the malware”</i>
     * 
     * @return property additionalInformationUrl
     */
    @Property(name="additionalInformationUrl")
    @JsonIgnore
    public Optional<String> getAdditionalInformationUrl() {
        return Optional.ofNullable(additionalInformationUrl);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * additionalInformationUrl} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Information URL to learn more about the malware”</i>
     * 
     * @param additionalInformationUrl
     *            new value of {@code additionalInformationUrl} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code additionalInformationUrl} field changed
     */
    public WindowsMalwareInformation withAdditionalInformationUrl(String additionalInformationUrl) {
        WindowsMalwareInformation _x = _copy();
        _x.changedFields = changedFields.add("additionalInformationUrl");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsMalwareInformation");
        _x.additionalInformationUrl = additionalInformationUrl;
        return _x;
    }

    /**
     * <i>“Severity of the malware”</i>
     * 
     * @return property severity
     */
    @Property(name="severity")
    @JsonIgnore
    public Optional<WindowsMalwareSeverity> getSeverity() {
        return Optional.ofNullable(severity);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code severity} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Severity of the malware”</i>
     * 
     * @param severity
     *            new value of {@code severity} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code severity} field changed
     */
    public WindowsMalwareInformation withSeverity(WindowsMalwareSeverity severity) {
        WindowsMalwareInformation _x = _copy();
        _x.changedFields = changedFields.add("severity");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsMalwareInformation");
        _x.severity = severity;
        return _x;
    }

    /**
     * <i>“Category of the malware”</i>
     * 
     * @return property category
     */
    @Property(name="category")
    @JsonIgnore
    public Optional<WindowsMalwareCategory> getCategory() {
        return Optional.ofNullable(category);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code category} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Category of the malware”</i>
     * 
     * @param category
     *            new value of {@code category} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code category} field changed
     */
    public WindowsMalwareInformation withCategory(WindowsMalwareCategory category) {
        WindowsMalwareInformation _x = _copy();
        _x.changedFields = changedFields.add("category");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsMalwareInformation");
        _x.category = category;
        return _x;
    }

    /**
     * <i>“The last time the malware is detected”</i>
     * 
     * @return property lastDetectionDateTime
     */
    @Property(name="lastDetectionDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getLastDetectionDateTime() {
        return Optional.ofNullable(lastDetectionDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * lastDetectionDateTime} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“The last time the malware is detected”</i>
     * 
     * @param lastDetectionDateTime
     *            new value of {@code lastDetectionDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code lastDetectionDateTime} field changed
     */
    public WindowsMalwareInformation withLastDetectionDateTime(OffsetDateTime lastDetectionDateTime) {
        WindowsMalwareInformation _x = _copy();
        _x.changedFields = changedFields.add("lastDetectionDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsMalwareInformation");
        _x.lastDetectionDateTime = lastDetectionDateTime;
        return _x;
    }

    /**
     * <i>“List of devices' protection status affected with the current malware”</i>
     * 
     * @return navigational property windowsDevicesProtectionState
     */
    @NavigationProperty(name="windowsDevicesProtectionState")
    @JsonIgnore
    public WindowsProtectionStateCollectionRequest getWindowsDevicesProtectionState() {
        return new WindowsProtectionStateCollectionRequest(
                        contextPath.addSegment("windowsDevicesProtectionState"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public WindowsMalwareInformation patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        WindowsMalwareInformation _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public WindowsMalwareInformation put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        WindowsMalwareInformation _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private WindowsMalwareInformation _copy() {
        WindowsMalwareInformation _x = new WindowsMalwareInformation();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.displayName = displayName;
        _x.additionalInformationUrl = additionalInformationUrl;
        _x.severity = severity;
        _x.category = category;
        _x.lastDetectionDateTime = lastDetectionDateTime;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("WindowsMalwareInformation[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("additionalInformationUrl=");
        b.append(this.additionalInformationUrl);
        b.append(", ");
        b.append("severity=");
        b.append(this.severity);
        b.append(", ");
        b.append("category=");
        b.append(this.category);
        b.append(", ");
        b.append("lastDetectionDateTime=");
        b.append(this.lastDetectionDateTime);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
