package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.EdmSchemaInfo;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.complex.DeviceManagementApplicabilityRuleDeviceMode;
import odata.msgraph.client.beta.complex.DeviceManagementApplicabilityRuleOsEdition;
import odata.msgraph.client.beta.complex.DeviceManagementApplicabilityRuleOsVersion;
import odata.msgraph.client.beta.complex.WindowsKioskForceUpdateSchedule;
import odata.msgraph.client.beta.complex.WindowsKioskProfile;
import odata.msgraph.client.beta.schema.SchemaInfo;


/**
 * <i>“This entity provides descriptions of the declared methods, properties and
 * relationships exposed by the kiosk resource.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "kioskProfiles", 
    "kioskBrowserDefaultUrl", 
    "kioskBrowserEnableHomeButton", 
    "kioskBrowserEnableNavigationButtons", 
    "kioskBrowserEnableEndSessionButton", 
    "kioskBrowserRestartOnIdleTimeInMinutes", 
    "kioskBrowserBlockedURLs", 
    "kioskBrowserBlockedUrlExceptions", 
    "edgeKioskEnablePublicBrowsing", 
    "windowsKioskForceUpdateSchedule"})
@JsonInclude(Include.NON_NULL)
public class WindowsKioskConfiguration extends DeviceConfiguration implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.windowsKioskConfiguration";
    }

    @JsonProperty("kioskProfiles")
    protected List<WindowsKioskProfile> kioskProfiles;

    @JsonProperty("kioskProfiles@nextLink")
    protected String kioskProfilesNextLink;

    @JsonProperty("kioskBrowserDefaultUrl")
    protected String kioskBrowserDefaultUrl;

    @JsonProperty("kioskBrowserEnableHomeButton")
    protected Boolean kioskBrowserEnableHomeButton;

    @JsonProperty("kioskBrowserEnableNavigationButtons")
    protected Boolean kioskBrowserEnableNavigationButtons;

    @JsonProperty("kioskBrowserEnableEndSessionButton")
    protected Boolean kioskBrowserEnableEndSessionButton;

    @JsonProperty("kioskBrowserRestartOnIdleTimeInMinutes")
    protected Integer kioskBrowserRestartOnIdleTimeInMinutes;

    @JsonProperty("kioskBrowserBlockedURLs")
    protected List<String> kioskBrowserBlockedURLs;

    @JsonProperty("kioskBrowserBlockedURLs@nextLink")
    protected String kioskBrowserBlockedURLsNextLink;

    @JsonProperty("kioskBrowserBlockedUrlExceptions")
    protected List<String> kioskBrowserBlockedUrlExceptions;

    @JsonProperty("kioskBrowserBlockedUrlExceptions@nextLink")
    protected String kioskBrowserBlockedUrlExceptionsNextLink;

    @JsonProperty("edgeKioskEnablePublicBrowsing")
    protected Boolean edgeKioskEnablePublicBrowsing;

    @JsonProperty("windowsKioskForceUpdateSchedule")
    protected WindowsKioskForceUpdateSchedule windowsKioskForceUpdateSchedule;

    protected WindowsKioskConfiguration() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderWindowsKioskConfiguration() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private OffsetDateTime lastModifiedDateTime;
        private List<String> roleScopeTagIds;
        private String roleScopeTagIdsNextLink;
        private Boolean supportsScopeTags;
        private DeviceManagementApplicabilityRuleOsEdition deviceManagementApplicabilityRuleOsEdition;
        private DeviceManagementApplicabilityRuleOsVersion deviceManagementApplicabilityRuleOsVersion;
        private DeviceManagementApplicabilityRuleDeviceMode deviceManagementApplicabilityRuleDeviceMode;
        private OffsetDateTime createdDateTime;
        private String description;
        private String displayName;
        private Integer version;
        private List<WindowsKioskProfile> kioskProfiles;
        private String kioskProfilesNextLink;
        private String kioskBrowserDefaultUrl;
        private Boolean kioskBrowserEnableHomeButton;
        private Boolean kioskBrowserEnableNavigationButtons;
        private Boolean kioskBrowserEnableEndSessionButton;
        private Integer kioskBrowserRestartOnIdleTimeInMinutes;
        private List<String> kioskBrowserBlockedURLs;
        private String kioskBrowserBlockedURLsNextLink;
        private List<String> kioskBrowserBlockedUrlExceptions;
        private String kioskBrowserBlockedUrlExceptionsNextLink;
        private Boolean edgeKioskEnablePublicBrowsing;
        private WindowsKioskForceUpdateSchedule windowsKioskForceUpdateSchedule;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder lastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
            this.lastModifiedDateTime = lastModifiedDateTime;
            this.changedFields = changedFields.add("lastModifiedDateTime");
            return this;
        }

        public Builder roleScopeTagIds(List<String> roleScopeTagIds) {
            this.roleScopeTagIds = roleScopeTagIds;
            this.changedFields = changedFields.add("roleScopeTagIds");
            return this;
        }

        public Builder roleScopeTagIds(String... roleScopeTagIds) {
            return roleScopeTagIds(Arrays.asList(roleScopeTagIds));
        }

        public Builder roleScopeTagIdsNextLink(String roleScopeTagIdsNextLink) {
            this.roleScopeTagIdsNextLink = roleScopeTagIdsNextLink;
            this.changedFields = changedFields.add("roleScopeTagIds");
            return this;
        }

        public Builder supportsScopeTags(Boolean supportsScopeTags) {
            this.supportsScopeTags = supportsScopeTags;
            this.changedFields = changedFields.add("supportsScopeTags");
            return this;
        }

        public Builder deviceManagementApplicabilityRuleOsEdition(DeviceManagementApplicabilityRuleOsEdition deviceManagementApplicabilityRuleOsEdition) {
            this.deviceManagementApplicabilityRuleOsEdition = deviceManagementApplicabilityRuleOsEdition;
            this.changedFields = changedFields.add("deviceManagementApplicabilityRuleOsEdition");
            return this;
        }

        public Builder deviceManagementApplicabilityRuleOsVersion(DeviceManagementApplicabilityRuleOsVersion deviceManagementApplicabilityRuleOsVersion) {
            this.deviceManagementApplicabilityRuleOsVersion = deviceManagementApplicabilityRuleOsVersion;
            this.changedFields = changedFields.add("deviceManagementApplicabilityRuleOsVersion");
            return this;
        }

        public Builder deviceManagementApplicabilityRuleDeviceMode(DeviceManagementApplicabilityRuleDeviceMode deviceManagementApplicabilityRuleDeviceMode) {
            this.deviceManagementApplicabilityRuleDeviceMode = deviceManagementApplicabilityRuleDeviceMode;
            this.changedFields = changedFields.add("deviceManagementApplicabilityRuleDeviceMode");
            return this;
        }

        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder version(Integer version) {
            this.version = version;
            this.changedFields = changedFields.add("version");
            return this;
        }

        /**
         * <i>“This policy setting allows to define a list of Kiosk profiles for a Kiosk
         * configuration. This collection can contain a maximum of 3 elements.”</i>
         * 
         * @param kioskProfiles
         *            value of {@code kioskProfiles} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder kioskProfiles(List<WindowsKioskProfile> kioskProfiles) {
            this.kioskProfiles = kioskProfiles;
            this.changedFields = changedFields.add("kioskProfiles");
            return this;
        }

        /**
         * <i>“This policy setting allows to define a list of Kiosk profiles for a Kiosk
         * configuration. This collection can contain a maximum of 3 elements.”</i>
         * 
         * @param kioskProfiles
         *            value of {@code kioskProfiles} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder kioskProfiles(WindowsKioskProfile... kioskProfiles) {
            return kioskProfiles(Arrays.asList(kioskProfiles));
        }

        /**
         * <i>“This policy setting allows to define a list of Kiosk profiles for a Kiosk
         * configuration. This collection can contain a maximum of 3 elements.”</i>
         * 
         * @param kioskProfilesNextLink
         *            value of {@code kioskProfiles@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder kioskProfilesNextLink(String kioskProfilesNextLink) {
            this.kioskProfilesNextLink = kioskProfilesNextLink;
            this.changedFields = changedFields.add("kioskProfiles");
            return this;
        }

        /**
         * <i>“Specify the default URL the browser should navigate to on launch.”</i>
         * 
         * @param kioskBrowserDefaultUrl
         *            value of {@code kioskBrowserDefaultUrl} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder kioskBrowserDefaultUrl(String kioskBrowserDefaultUrl) {
            this.kioskBrowserDefaultUrl = kioskBrowserDefaultUrl;
            this.changedFields = changedFields.add("kioskBrowserDefaultUrl");
            return this;
        }

        /**
         * <i>“Enable the kiosk browser's home button. By default, the home button is disabled.”</i>
         * 
         * @param kioskBrowserEnableHomeButton
         *            value of {@code kioskBrowserEnableHomeButton} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder kioskBrowserEnableHomeButton(Boolean kioskBrowserEnableHomeButton) {
            this.kioskBrowserEnableHomeButton = kioskBrowserEnableHomeButton;
            this.changedFields = changedFields.add("kioskBrowserEnableHomeButton");
            return this;
        }

        /**
         * <i>“Enable the kiosk browser's navigation buttons(forward/back). By default, the
         * navigation buttons are disabled.”</i>
         * 
         * @param kioskBrowserEnableNavigationButtons
         *            value of {@code kioskBrowserEnableNavigationButtons} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder kioskBrowserEnableNavigationButtons(Boolean kioskBrowserEnableNavigationButtons) {
            this.kioskBrowserEnableNavigationButtons = kioskBrowserEnableNavigationButtons;
            this.changedFields = changedFields.add("kioskBrowserEnableNavigationButtons");
            return this;
        }

        /**
         * <i>“Enable the kiosk browser's end session button. By default, the end session
         * button is disabled.”</i>
         * 
         * @param kioskBrowserEnableEndSessionButton
         *            value of {@code kioskBrowserEnableEndSessionButton} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder kioskBrowserEnableEndSessionButton(Boolean kioskBrowserEnableEndSessionButton) {
            this.kioskBrowserEnableEndSessionButton = kioskBrowserEnableEndSessionButton;
            this.changedFields = changedFields.add("kioskBrowserEnableEndSessionButton");
            return this;
        }

        /**
         * <i>“Specify the number of minutes the session is idle until the kiosk browser
         * restarts in a fresh state.  Valid values are 1-1440. Valid values 1 to 1440”</i>
         * 
         * @param kioskBrowserRestartOnIdleTimeInMinutes
         *            value of {@code kioskBrowserRestartOnIdleTimeInMinutes} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder kioskBrowserRestartOnIdleTimeInMinutes(Integer kioskBrowserRestartOnIdleTimeInMinutes) {
            this.kioskBrowserRestartOnIdleTimeInMinutes = kioskBrowserRestartOnIdleTimeInMinutes;
            this.changedFields = changedFields.add("kioskBrowserRestartOnIdleTimeInMinutes");
            return this;
        }

        /**
         * <i>“Specify URLs that the kiosk browsers should not navigate to”</i>
         * 
         * @param kioskBrowserBlockedURLs
         *            value of {@code kioskBrowserBlockedURLs} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder kioskBrowserBlockedURLs(List<String> kioskBrowserBlockedURLs) {
            this.kioskBrowserBlockedURLs = kioskBrowserBlockedURLs;
            this.changedFields = changedFields.add("kioskBrowserBlockedURLs");
            return this;
        }

        /**
         * <i>“Specify URLs that the kiosk browsers should not navigate to”</i>
         * 
         * @param kioskBrowserBlockedURLs
         *            value of {@code kioskBrowserBlockedURLs} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder kioskBrowserBlockedURLs(String... kioskBrowserBlockedURLs) {
            return kioskBrowserBlockedURLs(Arrays.asList(kioskBrowserBlockedURLs));
        }

        /**
         * <i>“Specify URLs that the kiosk browsers should not navigate to”</i>
         * 
         * @param kioskBrowserBlockedURLsNextLink
         *            value of {@code kioskBrowserBlockedURLs@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder kioskBrowserBlockedURLsNextLink(String kioskBrowserBlockedURLsNextLink) {
            this.kioskBrowserBlockedURLsNextLink = kioskBrowserBlockedURLsNextLink;
            this.changedFields = changedFields.add("kioskBrowserBlockedURLs");
            return this;
        }

        /**
         * <i>“Specify URLs that the kiosk browser is allowed to navigate to”</i>
         * 
         * @param kioskBrowserBlockedUrlExceptions
         *            value of {@code kioskBrowserBlockedUrlExceptions} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder kioskBrowserBlockedUrlExceptions(List<String> kioskBrowserBlockedUrlExceptions) {
            this.kioskBrowserBlockedUrlExceptions = kioskBrowserBlockedUrlExceptions;
            this.changedFields = changedFields.add("kioskBrowserBlockedUrlExceptions");
            return this;
        }

        /**
         * <i>“Specify URLs that the kiosk browser is allowed to navigate to”</i>
         * 
         * @param kioskBrowserBlockedUrlExceptions
         *            value of {@code kioskBrowserBlockedUrlExceptions} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder kioskBrowserBlockedUrlExceptions(String... kioskBrowserBlockedUrlExceptions) {
            return kioskBrowserBlockedUrlExceptions(Arrays.asList(kioskBrowserBlockedUrlExceptions));
        }

        /**
         * <i>“Specify URLs that the kiosk browser is allowed to navigate to”</i>
         * 
         * @param kioskBrowserBlockedUrlExceptionsNextLink
         *            value of {@code kioskBrowserBlockedUrlExceptions@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder kioskBrowserBlockedUrlExceptionsNextLink(String kioskBrowserBlockedUrlExceptionsNextLink) {
            this.kioskBrowserBlockedUrlExceptionsNextLink = kioskBrowserBlockedUrlExceptionsNextLink;
            this.changedFields = changedFields.add("kioskBrowserBlockedUrlExceptions");
            return this;
        }

        /**
         * <i>“Enable public browsing kiosk mode for the Microsoft Edge browser. The Default is
         * false.”</i>
         * 
         * @param edgeKioskEnablePublicBrowsing
         *            value of {@code edgeKioskEnablePublicBrowsing} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder edgeKioskEnablePublicBrowsing(Boolean edgeKioskEnablePublicBrowsing) {
            this.edgeKioskEnablePublicBrowsing = edgeKioskEnablePublicBrowsing;
            this.changedFields = changedFields.add("edgeKioskEnablePublicBrowsing");
            return this;
        }

        /**
         * <i>“force update schedule for Kiosk devices.”</i>
         * 
         * @param windowsKioskForceUpdateSchedule
         *            value of {@code windowsKioskForceUpdateSchedule} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder windowsKioskForceUpdateSchedule(WindowsKioskForceUpdateSchedule windowsKioskForceUpdateSchedule) {
            this.windowsKioskForceUpdateSchedule = windowsKioskForceUpdateSchedule;
            this.changedFields = changedFields.add("windowsKioskForceUpdateSchedule");
            return this;
        }

        public WindowsKioskConfiguration build() {
            WindowsKioskConfiguration _x = new WindowsKioskConfiguration();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.windowsKioskConfiguration";
            _x.id = id;
            _x.lastModifiedDateTime = lastModifiedDateTime;
            _x.roleScopeTagIds = roleScopeTagIds;
            _x.roleScopeTagIdsNextLink = roleScopeTagIdsNextLink;
            _x.supportsScopeTags = supportsScopeTags;
            _x.deviceManagementApplicabilityRuleOsEdition = deviceManagementApplicabilityRuleOsEdition;
            _x.deviceManagementApplicabilityRuleOsVersion = deviceManagementApplicabilityRuleOsVersion;
            _x.deviceManagementApplicabilityRuleDeviceMode = deviceManagementApplicabilityRuleDeviceMode;
            _x.createdDateTime = createdDateTime;
            _x.description = description;
            _x.displayName = displayName;
            _x.version = version;
            _x.kioskProfiles = kioskProfiles;
            _x.kioskProfilesNextLink = kioskProfilesNextLink;
            _x.kioskBrowserDefaultUrl = kioskBrowserDefaultUrl;
            _x.kioskBrowserEnableHomeButton = kioskBrowserEnableHomeButton;
            _x.kioskBrowserEnableNavigationButtons = kioskBrowserEnableNavigationButtons;
            _x.kioskBrowserEnableEndSessionButton = kioskBrowserEnableEndSessionButton;
            _x.kioskBrowserRestartOnIdleTimeInMinutes = kioskBrowserRestartOnIdleTimeInMinutes;
            _x.kioskBrowserBlockedURLs = kioskBrowserBlockedURLs;
            _x.kioskBrowserBlockedURLsNextLink = kioskBrowserBlockedURLsNextLink;
            _x.kioskBrowserBlockedUrlExceptions = kioskBrowserBlockedUrlExceptions;
            _x.kioskBrowserBlockedUrlExceptionsNextLink = kioskBrowserBlockedUrlExceptionsNextLink;
            _x.edgeKioskEnablePublicBrowsing = edgeKioskEnablePublicBrowsing;
            _x.windowsKioskForceUpdateSchedule = windowsKioskForceUpdateSchedule;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    /**
     * <i>“This policy setting allows to define a list of Kiosk profiles for a Kiosk
     * configuration. This collection can contain a maximum of 3 elements.”</i>
     * 
     * @return property kioskProfiles
     */
    @Property(name="kioskProfiles")
    @JsonIgnore
    public CollectionPage<WindowsKioskProfile> getKioskProfiles() {
        return new CollectionPage<WindowsKioskProfile>(contextPath, WindowsKioskProfile.class, kioskProfiles, Optional.ofNullable(kioskProfilesNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * <i>“This policy setting allows to define a list of Kiosk profiles for a Kiosk
     * configuration. This collection can contain a maximum of 3 elements.”</i>
     * 
     * @return property kioskProfiles
     */
    @Property(name="kioskProfiles")
    @JsonIgnore
    public CollectionPage<WindowsKioskProfile> getKioskProfiles(HttpRequestOptions options) {
        return new CollectionPage<WindowsKioskProfile>(contextPath, WindowsKioskProfile.class, kioskProfiles, Optional.ofNullable(kioskProfilesNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    /**
     * <i>“Specify the default URL the browser should navigate to on launch.”</i>
     * 
     * @return property kioskBrowserDefaultUrl
     */
    @Property(name="kioskBrowserDefaultUrl")
    @JsonIgnore
    public Optional<String> getKioskBrowserDefaultUrl() {
        return Optional.ofNullable(kioskBrowserDefaultUrl);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * kioskBrowserDefaultUrl} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Specify the default URL the browser should navigate to on launch.”</i>
     * 
     * @param kioskBrowserDefaultUrl
     *            new value of {@code kioskBrowserDefaultUrl} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code kioskBrowserDefaultUrl} field changed
     */
    public WindowsKioskConfiguration withKioskBrowserDefaultUrl(String kioskBrowserDefaultUrl) {
        WindowsKioskConfiguration _x = _copy();
        _x.changedFields = changedFields.add("kioskBrowserDefaultUrl");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsKioskConfiguration");
        _x.kioskBrowserDefaultUrl = kioskBrowserDefaultUrl;
        return _x;
    }

    /**
     * <i>“Enable the kiosk browser's home button. By default, the home button is disabled.”</i>
     * 
     * @return property kioskBrowserEnableHomeButton
     */
    @Property(name="kioskBrowserEnableHomeButton")
    @JsonIgnore
    public Optional<Boolean> getKioskBrowserEnableHomeButton() {
        return Optional.ofNullable(kioskBrowserEnableHomeButton);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * kioskBrowserEnableHomeButton} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Enable the kiosk browser's home button. By default, the home button is disabled.”</i>
     * 
     * @param kioskBrowserEnableHomeButton
     *            new value of {@code kioskBrowserEnableHomeButton} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code kioskBrowserEnableHomeButton} field changed
     */
    public WindowsKioskConfiguration withKioskBrowserEnableHomeButton(Boolean kioskBrowserEnableHomeButton) {
        WindowsKioskConfiguration _x = _copy();
        _x.changedFields = changedFields.add("kioskBrowserEnableHomeButton");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsKioskConfiguration");
        _x.kioskBrowserEnableHomeButton = kioskBrowserEnableHomeButton;
        return _x;
    }

    /**
     * <i>“Enable the kiosk browser's navigation buttons(forward/back). By default, the
     * navigation buttons are disabled.”</i>
     * 
     * @return property kioskBrowserEnableNavigationButtons
     */
    @Property(name="kioskBrowserEnableNavigationButtons")
    @JsonIgnore
    public Optional<Boolean> getKioskBrowserEnableNavigationButtons() {
        return Optional.ofNullable(kioskBrowserEnableNavigationButtons);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * kioskBrowserEnableNavigationButtons} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Enable the kiosk browser's navigation buttons(forward/back). By default, the
     * navigation buttons are disabled.”</i>
     * 
     * @param kioskBrowserEnableNavigationButtons
     *            new value of {@code kioskBrowserEnableNavigationButtons} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code kioskBrowserEnableNavigationButtons} field changed
     */
    public WindowsKioskConfiguration withKioskBrowserEnableNavigationButtons(Boolean kioskBrowserEnableNavigationButtons) {
        WindowsKioskConfiguration _x = _copy();
        _x.changedFields = changedFields.add("kioskBrowserEnableNavigationButtons");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsKioskConfiguration");
        _x.kioskBrowserEnableNavigationButtons = kioskBrowserEnableNavigationButtons;
        return _x;
    }

    /**
     * <i>“Enable the kiosk browser's end session button. By default, the end session
     * button is disabled.”</i>
     * 
     * @return property kioskBrowserEnableEndSessionButton
     */
    @Property(name="kioskBrowserEnableEndSessionButton")
    @JsonIgnore
    public Optional<Boolean> getKioskBrowserEnableEndSessionButton() {
        return Optional.ofNullable(kioskBrowserEnableEndSessionButton);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * kioskBrowserEnableEndSessionButton} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Enable the kiosk browser's end session button. By default, the end session
     * button is disabled.”</i>
     * 
     * @param kioskBrowserEnableEndSessionButton
     *            new value of {@code kioskBrowserEnableEndSessionButton} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code kioskBrowserEnableEndSessionButton} field changed
     */
    public WindowsKioskConfiguration withKioskBrowserEnableEndSessionButton(Boolean kioskBrowserEnableEndSessionButton) {
        WindowsKioskConfiguration _x = _copy();
        _x.changedFields = changedFields.add("kioskBrowserEnableEndSessionButton");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsKioskConfiguration");
        _x.kioskBrowserEnableEndSessionButton = kioskBrowserEnableEndSessionButton;
        return _x;
    }

    /**
     * <i>“Specify the number of minutes the session is idle until the kiosk browser
     * restarts in a fresh state.  Valid values are 1-1440. Valid values 1 to 1440”</i>
     * 
     * @return property kioskBrowserRestartOnIdleTimeInMinutes
     */
    @Property(name="kioskBrowserRestartOnIdleTimeInMinutes")
    @JsonIgnore
    public Optional<Integer> getKioskBrowserRestartOnIdleTimeInMinutes() {
        return Optional.ofNullable(kioskBrowserRestartOnIdleTimeInMinutes);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * kioskBrowserRestartOnIdleTimeInMinutes} field changed. Field description below.
     * The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Specify the number of minutes the session is idle until the kiosk browser
     * restarts in a fresh state.  Valid values are 1-1440. Valid values 1 to 1440”</i>
     * 
     * @param kioskBrowserRestartOnIdleTimeInMinutes
     *            new value of {@code kioskBrowserRestartOnIdleTimeInMinutes} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code kioskBrowserRestartOnIdleTimeInMinutes} field changed
     */
    public WindowsKioskConfiguration withKioskBrowserRestartOnIdleTimeInMinutes(Integer kioskBrowserRestartOnIdleTimeInMinutes) {
        WindowsKioskConfiguration _x = _copy();
        _x.changedFields = changedFields.add("kioskBrowserRestartOnIdleTimeInMinutes");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsKioskConfiguration");
        _x.kioskBrowserRestartOnIdleTimeInMinutes = kioskBrowserRestartOnIdleTimeInMinutes;
        return _x;
    }

    /**
     * <i>“Specify URLs that the kiosk browsers should not navigate to”</i>
     * 
     * @return property kioskBrowserBlockedURLs
     */
    @Property(name="kioskBrowserBlockedURLs")
    @JsonIgnore
    public CollectionPage<String> getKioskBrowserBlockedURLs() {
        return new CollectionPage<String>(contextPath, String.class, kioskBrowserBlockedURLs, Optional.ofNullable(kioskBrowserBlockedURLsNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * <i>“Specify URLs that the kiosk browsers should not navigate to”</i>
     * 
     * @return property kioskBrowserBlockedURLs
     */
    @Property(name="kioskBrowserBlockedURLs")
    @JsonIgnore
    public CollectionPage<String> getKioskBrowserBlockedURLs(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, kioskBrowserBlockedURLs, Optional.ofNullable(kioskBrowserBlockedURLsNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    /**
     * <i>“Specify URLs that the kiosk browser is allowed to navigate to”</i>
     * 
     * @return property kioskBrowserBlockedUrlExceptions
     */
    @Property(name="kioskBrowserBlockedUrlExceptions")
    @JsonIgnore
    public CollectionPage<String> getKioskBrowserBlockedUrlExceptions() {
        return new CollectionPage<String>(contextPath, String.class, kioskBrowserBlockedUrlExceptions, Optional.ofNullable(kioskBrowserBlockedUrlExceptionsNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * <i>“Specify URLs that the kiosk browser is allowed to navigate to”</i>
     * 
     * @return property kioskBrowserBlockedUrlExceptions
     */
    @Property(name="kioskBrowserBlockedUrlExceptions")
    @JsonIgnore
    public CollectionPage<String> getKioskBrowserBlockedUrlExceptions(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, kioskBrowserBlockedUrlExceptions, Optional.ofNullable(kioskBrowserBlockedUrlExceptionsNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    /**
     * <i>“Enable public browsing kiosk mode for the Microsoft Edge browser. The Default is
     * false.”</i>
     * 
     * @return property edgeKioskEnablePublicBrowsing
     */
    @Property(name="edgeKioskEnablePublicBrowsing")
    @JsonIgnore
    public Optional<Boolean> getEdgeKioskEnablePublicBrowsing() {
        return Optional.ofNullable(edgeKioskEnablePublicBrowsing);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * edgeKioskEnablePublicBrowsing} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Enable public browsing kiosk mode for the Microsoft Edge browser. The Default is
     * false.”</i>
     * 
     * @param edgeKioskEnablePublicBrowsing
     *            new value of {@code edgeKioskEnablePublicBrowsing} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code edgeKioskEnablePublicBrowsing} field changed
     */
    public WindowsKioskConfiguration withEdgeKioskEnablePublicBrowsing(Boolean edgeKioskEnablePublicBrowsing) {
        WindowsKioskConfiguration _x = _copy();
        _x.changedFields = changedFields.add("edgeKioskEnablePublicBrowsing");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsKioskConfiguration");
        _x.edgeKioskEnablePublicBrowsing = edgeKioskEnablePublicBrowsing;
        return _x;
    }

    /**
     * <i>“force update schedule for Kiosk devices.”</i>
     * 
     * @return property windowsKioskForceUpdateSchedule
     */
    @Property(name="windowsKioskForceUpdateSchedule")
    @JsonIgnore
    public Optional<WindowsKioskForceUpdateSchedule> getWindowsKioskForceUpdateSchedule() {
        return Optional.ofNullable(windowsKioskForceUpdateSchedule);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * windowsKioskForceUpdateSchedule} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“force update schedule for Kiosk devices.”</i>
     * 
     * @param windowsKioskForceUpdateSchedule
     *            new value of {@code windowsKioskForceUpdateSchedule} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code windowsKioskForceUpdateSchedule} field changed
     */
    public WindowsKioskConfiguration withWindowsKioskForceUpdateSchedule(WindowsKioskForceUpdateSchedule windowsKioskForceUpdateSchedule) {
        WindowsKioskConfiguration _x = _copy();
        _x.changedFields = changedFields.add("windowsKioskForceUpdateSchedule");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsKioskConfiguration");
        _x.windowsKioskForceUpdateSchedule = windowsKioskForceUpdateSchedule;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public WindowsKioskConfiguration patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        WindowsKioskConfiguration _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public WindowsKioskConfiguration put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        WindowsKioskConfiguration _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private WindowsKioskConfiguration _copy() {
        WindowsKioskConfiguration _x = new WindowsKioskConfiguration();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        _x.roleScopeTagIds = roleScopeTagIds;
        _x.supportsScopeTags = supportsScopeTags;
        _x.deviceManagementApplicabilityRuleOsEdition = deviceManagementApplicabilityRuleOsEdition;
        _x.deviceManagementApplicabilityRuleOsVersion = deviceManagementApplicabilityRuleOsVersion;
        _x.deviceManagementApplicabilityRuleDeviceMode = deviceManagementApplicabilityRuleDeviceMode;
        _x.createdDateTime = createdDateTime;
        _x.description = description;
        _x.displayName = displayName;
        _x.version = version;
        _x.kioskProfiles = kioskProfiles;
        _x.kioskBrowserDefaultUrl = kioskBrowserDefaultUrl;
        _x.kioskBrowserEnableHomeButton = kioskBrowserEnableHomeButton;
        _x.kioskBrowserEnableNavigationButtons = kioskBrowserEnableNavigationButtons;
        _x.kioskBrowserEnableEndSessionButton = kioskBrowserEnableEndSessionButton;
        _x.kioskBrowserRestartOnIdleTimeInMinutes = kioskBrowserRestartOnIdleTimeInMinutes;
        _x.kioskBrowserBlockedURLs = kioskBrowserBlockedURLs;
        _x.kioskBrowserBlockedUrlExceptions = kioskBrowserBlockedUrlExceptions;
        _x.edgeKioskEnablePublicBrowsing = edgeKioskEnablePublicBrowsing;
        _x.windowsKioskForceUpdateSchedule = windowsKioskForceUpdateSchedule;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("WindowsKioskConfiguration[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append(", ");
        b.append("roleScopeTagIds=");
        b.append(this.roleScopeTagIds);
        b.append(", ");
        b.append("supportsScopeTags=");
        b.append(this.supportsScopeTags);
        b.append(", ");
        b.append("deviceManagementApplicabilityRuleOsEdition=");
        b.append(this.deviceManagementApplicabilityRuleOsEdition);
        b.append(", ");
        b.append("deviceManagementApplicabilityRuleOsVersion=");
        b.append(this.deviceManagementApplicabilityRuleOsVersion);
        b.append(", ");
        b.append("deviceManagementApplicabilityRuleDeviceMode=");
        b.append(this.deviceManagementApplicabilityRuleDeviceMode);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("version=");
        b.append(this.version);
        b.append(", ");
        b.append("kioskProfiles=");
        b.append(this.kioskProfiles);
        b.append(", ");
        b.append("kioskBrowserDefaultUrl=");
        b.append(this.kioskBrowserDefaultUrl);
        b.append(", ");
        b.append("kioskBrowserEnableHomeButton=");
        b.append(this.kioskBrowserEnableHomeButton);
        b.append(", ");
        b.append("kioskBrowserEnableNavigationButtons=");
        b.append(this.kioskBrowserEnableNavigationButtons);
        b.append(", ");
        b.append("kioskBrowserEnableEndSessionButton=");
        b.append(this.kioskBrowserEnableEndSessionButton);
        b.append(", ");
        b.append("kioskBrowserRestartOnIdleTimeInMinutes=");
        b.append(this.kioskBrowserRestartOnIdleTimeInMinutes);
        b.append(", ");
        b.append("kioskBrowserBlockedURLs=");
        b.append(this.kioskBrowserBlockedURLs);
        b.append(", ");
        b.append("kioskBrowserBlockedUrlExceptions=");
        b.append(this.kioskBrowserBlockedUrlExceptions);
        b.append(", ");
        b.append("edgeKioskEnablePublicBrowsing=");
        b.append(this.edgeKioskEnablePublicBrowsing);
        b.append(", ");
        b.append("windowsKioskForceUpdateSchedule=");
        b.append(this.windowsKioskForceUpdateSchedule);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
