package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.TypedObject;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.OffsetDateTime;
import java.util.Map;
import java.util.Optional;


/**
 * <i>“Represents device registration records for Bring-Your-Own-Device(BYOD) Windows
 * devices.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "userId", 
    "deviceRegistrationId", 
    "deviceName", 
    "deviceType", 
    "deviceMacAddress", 
    "lastCheckInDateTime"})
@JsonInclude(Include.NON_NULL)
public class WindowsInformationProtectionDeviceRegistration extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.windowsInformationProtectionDeviceRegistration";
    }

    @JsonProperty("userId")
    protected String userId;

    @JsonProperty("deviceRegistrationId")
    protected String deviceRegistrationId;

    @JsonProperty("deviceName")
    protected String deviceName;

    @JsonProperty("deviceType")
    protected String deviceType;

    @JsonProperty("deviceMacAddress")
    protected String deviceMacAddress;

    @JsonProperty("lastCheckInDateTime")
    protected OffsetDateTime lastCheckInDateTime;

    protected WindowsInformationProtectionDeviceRegistration() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderWindowsInformationProtectionDeviceRegistration() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String userId;
        private String deviceRegistrationId;
        private String deviceName;
        private String deviceType;
        private String deviceMacAddress;
        private OffsetDateTime lastCheckInDateTime;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        /**
         * <i>“UserId associated with this device registration record.”</i>
         * 
         * @param userId
         *            value of {@code userId} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder userId(String userId) {
            this.userId = userId;
            this.changedFields = changedFields.add("userId");
            return this;
        }

        /**
         * <i>“Device identifier for this device registration record.”</i>
         * 
         * @param deviceRegistrationId
         *            value of {@code deviceRegistrationId} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder deviceRegistrationId(String deviceRegistrationId) {
            this.deviceRegistrationId = deviceRegistrationId;
            this.changedFields = changedFields.add("deviceRegistrationId");
            return this;
        }

        /**
         * <i>“Device name.”</i>
         * 
         * @param deviceName
         *            value of {@code deviceName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder deviceName(String deviceName) {
            this.deviceName = deviceName;
            this.changedFields = changedFields.add("deviceName");
            return this;
        }

        /**
         * <i>“Device type, for example, Windows laptop VS Windows phone.”</i>
         * 
         * @param deviceType
         *            value of {@code deviceType} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder deviceType(String deviceType) {
            this.deviceType = deviceType;
            this.changedFields = changedFields.add("deviceType");
            return this;
        }

        /**
         * <i>“Device Mac address.”</i>
         * 
         * @param deviceMacAddress
         *            value of {@code deviceMacAddress} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder deviceMacAddress(String deviceMacAddress) {
            this.deviceMacAddress = deviceMacAddress;
            this.changedFields = changedFields.add("deviceMacAddress");
            return this;
        }

        /**
         * <i>“Last checkin time of the device.”</i>
         * 
         * @param lastCheckInDateTime
         *            value of {@code lastCheckInDateTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder lastCheckInDateTime(OffsetDateTime lastCheckInDateTime) {
            this.lastCheckInDateTime = lastCheckInDateTime;
            this.changedFields = changedFields.add("lastCheckInDateTime");
            return this;
        }

        public WindowsInformationProtectionDeviceRegistration build() {
            WindowsInformationProtectionDeviceRegistration _x = new WindowsInformationProtectionDeviceRegistration();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.windowsInformationProtectionDeviceRegistration";
            _x.id = id;
            _x.userId = userId;
            _x.deviceRegistrationId = deviceRegistrationId;
            _x.deviceName = deviceName;
            _x.deviceType = deviceType;
            _x.deviceMacAddress = deviceMacAddress;
            _x.lastCheckInDateTime = lastCheckInDateTime;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    /**
     * <i>“UserId associated with this device registration record.”</i>
     * 
     * @return property userId
     */
    @Property(name="userId")
    @JsonIgnore
    public Optional<String> getUserId() {
        return Optional.ofNullable(userId);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code userId} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“UserId associated with this device registration record.”</i>
     * 
     * @param userId
     *            new value of {@code userId} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code userId} field changed
     */
    public WindowsInformationProtectionDeviceRegistration withUserId(String userId) {
        WindowsInformationProtectionDeviceRegistration _x = _copy();
        _x.changedFields = changedFields.add("userId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsInformationProtectionDeviceRegistration");
        _x.userId = userId;
        return _x;
    }

    /**
     * <i>“Device identifier for this device registration record.”</i>
     * 
     * @return property deviceRegistrationId
     */
    @Property(name="deviceRegistrationId")
    @JsonIgnore
    public Optional<String> getDeviceRegistrationId() {
        return Optional.ofNullable(deviceRegistrationId);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * deviceRegistrationId} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Device identifier for this device registration record.”</i>
     * 
     * @param deviceRegistrationId
     *            new value of {@code deviceRegistrationId} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code deviceRegistrationId} field changed
     */
    public WindowsInformationProtectionDeviceRegistration withDeviceRegistrationId(String deviceRegistrationId) {
        WindowsInformationProtectionDeviceRegistration _x = _copy();
        _x.changedFields = changedFields.add("deviceRegistrationId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsInformationProtectionDeviceRegistration");
        _x.deviceRegistrationId = deviceRegistrationId;
        return _x;
    }

    /**
     * <i>“Device name.”</i>
     * 
     * @return property deviceName
     */
    @Property(name="deviceName")
    @JsonIgnore
    public Optional<String> getDeviceName() {
        return Optional.ofNullable(deviceName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code deviceName} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Device name.”</i>
     * 
     * @param deviceName
     *            new value of {@code deviceName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code deviceName} field changed
     */
    public WindowsInformationProtectionDeviceRegistration withDeviceName(String deviceName) {
        WindowsInformationProtectionDeviceRegistration _x = _copy();
        _x.changedFields = changedFields.add("deviceName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsInformationProtectionDeviceRegistration");
        _x.deviceName = deviceName;
        return _x;
    }

    /**
     * <i>“Device type, for example, Windows laptop VS Windows phone.”</i>
     * 
     * @return property deviceType
     */
    @Property(name="deviceType")
    @JsonIgnore
    public Optional<String> getDeviceType() {
        return Optional.ofNullable(deviceType);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code deviceType} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Device type, for example, Windows laptop VS Windows phone.”</i>
     * 
     * @param deviceType
     *            new value of {@code deviceType} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code deviceType} field changed
     */
    public WindowsInformationProtectionDeviceRegistration withDeviceType(String deviceType) {
        WindowsInformationProtectionDeviceRegistration _x = _copy();
        _x.changedFields = changedFields.add("deviceType");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsInformationProtectionDeviceRegistration");
        _x.deviceType = deviceType;
        return _x;
    }

    /**
     * <i>“Device Mac address.”</i>
     * 
     * @return property deviceMacAddress
     */
    @Property(name="deviceMacAddress")
    @JsonIgnore
    public Optional<String> getDeviceMacAddress() {
        return Optional.ofNullable(deviceMacAddress);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code deviceMacAddress}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Device Mac address.”</i>
     * 
     * @param deviceMacAddress
     *            new value of {@code deviceMacAddress} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code deviceMacAddress} field changed
     */
    public WindowsInformationProtectionDeviceRegistration withDeviceMacAddress(String deviceMacAddress) {
        WindowsInformationProtectionDeviceRegistration _x = _copy();
        _x.changedFields = changedFields.add("deviceMacAddress");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsInformationProtectionDeviceRegistration");
        _x.deviceMacAddress = deviceMacAddress;
        return _x;
    }

    /**
     * <i>“Last checkin time of the device.”</i>
     * 
     * @return property lastCheckInDateTime
     */
    @Property(name="lastCheckInDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getLastCheckInDateTime() {
        return Optional.ofNullable(lastCheckInDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * lastCheckInDateTime} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Last checkin time of the device.”</i>
     * 
     * @param lastCheckInDateTime
     *            new value of {@code lastCheckInDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code lastCheckInDateTime} field changed
     */
    public WindowsInformationProtectionDeviceRegistration withLastCheckInDateTime(OffsetDateTime lastCheckInDateTime) {
        WindowsInformationProtectionDeviceRegistration _x = _copy();
        _x.changedFields = changedFields.add("lastCheckInDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsInformationProtectionDeviceRegistration");
        _x.lastCheckInDateTime = lastCheckInDateTime;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public WindowsInformationProtectionDeviceRegistration patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        WindowsInformationProtectionDeviceRegistration _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public WindowsInformationProtectionDeviceRegistration put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        WindowsInformationProtectionDeviceRegistration _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private WindowsInformationProtectionDeviceRegistration _copy() {
        WindowsInformationProtectionDeviceRegistration _x = new WindowsInformationProtectionDeviceRegistration();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.userId = userId;
        _x.deviceRegistrationId = deviceRegistrationId;
        _x.deviceName = deviceName;
        _x.deviceType = deviceType;
        _x.deviceMacAddress = deviceMacAddress;
        _x.lastCheckInDateTime = lastCheckInDateTime;
        return _x;
    }

    @Action(name = "wipe")
    @JsonIgnore
    public ActionRequestNoReturn wipe() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.wipe"), _parameters);
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("WindowsInformationProtectionDeviceRegistration[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("userId=");
        b.append(this.userId);
        b.append(", ");
        b.append("deviceRegistrationId=");
        b.append(this.deviceRegistrationId);
        b.append(", ");
        b.append("deviceName=");
        b.append(this.deviceName);
        b.append(", ");
        b.append("deviceType=");
        b.append(this.deviceType);
        b.append(", ");
        b.append("deviceMacAddress=");
        b.append(this.deviceMacAddress);
        b.append(", ");
        b.append("lastCheckInDateTime=");
        b.append(this.lastCheckInDateTime);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
