package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;


/**
 * <i>“Windows Information Protection AppLocker File”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "displayName", 
    "fileHash", 
    "file", 
    "version"})
@JsonInclude(Include.NON_NULL)
public class WindowsInformationProtectionAppLockerFile extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.windowsInformationProtectionAppLockerFile";
    }

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("fileHash")
    protected String fileHash;

    @JsonProperty("file")
    protected byte[] file;

    @JsonProperty("version")
    protected String version;

    protected WindowsInformationProtectionAppLockerFile() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderWindowsInformationProtectionAppLockerFile() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String displayName;
        private String fileHash;
        private byte[] file;
        private String version;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        /**
         * <i>“The friendly name”</i>
         * 
         * @param displayName
         *            value of {@code displayName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        /**
         * <i>“SHA256 hash of the file”</i>
         * 
         * @param fileHash
         *            value of {@code fileHash} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder fileHash(String fileHash) {
            this.fileHash = fileHash;
            this.changedFields = changedFields.add("fileHash");
            return this;
        }

        /**
         * <i>“File as a byte array”</i>
         * 
         * @param file
         *            value of {@code file} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder file(byte[] file) {
            this.file = file;
            this.changedFields = changedFields.add("file");
            return this;
        }

        /**
         * <i>“Version of the entity.”</i>
         * 
         * @param version
         *            value of {@code version} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder version(String version) {
            this.version = version;
            this.changedFields = changedFields.add("version");
            return this;
        }

        public WindowsInformationProtectionAppLockerFile build() {
            WindowsInformationProtectionAppLockerFile _x = new WindowsInformationProtectionAppLockerFile();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.windowsInformationProtectionAppLockerFile";
            _x.id = id;
            _x.displayName = displayName;
            _x.fileHash = fileHash;
            _x.file = file;
            _x.version = version;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    /**
     * <i>“The friendly name”</i>
     * 
     * @return property displayName
     */
    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code displayName}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The friendly name”</i>
     * 
     * @param displayName
     *            new value of {@code displayName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code displayName} field changed
     */
    public WindowsInformationProtectionAppLockerFile withDisplayName(String displayName) {
        WindowsInformationProtectionAppLockerFile _x = _copy();
        _x.changedFields = changedFields.add("displayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsInformationProtectionAppLockerFile");
        _x.displayName = displayName;
        return _x;
    }

    /**
     * <i>“SHA256 hash of the file”</i>
     * 
     * @return property fileHash
     */
    @Property(name="fileHash")
    @JsonIgnore
    public Optional<String> getFileHash() {
        return Optional.ofNullable(fileHash);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code fileHash} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“SHA256 hash of the file”</i>
     * 
     * @param fileHash
     *            new value of {@code fileHash} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code fileHash} field changed
     */
    public WindowsInformationProtectionAppLockerFile withFileHash(String fileHash) {
        WindowsInformationProtectionAppLockerFile _x = _copy();
        _x.changedFields = changedFields.add("fileHash");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsInformationProtectionAppLockerFile");
        _x.fileHash = fileHash;
        return _x;
    }

    /**
     * <i>“File as a byte array”</i>
     * 
     * @return property file
     */
    @Property(name="file")
    @JsonIgnore
    public Optional<byte[]> getFile() {
        return Optional.ofNullable(file);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code file} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“File as a byte array”</i>
     * 
     * @param file
     *            new value of {@code file} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code file} field changed
     */
    public WindowsInformationProtectionAppLockerFile withFile(byte[] file) {
        WindowsInformationProtectionAppLockerFile _x = _copy();
        _x.changedFields = changedFields.add("file");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsInformationProtectionAppLockerFile");
        _x.file = file;
        return _x;
    }

    /**
     * <i>“Version of the entity.”</i>
     * 
     * @return property version
     */
    @Property(name="version")
    @JsonIgnore
    public Optional<String> getVersion() {
        return Optional.ofNullable(version);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code version} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Version of the entity.”</i>
     * 
     * @param version
     *            new value of {@code version} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code version} field changed
     */
    public WindowsInformationProtectionAppLockerFile withVersion(String version) {
        WindowsInformationProtectionAppLockerFile _x = _copy();
        _x.changedFields = changedFields.add("version");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsInformationProtectionAppLockerFile");
        _x.version = version;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public WindowsInformationProtectionAppLockerFile patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        WindowsInformationProtectionAppLockerFile _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public WindowsInformationProtectionAppLockerFile put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        WindowsInformationProtectionAppLockerFile _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private WindowsInformationProtectionAppLockerFile _copy() {
        WindowsInformationProtectionAppLockerFile _x = new WindowsInformationProtectionAppLockerFile();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.displayName = displayName;
        _x.fileHash = fileHash;
        _x.file = file;
        _x.version = version;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("WindowsInformationProtectionAppLockerFile[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("fileHash=");
        b.append(this.fileHash);
        b.append(", ");
        b.append("file=");
        b.append(this.file);
        b.append(", ");
        b.append("version=");
        b.append(this.version);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
