package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;

import odata.msgraph.client.beta.enums.ApplicationType;


/**
 * <i>“Windows Information Protection AppLearning Summary entity.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "applicationName", 
    "applicationType", 
    "deviceCount"})
@JsonInclude(Include.NON_NULL)
public class WindowsInformationProtectionAppLearningSummary extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.windowsInformationProtectionAppLearningSummary";
    }

    @JsonProperty("applicationName")
    protected String applicationName;

    @JsonProperty("applicationType")
    protected ApplicationType applicationType;

    @JsonProperty("deviceCount")
    protected Integer deviceCount;

    protected WindowsInformationProtectionAppLearningSummary() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderWindowsInformationProtectionAppLearningSummary() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String applicationName;
        private ApplicationType applicationType;
        private Integer deviceCount;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        /**
         * <i>“Application Name”</i>
         * 
         * @param applicationName
         *            value of {@code applicationName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder applicationName(String applicationName) {
            this.applicationName = applicationName;
            this.changedFields = changedFields.add("applicationName");
            return this;
        }

        /**
         * <i>“Application Type”</i>
         * 
         * @param applicationType
         *            value of {@code applicationType} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder applicationType(ApplicationType applicationType) {
            this.applicationType = applicationType;
            this.changedFields = changedFields.add("applicationType");
            return this;
        }

        /**
         * <i>“Device Count”</i>
         * 
         * @param deviceCount
         *            value of {@code deviceCount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder deviceCount(Integer deviceCount) {
            this.deviceCount = deviceCount;
            this.changedFields = changedFields.add("deviceCount");
            return this;
        }

        public WindowsInformationProtectionAppLearningSummary build() {
            WindowsInformationProtectionAppLearningSummary _x = new WindowsInformationProtectionAppLearningSummary();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.windowsInformationProtectionAppLearningSummary";
            _x.id = id;
            _x.applicationName = applicationName;
            _x.applicationType = applicationType;
            _x.deviceCount = deviceCount;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    /**
     * <i>“Application Name”</i>
     * 
     * @return property applicationName
     */
    @Property(name="applicationName")
    @JsonIgnore
    public Optional<String> getApplicationName() {
        return Optional.ofNullable(applicationName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code applicationName}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Application Name”</i>
     * 
     * @param applicationName
     *            new value of {@code applicationName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code applicationName} field changed
     */
    public WindowsInformationProtectionAppLearningSummary withApplicationName(String applicationName) {
        WindowsInformationProtectionAppLearningSummary _x = _copy();
        _x.changedFields = changedFields.add("applicationName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsInformationProtectionAppLearningSummary");
        _x.applicationName = applicationName;
        return _x;
    }

    /**
     * <i>“Application Type”</i>
     * 
     * @return property applicationType
     */
    @Property(name="applicationType")
    @JsonIgnore
    public Optional<ApplicationType> getApplicationType() {
        return Optional.ofNullable(applicationType);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code applicationType}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Application Type”</i>
     * 
     * @param applicationType
     *            new value of {@code applicationType} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code applicationType} field changed
     */
    public WindowsInformationProtectionAppLearningSummary withApplicationType(ApplicationType applicationType) {
        WindowsInformationProtectionAppLearningSummary _x = _copy();
        _x.changedFields = changedFields.add("applicationType");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsInformationProtectionAppLearningSummary");
        _x.applicationType = applicationType;
        return _x;
    }

    /**
     * <i>“Device Count”</i>
     * 
     * @return property deviceCount
     */
    @Property(name="deviceCount")
    @JsonIgnore
    public Optional<Integer> getDeviceCount() {
        return Optional.ofNullable(deviceCount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code deviceCount}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Device Count”</i>
     * 
     * @param deviceCount
     *            new value of {@code deviceCount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code deviceCount} field changed
     */
    public WindowsInformationProtectionAppLearningSummary withDeviceCount(Integer deviceCount) {
        WindowsInformationProtectionAppLearningSummary _x = _copy();
        _x.changedFields = changedFields.add("deviceCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsInformationProtectionAppLearningSummary");
        _x.deviceCount = deviceCount;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public WindowsInformationProtectionAppLearningSummary patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        WindowsInformationProtectionAppLearningSummary _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public WindowsInformationProtectionAppLearningSummary put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        WindowsInformationProtectionAppLearningSummary _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private WindowsInformationProtectionAppLearningSummary _copy() {
        WindowsInformationProtectionAppLearningSummary _x = new WindowsInformationProtectionAppLearningSummary();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.applicationName = applicationName;
        _x.applicationType = applicationType;
        _x.deviceCount = deviceCount;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("WindowsInformationProtectionAppLearningSummary[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("applicationName=");
        b.append(this.applicationName);
        b.append(", ");
        b.append("applicationType=");
        b.append(this.applicationType);
        b.append(", ");
        b.append("deviceCount=");
        b.append(this.deviceCount);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
