package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.complex.DeviceManagementApplicabilityRuleDeviceMode;
import odata.msgraph.client.beta.complex.DeviceManagementApplicabilityRuleOsEdition;
import odata.msgraph.client.beta.complex.DeviceManagementApplicabilityRuleOsVersion;
import odata.msgraph.client.beta.enums.Enablement;
import odata.msgraph.client.beta.enums.WindowsHealthMonitoringScope;


/**
 * <i>“Windows device health monitoring configuration”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "allowDeviceHealthMonitoring", 
    "configDeviceHealthMonitoringScope", 
    "configDeviceHealthMonitoringCustomScope"})
@JsonInclude(Include.NON_NULL)
public class WindowsHealthMonitoringConfiguration extends DeviceConfiguration implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.windowsHealthMonitoringConfiguration";
    }

    @JsonProperty("allowDeviceHealthMonitoring")
    protected Enablement allowDeviceHealthMonitoring;

    @JsonProperty("configDeviceHealthMonitoringScope")
    protected WindowsHealthMonitoringScope configDeviceHealthMonitoringScope;

    @JsonProperty("configDeviceHealthMonitoringCustomScope")
    protected String configDeviceHealthMonitoringCustomScope;

    protected WindowsHealthMonitoringConfiguration() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderWindowsHealthMonitoringConfiguration() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private OffsetDateTime lastModifiedDateTime;
        private List<String> roleScopeTagIds;
        private String roleScopeTagIdsNextLink;
        private Boolean supportsScopeTags;
        private DeviceManagementApplicabilityRuleOsEdition deviceManagementApplicabilityRuleOsEdition;
        private DeviceManagementApplicabilityRuleOsVersion deviceManagementApplicabilityRuleOsVersion;
        private DeviceManagementApplicabilityRuleDeviceMode deviceManagementApplicabilityRuleDeviceMode;
        private OffsetDateTime createdDateTime;
        private String description;
        private String displayName;
        private Integer version;
        private Enablement allowDeviceHealthMonitoring;
        private WindowsHealthMonitoringScope configDeviceHealthMonitoringScope;
        private String configDeviceHealthMonitoringCustomScope;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder lastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
            this.lastModifiedDateTime = lastModifiedDateTime;
            this.changedFields = changedFields.add("lastModifiedDateTime");
            return this;
        }

        public Builder roleScopeTagIds(List<String> roleScopeTagIds) {
            this.roleScopeTagIds = roleScopeTagIds;
            this.changedFields = changedFields.add("roleScopeTagIds");
            return this;
        }

        public Builder roleScopeTagIds(String... roleScopeTagIds) {
            return roleScopeTagIds(Arrays.asList(roleScopeTagIds));
        }

        public Builder roleScopeTagIdsNextLink(String roleScopeTagIdsNextLink) {
            this.roleScopeTagIdsNextLink = roleScopeTagIdsNextLink;
            this.changedFields = changedFields.add("roleScopeTagIds");
            return this;
        }

        public Builder supportsScopeTags(Boolean supportsScopeTags) {
            this.supportsScopeTags = supportsScopeTags;
            this.changedFields = changedFields.add("supportsScopeTags");
            return this;
        }

        public Builder deviceManagementApplicabilityRuleOsEdition(DeviceManagementApplicabilityRuleOsEdition deviceManagementApplicabilityRuleOsEdition) {
            this.deviceManagementApplicabilityRuleOsEdition = deviceManagementApplicabilityRuleOsEdition;
            this.changedFields = changedFields.add("deviceManagementApplicabilityRuleOsEdition");
            return this;
        }

        public Builder deviceManagementApplicabilityRuleOsVersion(DeviceManagementApplicabilityRuleOsVersion deviceManagementApplicabilityRuleOsVersion) {
            this.deviceManagementApplicabilityRuleOsVersion = deviceManagementApplicabilityRuleOsVersion;
            this.changedFields = changedFields.add("deviceManagementApplicabilityRuleOsVersion");
            return this;
        }

        public Builder deviceManagementApplicabilityRuleDeviceMode(DeviceManagementApplicabilityRuleDeviceMode deviceManagementApplicabilityRuleDeviceMode) {
            this.deviceManagementApplicabilityRuleDeviceMode = deviceManagementApplicabilityRuleDeviceMode;
            this.changedFields = changedFields.add("deviceManagementApplicabilityRuleDeviceMode");
            return this;
        }

        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder version(Integer version) {
            this.version = version;
            this.changedFields = changedFields.add("version");
            return this;
        }

        /**
         * <i>“Enables device health monitoring on the device”</i>
         * 
         * @param allowDeviceHealthMonitoring
         *            value of {@code allowDeviceHealthMonitoring} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder allowDeviceHealthMonitoring(Enablement allowDeviceHealthMonitoring) {
            this.allowDeviceHealthMonitoring = allowDeviceHealthMonitoring;
            this.changedFields = changedFields.add("allowDeviceHealthMonitoring");
            return this;
        }

        /**
         * <i>“Specifies set of events collected from the device where health monitoring is
         * enabled”</i>
         * 
         * @param configDeviceHealthMonitoringScope
         *            value of {@code configDeviceHealthMonitoringScope} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder configDeviceHealthMonitoringScope(WindowsHealthMonitoringScope configDeviceHealthMonitoringScope) {
            this.configDeviceHealthMonitoringScope = configDeviceHealthMonitoringScope;
            this.changedFields = changedFields.add("configDeviceHealthMonitoringScope");
            return this;
        }

        /**
         * <i>“Specifies custom set of events collected from the device where health monitoring
         * is enabled”</i>
         * 
         * @param configDeviceHealthMonitoringCustomScope
         *            value of {@code configDeviceHealthMonitoringCustomScope} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder configDeviceHealthMonitoringCustomScope(String configDeviceHealthMonitoringCustomScope) {
            this.configDeviceHealthMonitoringCustomScope = configDeviceHealthMonitoringCustomScope;
            this.changedFields = changedFields.add("configDeviceHealthMonitoringCustomScope");
            return this;
        }

        public WindowsHealthMonitoringConfiguration build() {
            WindowsHealthMonitoringConfiguration _x = new WindowsHealthMonitoringConfiguration();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.windowsHealthMonitoringConfiguration";
            _x.id = id;
            _x.lastModifiedDateTime = lastModifiedDateTime;
            _x.roleScopeTagIds = roleScopeTagIds;
            _x.roleScopeTagIdsNextLink = roleScopeTagIdsNextLink;
            _x.supportsScopeTags = supportsScopeTags;
            _x.deviceManagementApplicabilityRuleOsEdition = deviceManagementApplicabilityRuleOsEdition;
            _x.deviceManagementApplicabilityRuleOsVersion = deviceManagementApplicabilityRuleOsVersion;
            _x.deviceManagementApplicabilityRuleDeviceMode = deviceManagementApplicabilityRuleDeviceMode;
            _x.createdDateTime = createdDateTime;
            _x.description = description;
            _x.displayName = displayName;
            _x.version = version;
            _x.allowDeviceHealthMonitoring = allowDeviceHealthMonitoring;
            _x.configDeviceHealthMonitoringScope = configDeviceHealthMonitoringScope;
            _x.configDeviceHealthMonitoringCustomScope = configDeviceHealthMonitoringCustomScope;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    /**
     * <i>“Enables device health monitoring on the device”</i>
     * 
     * @return property allowDeviceHealthMonitoring
     */
    @Property(name="allowDeviceHealthMonitoring")
    @JsonIgnore
    public Optional<Enablement> getAllowDeviceHealthMonitoring() {
        return Optional.ofNullable(allowDeviceHealthMonitoring);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * allowDeviceHealthMonitoring} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Enables device health monitoring on the device”</i>
     * 
     * @param allowDeviceHealthMonitoring
     *            new value of {@code allowDeviceHealthMonitoring} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code allowDeviceHealthMonitoring} field changed
     */
    public WindowsHealthMonitoringConfiguration withAllowDeviceHealthMonitoring(Enablement allowDeviceHealthMonitoring) {
        WindowsHealthMonitoringConfiguration _x = _copy();
        _x.changedFields = changedFields.add("allowDeviceHealthMonitoring");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsHealthMonitoringConfiguration");
        _x.allowDeviceHealthMonitoring = allowDeviceHealthMonitoring;
        return _x;
    }

    /**
     * <i>“Specifies set of events collected from the device where health monitoring is
     * enabled”</i>
     * 
     * @return property configDeviceHealthMonitoringScope
     */
    @Property(name="configDeviceHealthMonitoringScope")
    @JsonIgnore
    public Optional<WindowsHealthMonitoringScope> getConfigDeviceHealthMonitoringScope() {
        return Optional.ofNullable(configDeviceHealthMonitoringScope);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * configDeviceHealthMonitoringScope} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Specifies set of events collected from the device where health monitoring is
     * enabled”</i>
     * 
     * @param configDeviceHealthMonitoringScope
     *            new value of {@code configDeviceHealthMonitoringScope} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code configDeviceHealthMonitoringScope} field changed
     */
    public WindowsHealthMonitoringConfiguration withConfigDeviceHealthMonitoringScope(WindowsHealthMonitoringScope configDeviceHealthMonitoringScope) {
        WindowsHealthMonitoringConfiguration _x = _copy();
        _x.changedFields = changedFields.add("configDeviceHealthMonitoringScope");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsHealthMonitoringConfiguration");
        _x.configDeviceHealthMonitoringScope = configDeviceHealthMonitoringScope;
        return _x;
    }

    /**
     * <i>“Specifies custom set of events collected from the device where health monitoring
     * is enabled”</i>
     * 
     * @return property configDeviceHealthMonitoringCustomScope
     */
    @Property(name="configDeviceHealthMonitoringCustomScope")
    @JsonIgnore
    public Optional<String> getConfigDeviceHealthMonitoringCustomScope() {
        return Optional.ofNullable(configDeviceHealthMonitoringCustomScope);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * configDeviceHealthMonitoringCustomScope} field changed. Field description below.
     * The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Specifies custom set of events collected from the device where health monitoring
     * is enabled”</i>
     * 
     * @param configDeviceHealthMonitoringCustomScope
     *            new value of {@code configDeviceHealthMonitoringCustomScope} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code configDeviceHealthMonitoringCustomScope} field changed
     */
    public WindowsHealthMonitoringConfiguration withConfigDeviceHealthMonitoringCustomScope(String configDeviceHealthMonitoringCustomScope) {
        WindowsHealthMonitoringConfiguration _x = _copy();
        _x.changedFields = changedFields.add("configDeviceHealthMonitoringCustomScope");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsHealthMonitoringConfiguration");
        _x.configDeviceHealthMonitoringCustomScope = configDeviceHealthMonitoringCustomScope;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public WindowsHealthMonitoringConfiguration patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        WindowsHealthMonitoringConfiguration _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public WindowsHealthMonitoringConfiguration put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        WindowsHealthMonitoringConfiguration _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private WindowsHealthMonitoringConfiguration _copy() {
        WindowsHealthMonitoringConfiguration _x = new WindowsHealthMonitoringConfiguration();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        _x.roleScopeTagIds = roleScopeTagIds;
        _x.supportsScopeTags = supportsScopeTags;
        _x.deviceManagementApplicabilityRuleOsEdition = deviceManagementApplicabilityRuleOsEdition;
        _x.deviceManagementApplicabilityRuleOsVersion = deviceManagementApplicabilityRuleOsVersion;
        _x.deviceManagementApplicabilityRuleDeviceMode = deviceManagementApplicabilityRuleDeviceMode;
        _x.createdDateTime = createdDateTime;
        _x.description = description;
        _x.displayName = displayName;
        _x.version = version;
        _x.allowDeviceHealthMonitoring = allowDeviceHealthMonitoring;
        _x.configDeviceHealthMonitoringScope = configDeviceHealthMonitoringScope;
        _x.configDeviceHealthMonitoringCustomScope = configDeviceHealthMonitoringCustomScope;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("WindowsHealthMonitoringConfiguration[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append(", ");
        b.append("roleScopeTagIds=");
        b.append(this.roleScopeTagIds);
        b.append(", ");
        b.append("supportsScopeTags=");
        b.append(this.supportsScopeTags);
        b.append(", ");
        b.append("deviceManagementApplicabilityRuleOsEdition=");
        b.append(this.deviceManagementApplicabilityRuleOsEdition);
        b.append(", ");
        b.append("deviceManagementApplicabilityRuleOsVersion=");
        b.append(this.deviceManagementApplicabilityRuleOsVersion);
        b.append(", ");
        b.append("deviceManagementApplicabilityRuleDeviceMode=");
        b.append(this.deviceManagementApplicabilityRuleDeviceMode);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("version=");
        b.append(this.version);
        b.append(", ");
        b.append("allowDeviceHealthMonitoring=");
        b.append(this.allowDeviceHealthMonitoring);
        b.append(", ");
        b.append("configDeviceHealthMonitoringScope=");
        b.append(this.configDeviceHealthMonitoringScope);
        b.append(", ");
        b.append("configDeviceHealthMonitoringCustomScope=");
        b.append(this.configDeviceHealthMonitoringCustomScope);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
