package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.complex.DeviceManagementApplicabilityRuleDeviceMode;
import odata.msgraph.client.beta.complex.DeviceManagementApplicabilityRuleOsEdition;
import odata.msgraph.client.beta.complex.DeviceManagementApplicabilityRuleOsVersion;
import odata.msgraph.client.beta.entity.collection.request.DeviceConfigurationCollectionRequest;


/**
 * <i>“Windows Domain Join device configuration.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "computerNameStaticPrefix", 
    "computerNameSuffixRandomCharCount", 
    "activeDirectoryDomainName", 
    "organizationalUnit"})
@JsonInclude(Include.NON_NULL)
public class WindowsDomainJoinConfiguration extends DeviceConfiguration implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.windowsDomainJoinConfiguration";
    }

    @JsonProperty("computerNameStaticPrefix")
    protected String computerNameStaticPrefix;

    @JsonProperty("computerNameSuffixRandomCharCount")
    protected Integer computerNameSuffixRandomCharCount;

    @JsonProperty("activeDirectoryDomainName")
    protected String activeDirectoryDomainName;

    @JsonProperty("organizationalUnit")
    protected String organizationalUnit;

    protected WindowsDomainJoinConfiguration() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderWindowsDomainJoinConfiguration() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private OffsetDateTime lastModifiedDateTime;
        private List<String> roleScopeTagIds;
        private String roleScopeTagIdsNextLink;
        private Boolean supportsScopeTags;
        private DeviceManagementApplicabilityRuleOsEdition deviceManagementApplicabilityRuleOsEdition;
        private DeviceManagementApplicabilityRuleOsVersion deviceManagementApplicabilityRuleOsVersion;
        private DeviceManagementApplicabilityRuleDeviceMode deviceManagementApplicabilityRuleDeviceMode;
        private OffsetDateTime createdDateTime;
        private String description;
        private String displayName;
        private Integer version;
        private String computerNameStaticPrefix;
        private Integer computerNameSuffixRandomCharCount;
        private String activeDirectoryDomainName;
        private String organizationalUnit;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder lastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
            this.lastModifiedDateTime = lastModifiedDateTime;
            this.changedFields = changedFields.add("lastModifiedDateTime");
            return this;
        }

        public Builder roleScopeTagIds(List<String> roleScopeTagIds) {
            this.roleScopeTagIds = roleScopeTagIds;
            this.changedFields = changedFields.add("roleScopeTagIds");
            return this;
        }

        public Builder roleScopeTagIds(String... roleScopeTagIds) {
            return roleScopeTagIds(Arrays.asList(roleScopeTagIds));
        }

        public Builder roleScopeTagIdsNextLink(String roleScopeTagIdsNextLink) {
            this.roleScopeTagIdsNextLink = roleScopeTagIdsNextLink;
            this.changedFields = changedFields.add("roleScopeTagIds");
            return this;
        }

        public Builder supportsScopeTags(Boolean supportsScopeTags) {
            this.supportsScopeTags = supportsScopeTags;
            this.changedFields = changedFields.add("supportsScopeTags");
            return this;
        }

        public Builder deviceManagementApplicabilityRuleOsEdition(DeviceManagementApplicabilityRuleOsEdition deviceManagementApplicabilityRuleOsEdition) {
            this.deviceManagementApplicabilityRuleOsEdition = deviceManagementApplicabilityRuleOsEdition;
            this.changedFields = changedFields.add("deviceManagementApplicabilityRuleOsEdition");
            return this;
        }

        public Builder deviceManagementApplicabilityRuleOsVersion(DeviceManagementApplicabilityRuleOsVersion deviceManagementApplicabilityRuleOsVersion) {
            this.deviceManagementApplicabilityRuleOsVersion = deviceManagementApplicabilityRuleOsVersion;
            this.changedFields = changedFields.add("deviceManagementApplicabilityRuleOsVersion");
            return this;
        }

        public Builder deviceManagementApplicabilityRuleDeviceMode(DeviceManagementApplicabilityRuleDeviceMode deviceManagementApplicabilityRuleDeviceMode) {
            this.deviceManagementApplicabilityRuleDeviceMode = deviceManagementApplicabilityRuleDeviceMode;
            this.changedFields = changedFields.add("deviceManagementApplicabilityRuleDeviceMode");
            return this;
        }

        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder version(Integer version) {
            this.version = version;
            this.changedFields = changedFields.add("version");
            return this;
        }

        /**
         * <i>“Fixed prefix to be used for computer name.”</i>
         * 
         * @param computerNameStaticPrefix
         *            value of {@code computerNameStaticPrefix} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder computerNameStaticPrefix(String computerNameStaticPrefix) {
            this.computerNameStaticPrefix = computerNameStaticPrefix;
            this.changedFields = changedFields.add("computerNameStaticPrefix");
            return this;
        }

        /**
         * <i>“Dynamically generated characters used as suffix for computer name. Valid values
         * 3 to 14”</i>
         * 
         * @param computerNameSuffixRandomCharCount
         *            value of {@code computerNameSuffixRandomCharCount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder computerNameSuffixRandomCharCount(Integer computerNameSuffixRandomCharCount) {
            this.computerNameSuffixRandomCharCount = computerNameSuffixRandomCharCount;
            this.changedFields = changedFields.add("computerNameSuffixRandomCharCount");
            return this;
        }

        /**
         * <i>“Active Directory domain name to join.”</i>
         * 
         * @param activeDirectoryDomainName
         *            value of {@code activeDirectoryDomainName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder activeDirectoryDomainName(String activeDirectoryDomainName) {
            this.activeDirectoryDomainName = activeDirectoryDomainName;
            this.changedFields = changedFields.add("activeDirectoryDomainName");
            return this;
        }

        /**
         * <i>“Organizational unit (OU) where the computer account will be created. If this
         * parameter is NULL, the well known computer object container will be used as
         * published in the domain.”</i>
         * 
         * @param organizationalUnit
         *            value of {@code organizationalUnit} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder organizationalUnit(String organizationalUnit) {
            this.organizationalUnit = organizationalUnit;
            this.changedFields = changedFields.add("organizationalUnit");
            return this;
        }

        public WindowsDomainJoinConfiguration build() {
            WindowsDomainJoinConfiguration _x = new WindowsDomainJoinConfiguration();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.windowsDomainJoinConfiguration";
            _x.id = id;
            _x.lastModifiedDateTime = lastModifiedDateTime;
            _x.roleScopeTagIds = roleScopeTagIds;
            _x.roleScopeTagIdsNextLink = roleScopeTagIdsNextLink;
            _x.supportsScopeTags = supportsScopeTags;
            _x.deviceManagementApplicabilityRuleOsEdition = deviceManagementApplicabilityRuleOsEdition;
            _x.deviceManagementApplicabilityRuleOsVersion = deviceManagementApplicabilityRuleOsVersion;
            _x.deviceManagementApplicabilityRuleDeviceMode = deviceManagementApplicabilityRuleDeviceMode;
            _x.createdDateTime = createdDateTime;
            _x.description = description;
            _x.displayName = displayName;
            _x.version = version;
            _x.computerNameStaticPrefix = computerNameStaticPrefix;
            _x.computerNameSuffixRandomCharCount = computerNameSuffixRandomCharCount;
            _x.activeDirectoryDomainName = activeDirectoryDomainName;
            _x.organizationalUnit = organizationalUnit;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    /**
     * <i>“Fixed prefix to be used for computer name.”</i>
     * 
     * @return property computerNameStaticPrefix
     */
    @Property(name="computerNameStaticPrefix")
    @JsonIgnore
    public Optional<String> getComputerNameStaticPrefix() {
        return Optional.ofNullable(computerNameStaticPrefix);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * computerNameStaticPrefix} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Fixed prefix to be used for computer name.”</i>
     * 
     * @param computerNameStaticPrefix
     *            new value of {@code computerNameStaticPrefix} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code computerNameStaticPrefix} field changed
     */
    public WindowsDomainJoinConfiguration withComputerNameStaticPrefix(String computerNameStaticPrefix) {
        WindowsDomainJoinConfiguration _x = _copy();
        _x.changedFields = changedFields.add("computerNameStaticPrefix");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsDomainJoinConfiguration");
        _x.computerNameStaticPrefix = computerNameStaticPrefix;
        return _x;
    }

    /**
     * <i>“Dynamically generated characters used as suffix for computer name. Valid values
     * 3 to 14”</i>
     * 
     * @return property computerNameSuffixRandomCharCount
     */
    @Property(name="computerNameSuffixRandomCharCount")
    @JsonIgnore
    public Optional<Integer> getComputerNameSuffixRandomCharCount() {
        return Optional.ofNullable(computerNameSuffixRandomCharCount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * computerNameSuffixRandomCharCount} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Dynamically generated characters used as suffix for computer name. Valid values
     * 3 to 14”</i>
     * 
     * @param computerNameSuffixRandomCharCount
     *            new value of {@code computerNameSuffixRandomCharCount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code computerNameSuffixRandomCharCount} field changed
     */
    public WindowsDomainJoinConfiguration withComputerNameSuffixRandomCharCount(Integer computerNameSuffixRandomCharCount) {
        WindowsDomainJoinConfiguration _x = _copy();
        _x.changedFields = changedFields.add("computerNameSuffixRandomCharCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsDomainJoinConfiguration");
        _x.computerNameSuffixRandomCharCount = computerNameSuffixRandomCharCount;
        return _x;
    }

    /**
     * <i>“Active Directory domain name to join.”</i>
     * 
     * @return property activeDirectoryDomainName
     */
    @Property(name="activeDirectoryDomainName")
    @JsonIgnore
    public Optional<String> getActiveDirectoryDomainName() {
        return Optional.ofNullable(activeDirectoryDomainName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * activeDirectoryDomainName} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Active Directory domain name to join.”</i>
     * 
     * @param activeDirectoryDomainName
     *            new value of {@code activeDirectoryDomainName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code activeDirectoryDomainName} field changed
     */
    public WindowsDomainJoinConfiguration withActiveDirectoryDomainName(String activeDirectoryDomainName) {
        WindowsDomainJoinConfiguration _x = _copy();
        _x.changedFields = changedFields.add("activeDirectoryDomainName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsDomainJoinConfiguration");
        _x.activeDirectoryDomainName = activeDirectoryDomainName;
        return _x;
    }

    /**
     * <i>“Organizational unit (OU) where the computer account will be created. If this
     * parameter is NULL, the well known computer object container will be used as
     * published in the domain.”</i>
     * 
     * @return property organizationalUnit
     */
    @Property(name="organizationalUnit")
    @JsonIgnore
    public Optional<String> getOrganizationalUnit() {
        return Optional.ofNullable(organizationalUnit);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * organizationalUnit} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Organizational unit (OU) where the computer account will be created. If this
     * parameter is NULL, the well known computer object container will be used as
     * published in the domain.”</i>
     * 
     * @param organizationalUnit
     *            new value of {@code organizationalUnit} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code organizationalUnit} field changed
     */
    public WindowsDomainJoinConfiguration withOrganizationalUnit(String organizationalUnit) {
        WindowsDomainJoinConfiguration _x = _copy();
        _x.changedFields = changedFields.add("organizationalUnit");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsDomainJoinConfiguration");
        _x.organizationalUnit = organizationalUnit;
        return _x;
    }

    /**
     * <i>“Reference to device configurations required for network connectivity”</i>
     * 
     * @return navigational property networkAccessConfigurations
     */
    @NavigationProperty(name="networkAccessConfigurations")
    @JsonIgnore
    public DeviceConfigurationCollectionRequest getNetworkAccessConfigurations() {
        return new DeviceConfigurationCollectionRequest(
                        contextPath.addSegment("networkAccessConfigurations"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public WindowsDomainJoinConfiguration patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        WindowsDomainJoinConfiguration _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public WindowsDomainJoinConfiguration put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        WindowsDomainJoinConfiguration _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private WindowsDomainJoinConfiguration _copy() {
        WindowsDomainJoinConfiguration _x = new WindowsDomainJoinConfiguration();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        _x.roleScopeTagIds = roleScopeTagIds;
        _x.supportsScopeTags = supportsScopeTags;
        _x.deviceManagementApplicabilityRuleOsEdition = deviceManagementApplicabilityRuleOsEdition;
        _x.deviceManagementApplicabilityRuleOsVersion = deviceManagementApplicabilityRuleOsVersion;
        _x.deviceManagementApplicabilityRuleDeviceMode = deviceManagementApplicabilityRuleDeviceMode;
        _x.createdDateTime = createdDateTime;
        _x.description = description;
        _x.displayName = displayName;
        _x.version = version;
        _x.computerNameStaticPrefix = computerNameStaticPrefix;
        _x.computerNameSuffixRandomCharCount = computerNameSuffixRandomCharCount;
        _x.activeDirectoryDomainName = activeDirectoryDomainName;
        _x.organizationalUnit = organizationalUnit;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("WindowsDomainJoinConfiguration[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append(", ");
        b.append("roleScopeTagIds=");
        b.append(this.roleScopeTagIds);
        b.append(", ");
        b.append("supportsScopeTags=");
        b.append(this.supportsScopeTags);
        b.append(", ");
        b.append("deviceManagementApplicabilityRuleOsEdition=");
        b.append(this.deviceManagementApplicabilityRuleOsEdition);
        b.append(", ");
        b.append("deviceManagementApplicabilityRuleOsVersion=");
        b.append(this.deviceManagementApplicabilityRuleOsVersion);
        b.append(", ");
        b.append("deviceManagementApplicabilityRuleDeviceMode=");
        b.append(this.deviceManagementApplicabilityRuleDeviceMode);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("version=");
        b.append(this.version);
        b.append(", ");
        b.append("computerNameStaticPrefix=");
        b.append(this.computerNameStaticPrefix);
        b.append(", ");
        b.append("computerNameSuffixRandomCharCount=");
        b.append(this.computerNameSuffixRandomCharCount);
        b.append(", ");
        b.append("activeDirectoryDomainName=");
        b.append(this.activeDirectoryDomainName);
        b.append(", ");
        b.append("organizationalUnit=");
        b.append(this.organizationalUnit);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
