package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.OffsetDateTime;
import java.util.Optional;

import odata.msgraph.client.beta.enums.WindowsMalwareCategory;
import odata.msgraph.client.beta.enums.WindowsMalwareExecutionState;
import odata.msgraph.client.beta.enums.WindowsMalwareSeverity;
import odata.msgraph.client.beta.enums.WindowsMalwareState;
import odata.msgraph.client.beta.enums.WindowsMalwareThreatState;


/**
 * <i>“Malware detection entity.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "displayName", 
    "additionalInformationUrl", 
    "severity", 
    "catetgory", 
    "executionState", 
    "state", 
    "threatState", 
    "initialDetectionDateTime", 
    "lastStateChangeDateTime", 
    "detectionCount", 
    "category"})
@JsonInclude(Include.NON_NULL)
public class WindowsDeviceMalwareState extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.windowsDeviceMalwareState";
    }

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("additionalInformationUrl")
    protected String additionalInformationUrl;

    @JsonProperty("severity")
    protected WindowsMalwareSeverity severity;

    @JsonProperty("catetgory")
    protected WindowsMalwareCategory catetgory;

    @JsonProperty("executionState")
    protected WindowsMalwareExecutionState executionState;

    @JsonProperty("state")
    protected WindowsMalwareState state;

    @JsonProperty("threatState")
    protected WindowsMalwareThreatState threatState;

    @JsonProperty("initialDetectionDateTime")
    protected OffsetDateTime initialDetectionDateTime;

    @JsonProperty("lastStateChangeDateTime")
    protected OffsetDateTime lastStateChangeDateTime;

    @JsonProperty("detectionCount")
    protected Integer detectionCount;

    @JsonProperty("category")
    protected WindowsMalwareCategory category;

    protected WindowsDeviceMalwareState() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderWindowsDeviceMalwareState() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String displayName;
        private String additionalInformationUrl;
        private WindowsMalwareSeverity severity;
        private WindowsMalwareCategory catetgory;
        private WindowsMalwareExecutionState executionState;
        private WindowsMalwareState state;
        private WindowsMalwareThreatState threatState;
        private OffsetDateTime initialDetectionDateTime;
        private OffsetDateTime lastStateChangeDateTime;
        private Integer detectionCount;
        private WindowsMalwareCategory category;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        /**
         * <i>“Malware name”</i>
         * 
         * @param displayName
         *            value of {@code displayName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        /**
         * <i>“Information URL to learn more about the malware”</i>
         * 
         * @param additionalInformationUrl
         *            value of {@code additionalInformationUrl} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder additionalInformationUrl(String additionalInformationUrl) {
            this.additionalInformationUrl = additionalInformationUrl;
            this.changedFields = changedFields.add("additionalInformationUrl");
            return this;
        }

        /**
         * <i>“Severity of the malware”</i>
         * 
         * @param severity
         *            value of {@code severity} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder severity(WindowsMalwareSeverity severity) {
            this.severity = severity;
            this.changedFields = changedFields.add("severity");
            return this;
        }

        /**
         * <i>“Category of the malware”</i>
         * 
         * @param catetgory
         *            value of {@code catetgory} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder catetgory(WindowsMalwareCategory catetgory) {
            this.catetgory = catetgory;
            this.changedFields = changedFields.add("catetgory");
            return this;
        }

        /**
         * <i>“Execution status of the malware like blocked/executing etc”</i>
         * 
         * @param executionState
         *            value of {@code executionState} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder executionState(WindowsMalwareExecutionState executionState) {
            this.executionState = executionState;
            this.changedFields = changedFields.add("executionState");
            return this;
        }

        /**
         * <i>“Current status of the malware like cleaned/quarantined/allowed etc”</i>
         * 
         * @param state
         *            value of {@code state} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder state(WindowsMalwareState state) {
            this.state = state;
            this.changedFields = changedFields.add("state");
            return this;
        }

        /**
         * <i>“Current status of the malware like cleaned/quarantined/allowed etc”</i>
         * 
         * @param threatState
         *            value of {@code threatState} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder threatState(WindowsMalwareThreatState threatState) {
            this.threatState = threatState;
            this.changedFields = changedFields.add("threatState");
            return this;
        }

        /**
         * <i>“Initial detection datetime of the malware”</i>
         * 
         * @param initialDetectionDateTime
         *            value of {@code initialDetectionDateTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder initialDetectionDateTime(OffsetDateTime initialDetectionDateTime) {
            this.initialDetectionDateTime = initialDetectionDateTime;
            this.changedFields = changedFields.add("initialDetectionDateTime");
            return this;
        }

        /**
         * <i>“The last time this particular threat was changed”</i>
         * 
         * @param lastStateChangeDateTime
         *            value of {@code lastStateChangeDateTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder lastStateChangeDateTime(OffsetDateTime lastStateChangeDateTime) {
            this.lastStateChangeDateTime = lastStateChangeDateTime;
            this.changedFields = changedFields.add("lastStateChangeDateTime");
            return this;
        }

        /**
         * <i>“Number of times the malware is detected”</i>
         * 
         * @param detectionCount
         *            value of {@code detectionCount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder detectionCount(Integer detectionCount) {
            this.detectionCount = detectionCount;
            this.changedFields = changedFields.add("detectionCount");
            return this;
        }

        /**
         * <i>“Category of the malware”</i>
         * 
         * @param category
         *            value of {@code category} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder category(WindowsMalwareCategory category) {
            this.category = category;
            this.changedFields = changedFields.add("category");
            return this;
        }

        public WindowsDeviceMalwareState build() {
            WindowsDeviceMalwareState _x = new WindowsDeviceMalwareState();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.windowsDeviceMalwareState";
            _x.id = id;
            _x.displayName = displayName;
            _x.additionalInformationUrl = additionalInformationUrl;
            _x.severity = severity;
            _x.catetgory = catetgory;
            _x.executionState = executionState;
            _x.state = state;
            _x.threatState = threatState;
            _x.initialDetectionDateTime = initialDetectionDateTime;
            _x.lastStateChangeDateTime = lastStateChangeDateTime;
            _x.detectionCount = detectionCount;
            _x.category = category;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    /**
     * <i>“Malware name”</i>
     * 
     * @return property displayName
     */
    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code displayName}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Malware name”</i>
     * 
     * @param displayName
     *            new value of {@code displayName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code displayName} field changed
     */
    public WindowsDeviceMalwareState withDisplayName(String displayName) {
        WindowsDeviceMalwareState _x = _copy();
        _x.changedFields = changedFields.add("displayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsDeviceMalwareState");
        _x.displayName = displayName;
        return _x;
    }

    /**
     * <i>“Information URL to learn more about the malware”</i>
     * 
     * @return property additionalInformationUrl
     */
    @Property(name="additionalInformationUrl")
    @JsonIgnore
    public Optional<String> getAdditionalInformationUrl() {
        return Optional.ofNullable(additionalInformationUrl);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * additionalInformationUrl} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Information URL to learn more about the malware”</i>
     * 
     * @param additionalInformationUrl
     *            new value of {@code additionalInformationUrl} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code additionalInformationUrl} field changed
     */
    public WindowsDeviceMalwareState withAdditionalInformationUrl(String additionalInformationUrl) {
        WindowsDeviceMalwareState _x = _copy();
        _x.changedFields = changedFields.add("additionalInformationUrl");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsDeviceMalwareState");
        _x.additionalInformationUrl = additionalInformationUrl;
        return _x;
    }

    /**
     * <i>“Severity of the malware”</i>
     * 
     * @return property severity
     */
    @Property(name="severity")
    @JsonIgnore
    public Optional<WindowsMalwareSeverity> getSeverity() {
        return Optional.ofNullable(severity);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code severity} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Severity of the malware”</i>
     * 
     * @param severity
     *            new value of {@code severity} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code severity} field changed
     */
    public WindowsDeviceMalwareState withSeverity(WindowsMalwareSeverity severity) {
        WindowsDeviceMalwareState _x = _copy();
        _x.changedFields = changedFields.add("severity");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsDeviceMalwareState");
        _x.severity = severity;
        return _x;
    }

    /**
     * <i>“Category of the malware”</i>
     * 
     * @return property catetgory
     */
    @Property(name="catetgory")
    @JsonIgnore
    public Optional<WindowsMalwareCategory> getCatetgory() {
        return Optional.ofNullable(catetgory);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code catetgory} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Category of the malware”</i>
     * 
     * @param catetgory
     *            new value of {@code catetgory} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code catetgory} field changed
     */
    public WindowsDeviceMalwareState withCatetgory(WindowsMalwareCategory catetgory) {
        WindowsDeviceMalwareState _x = _copy();
        _x.changedFields = changedFields.add("catetgory");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsDeviceMalwareState");
        _x.catetgory = catetgory;
        return _x;
    }

    /**
     * <i>“Execution status of the malware like blocked/executing etc”</i>
     * 
     * @return property executionState
     */
    @Property(name="executionState")
    @JsonIgnore
    public Optional<WindowsMalwareExecutionState> getExecutionState() {
        return Optional.ofNullable(executionState);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code executionState}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Execution status of the malware like blocked/executing etc”</i>
     * 
     * @param executionState
     *            new value of {@code executionState} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code executionState} field changed
     */
    public WindowsDeviceMalwareState withExecutionState(WindowsMalwareExecutionState executionState) {
        WindowsDeviceMalwareState _x = _copy();
        _x.changedFields = changedFields.add("executionState");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsDeviceMalwareState");
        _x.executionState = executionState;
        return _x;
    }

    /**
     * <i>“Current status of the malware like cleaned/quarantined/allowed etc”</i>
     * 
     * @return property state
     */
    @Property(name="state")
    @JsonIgnore
    public Optional<WindowsMalwareState> getState() {
        return Optional.ofNullable(state);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code state} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Current status of the malware like cleaned/quarantined/allowed etc”</i>
     * 
     * @param state
     *            new value of {@code state} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code state} field changed
     */
    public WindowsDeviceMalwareState withState(WindowsMalwareState state) {
        WindowsDeviceMalwareState _x = _copy();
        _x.changedFields = changedFields.add("state");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsDeviceMalwareState");
        _x.state = state;
        return _x;
    }

    /**
     * <i>“Current status of the malware like cleaned/quarantined/allowed etc”</i>
     * 
     * @return property threatState
     */
    @Property(name="threatState")
    @JsonIgnore
    public Optional<WindowsMalwareThreatState> getThreatState() {
        return Optional.ofNullable(threatState);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code threatState}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Current status of the malware like cleaned/quarantined/allowed etc”</i>
     * 
     * @param threatState
     *            new value of {@code threatState} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code threatState} field changed
     */
    public WindowsDeviceMalwareState withThreatState(WindowsMalwareThreatState threatState) {
        WindowsDeviceMalwareState _x = _copy();
        _x.changedFields = changedFields.add("threatState");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsDeviceMalwareState");
        _x.threatState = threatState;
        return _x;
    }

    /**
     * <i>“Initial detection datetime of the malware”</i>
     * 
     * @return property initialDetectionDateTime
     */
    @Property(name="initialDetectionDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getInitialDetectionDateTime() {
        return Optional.ofNullable(initialDetectionDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * initialDetectionDateTime} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Initial detection datetime of the malware”</i>
     * 
     * @param initialDetectionDateTime
     *            new value of {@code initialDetectionDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code initialDetectionDateTime} field changed
     */
    public WindowsDeviceMalwareState withInitialDetectionDateTime(OffsetDateTime initialDetectionDateTime) {
        WindowsDeviceMalwareState _x = _copy();
        _x.changedFields = changedFields.add("initialDetectionDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsDeviceMalwareState");
        _x.initialDetectionDateTime = initialDetectionDateTime;
        return _x;
    }

    /**
     * <i>“The last time this particular threat was changed”</i>
     * 
     * @return property lastStateChangeDateTime
     */
    @Property(name="lastStateChangeDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getLastStateChangeDateTime() {
        return Optional.ofNullable(lastStateChangeDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * lastStateChangeDateTime} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“The last time this particular threat was changed”</i>
     * 
     * @param lastStateChangeDateTime
     *            new value of {@code lastStateChangeDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code lastStateChangeDateTime} field changed
     */
    public WindowsDeviceMalwareState withLastStateChangeDateTime(OffsetDateTime lastStateChangeDateTime) {
        WindowsDeviceMalwareState _x = _copy();
        _x.changedFields = changedFields.add("lastStateChangeDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsDeviceMalwareState");
        _x.lastStateChangeDateTime = lastStateChangeDateTime;
        return _x;
    }

    /**
     * <i>“Number of times the malware is detected”</i>
     * 
     * @return property detectionCount
     */
    @Property(name="detectionCount")
    @JsonIgnore
    public Optional<Integer> getDetectionCount() {
        return Optional.ofNullable(detectionCount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code detectionCount}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Number of times the malware is detected”</i>
     * 
     * @param detectionCount
     *            new value of {@code detectionCount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code detectionCount} field changed
     */
    public WindowsDeviceMalwareState withDetectionCount(Integer detectionCount) {
        WindowsDeviceMalwareState _x = _copy();
        _x.changedFields = changedFields.add("detectionCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsDeviceMalwareState");
        _x.detectionCount = detectionCount;
        return _x;
    }

    /**
     * <i>“Category of the malware”</i>
     * 
     * @return property category
     */
    @Property(name="category")
    @JsonIgnore
    public Optional<WindowsMalwareCategory> getCategory() {
        return Optional.ofNullable(category);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code category} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Category of the malware”</i>
     * 
     * @param category
     *            new value of {@code category} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code category} field changed
     */
    public WindowsDeviceMalwareState withCategory(WindowsMalwareCategory category) {
        WindowsDeviceMalwareState _x = _copy();
        _x.changedFields = changedFields.add("category");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsDeviceMalwareState");
        _x.category = category;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public WindowsDeviceMalwareState patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        WindowsDeviceMalwareState _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public WindowsDeviceMalwareState put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        WindowsDeviceMalwareState _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private WindowsDeviceMalwareState _copy() {
        WindowsDeviceMalwareState _x = new WindowsDeviceMalwareState();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.displayName = displayName;
        _x.additionalInformationUrl = additionalInformationUrl;
        _x.severity = severity;
        _x.catetgory = catetgory;
        _x.executionState = executionState;
        _x.state = state;
        _x.threatState = threatState;
        _x.initialDetectionDateTime = initialDetectionDateTime;
        _x.lastStateChangeDateTime = lastStateChangeDateTime;
        _x.detectionCount = detectionCount;
        _x.category = category;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("WindowsDeviceMalwareState[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("additionalInformationUrl=");
        b.append(this.additionalInformationUrl);
        b.append(", ");
        b.append("severity=");
        b.append(this.severity);
        b.append(", ");
        b.append("catetgory=");
        b.append(this.catetgory);
        b.append(", ");
        b.append("executionState=");
        b.append(this.executionState);
        b.append(", ");
        b.append("state=");
        b.append(this.state);
        b.append(", ");
        b.append("threatState=");
        b.append(this.threatState);
        b.append(", ");
        b.append("initialDetectionDateTime=");
        b.append(this.initialDetectionDateTime);
        b.append(", ");
        b.append("lastStateChangeDateTime=");
        b.append(this.lastStateChangeDateTime);
        b.append(", ");
        b.append("detectionCount=");
        b.append(this.detectionCount);
        b.append(", ");
        b.append("category=");
        b.append(this.category);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
