package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;


/**
 * <i>“Contains properties for the deployment summary of a
 * WindowsDefenderApplicationControl supplemental policy.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "deployedDeviceCount", 
    "failedDeviceCount"})
@JsonInclude(Include.NON_NULL)
public class WindowsDefenderApplicationControlSupplementalPolicyDeploymentSummary extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.windowsDefenderApplicationControlSupplementalPolicyDeploymentSummary";
    }

    @JsonProperty("deployedDeviceCount")
    protected Integer deployedDeviceCount;

    @JsonProperty("failedDeviceCount")
    protected Integer failedDeviceCount;

    protected WindowsDefenderApplicationControlSupplementalPolicyDeploymentSummary() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderWindowsDefenderApplicationControlSupplementalPolicyDeploymentSummary() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private Integer deployedDeviceCount;
        private Integer failedDeviceCount;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        /**
         * <i>“Number of Devices that have successfully deployed this
         * WindowsDefenderApplicationControl supplemental policy.”</i>
         * 
         * @param deployedDeviceCount
         *            value of {@code deployedDeviceCount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder deployedDeviceCount(Integer deployedDeviceCount) {
            this.deployedDeviceCount = deployedDeviceCount;
            this.changedFields = changedFields.add("deployedDeviceCount");
            return this;
        }

        /**
         * <i>“Number of Devices that have failed to deploy this
         * WindowsDefenderApplicationControl supplemental policy.”</i>
         * 
         * @param failedDeviceCount
         *            value of {@code failedDeviceCount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder failedDeviceCount(Integer failedDeviceCount) {
            this.failedDeviceCount = failedDeviceCount;
            this.changedFields = changedFields.add("failedDeviceCount");
            return this;
        }

        public WindowsDefenderApplicationControlSupplementalPolicyDeploymentSummary build() {
            WindowsDefenderApplicationControlSupplementalPolicyDeploymentSummary _x = new WindowsDefenderApplicationControlSupplementalPolicyDeploymentSummary();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.windowsDefenderApplicationControlSupplementalPolicyDeploymentSummary";
            _x.id = id;
            _x.deployedDeviceCount = deployedDeviceCount;
            _x.failedDeviceCount = failedDeviceCount;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    /**
     * <i>“Number of Devices that have successfully deployed this
     * WindowsDefenderApplicationControl supplemental policy.”</i>
     * 
     * @return property deployedDeviceCount
     */
    @Property(name="deployedDeviceCount")
    @JsonIgnore
    public Optional<Integer> getDeployedDeviceCount() {
        return Optional.ofNullable(deployedDeviceCount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * deployedDeviceCount} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Number of Devices that have successfully deployed this
     * WindowsDefenderApplicationControl supplemental policy.”</i>
     * 
     * @param deployedDeviceCount
     *            new value of {@code deployedDeviceCount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code deployedDeviceCount} field changed
     */
    public WindowsDefenderApplicationControlSupplementalPolicyDeploymentSummary withDeployedDeviceCount(Integer deployedDeviceCount) {
        WindowsDefenderApplicationControlSupplementalPolicyDeploymentSummary _x = _copy();
        _x.changedFields = changedFields.add("deployedDeviceCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsDefenderApplicationControlSupplementalPolicyDeploymentSummary");
        _x.deployedDeviceCount = deployedDeviceCount;
        return _x;
    }

    /**
     * <i>“Number of Devices that have failed to deploy this
     * WindowsDefenderApplicationControl supplemental policy.”</i>
     * 
     * @return property failedDeviceCount
     */
    @Property(name="failedDeviceCount")
    @JsonIgnore
    public Optional<Integer> getFailedDeviceCount() {
        return Optional.ofNullable(failedDeviceCount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code failedDeviceCount
     * } field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Number of Devices that have failed to deploy this
     * WindowsDefenderApplicationControl supplemental policy.”</i>
     * 
     * @param failedDeviceCount
     *            new value of {@code failedDeviceCount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code failedDeviceCount} field changed
     */
    public WindowsDefenderApplicationControlSupplementalPolicyDeploymentSummary withFailedDeviceCount(Integer failedDeviceCount) {
        WindowsDefenderApplicationControlSupplementalPolicyDeploymentSummary _x = _copy();
        _x.changedFields = changedFields.add("failedDeviceCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsDefenderApplicationControlSupplementalPolicyDeploymentSummary");
        _x.failedDeviceCount = failedDeviceCount;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public WindowsDefenderApplicationControlSupplementalPolicyDeploymentSummary patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        WindowsDefenderApplicationControlSupplementalPolicyDeploymentSummary _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public WindowsDefenderApplicationControlSupplementalPolicyDeploymentSummary put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        WindowsDefenderApplicationControlSupplementalPolicyDeploymentSummary _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private WindowsDefenderApplicationControlSupplementalPolicyDeploymentSummary _copy() {
        WindowsDefenderApplicationControlSupplementalPolicyDeploymentSummary _x = new WindowsDefenderApplicationControlSupplementalPolicyDeploymentSummary();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.deployedDeviceCount = deployedDeviceCount;
        _x.failedDeviceCount = failedDeviceCount;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("WindowsDefenderApplicationControlSupplementalPolicyDeploymentSummary[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("deployedDeviceCount=");
        b.append(this.deployedDeviceCount);
        b.append(", ");
        b.append("failedDeviceCount=");
        b.append(this.failedDeviceCount);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
